/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.ws.management.commands.properties.resources.GenericType;
import com.ibm.ws.management.commands.properties.resources.ServerCluster;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.commands.properties.resources.common.SectionedPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.common.ValidationError;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.commands.properties.resources.properties.PropertiesFileData;
import com.ibm.ws.management.commands.properties.resources.properties.PropertiesFileParser;
import com.ibm.ws.management.commands.properties.resources.properties.Props;
import com.ibm.ws.management.commands.properties.resources.properties.Section;
import com.ibm.ws.management.commands.properties.resources.properties.UserDefinedVariableMap;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.wasresource.capability.IConfiguration;
import com.ibm.ws.management.wasresource.capability.ISectionConfiguration;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.WASResource;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceManager;
import com.ibm.ws.management.wasresource.common.WASResourceReferenceParameters;
import com.ibm.ws.management.wasresource.common.WASResourceUtilities;
import com.ibm.ws.management.wasresource.common.WASResourcesConstants;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class ConfigPropertiesHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigPropertiesHelper.class, "ConfigPropertiesHelper", "com.ibm.ws.management.resources.configservice");
    public static String ALL = "All";
    public static String ERRORSONLY = "Errors";
    public static String ERRORSANDCHANGESONLY = "Errors_And_Changes";
    public static String NOSUBTYPES = "NO_SUBTYPES";
    public static String NOSUBTYPESANDEXTENTIONS = "NO_SUBTYPES_AND_EXTENSIONS";
    public static String SELECTEDSUBTYPES = "SELECTED_SUBTYPES";
    private static final String CELL_AUTHORIZATION_GROUP_CFG_ID = "CellAuthorizationGroup";
    public static String[] ErrorMessages = new String[]{"*E", "ADMG0809I", "ADMG0815I", "ADMG0826I", "ADMG0829I", "ADMG0831I", "ADMG0832I", "ADMG0833I", "ADMG0834I", "ADMG0835I", "ADMG0836I"};
    public static String[] ChangeMessages = new String[]{"ADMG0803I", "ADMG0804I", "ADMG0805I", "ADMG0806I", "ADMG0808I", "ADMG0811I", "ADMG0813I", "ADMG0814I", "ADMG0816I", "ADMG0827I", "ADMG0828I", "ADMG0830I"};
    public static List<String> TemplateObjectList = new ArrayList<String>();

    public static void extractTemplateProperties(Session session, ConfigService cs, String configType, OutputStream os, String sectionNumber) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractTemplateProperties", new Object[]{cs, session, configType, sectionNumber});
        }
        List wasResources = ConfigPropertiesHelper.getWASResources(session, configType, null);
        for (int i = 0; wasResources != null && i < wasResources.size(); ++i) {
            WASResource wasRes = (WASResource)wasResources.get(i);
            if (i != 0) {
                sectionNumber = sectionNumber + "_" + i;
            }
            if (wasRes instanceof PropWASResource) {
                PropWASResource pResource = (PropWASResource)wasRes;
                pResource.getReferenceProperties().put("CREATERESOURCE", new Boolean(true));
                pResource.setCurrentResourceType(pResource.getResourceType());
                SectionedProperties[] propArray = pResource.getCreateTemplateProperties();
                SectionedPropertiesHelper.writeProperties(propArray, os, pResource, sectionNumber);
                pResource.getReferenceProperties().put("DELETERESOURCE", new Boolean(true));
                propArray = pResource.getDeleteTemplateProperties();
                SectionedPropertiesHelper.writeProperties(propArray, os, pResource, sectionNumber);
                pResource.setCurrentResourceType(null);
                pResource.getReferenceProperties().remove("DELETERESOURCE");
                pResource.getReferenceProperties().remove("CREATERESOURCE");
                continue;
            }
            if (!(wasRes instanceof ISectionConfiguration)) continue;
            ISectionConfiguration iConfResource = (ISectionConfiguration)((Object)wasRes);
            wasRes.getReferenceProperties().put("CREATERESOURCE", new Boolean(true));
            SectionedProperties[] props = iConfResource.getCreateTemplateProperties();
            SectionedPropertiesHelper.writeConfigId(wasRes.getConfigID(), wasRes.getResourceType(), ((IConfiguration)((Object)iConfResource)).getUniqueId(), os, sectionNumber);
            SectionedPropertiesHelper.writeProperties(props, os, wasRes, sectionNumber);
            wasRes.getReferenceProperties().put("DELETERESOURCE", new Boolean(true));
            props = iConfResource.getDeleteTemplateProperties();
            SectionedPropertiesHelper.writeConfigId(wasRes.getConfigID(), wasRes.getResourceType(), ((IConfiguration)((Object)iConfResource)).getUniqueId(), os, sectionNumber);
            SectionedPropertiesHelper.writeProperties(props, os, wasRes, sectionNumber);
            wasRes.getReferenceProperties().remove("DELETERESOURCE");
            wasRes.getReferenceProperties().remove("CREATERESOURCE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractTemplateProperties");
        }
    }

    public static void extractProperties(Session session, ConfigService cs, ObjectName configDataId, OutputStream os, String sectionNumber, String extractingType, Properties options) throws Exception {
        ConfigPropertiesHelper.extractProperties(session, cs, configDataId, os, sectionNumber, extractingType, options, null, null, null);
    }

    public static void extractProperties(Session session, ConfigService cs, ObjectName configDataId, OutputStream os, String sectionNumber, String extractingType, Properties options, String filter, String[] selectedTypes, EnvVariables varObject) throws Exception {
        WASResource wasRes;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractProperties", new Object[]{cs, session, configDataId, sectionNumber, selectedTypes});
        }
        boolean genericType = false;
        List wasResources = null;
        if (configDataId == null) {
            int inx = extractingType.indexOf(":");
            String cId = extractingType.substring(0, inx);
            String cTyp = extractingType.substring(inx + 1);
            wasResources = ConfigPropertiesHelper.getWASResources(session, cTyp, cId);
        } else {
            wasResources = ConfigPropertiesHelper.getWASResources(session, configDataId);
        }
        if (wasResources == null || wasResources.size() <= 0) {
            wasResources = ConfigPropertiesHelper.getGenericWASResources(session, configDataId);
            genericType = true;
        }
        String savedSectionNumber = sectionNumber;
        for (i = 0; wasResources != null && i < wasResources.size(); ++i) {
            wasRes = (WASResource)wasResources.get(i);
            if (wasRes instanceof ServerCluster) {
                ServerCluster clusterRes = (ServerCluster)wasRes;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extracting type " + extractingType);
                }
                if (extractingType != null && extractingType.equals("ServerCluster")) {
                    if (filter == null || !filter.equals(NOSUBTYPES) && !filter.equals(NOSUBTYPESANDEXTENTIONS)) {
                        clusterRes.setIncludeMembers(true);
                    }
                } else {
                    clusterRes.setIncludeMembers(false);
                }
            }
            if (i != 0) {
                sectionNumber = sectionNumber + "_" + i;
            }
            if (options != null && options.getProperty("GENERATETEMPLATE", "false").equals("true")) {
                wasRes.getReferenceProperties().put("GENERATETEMPLATE", "true");
            }
            if (selectedTypes != null && selectedTypes.length > 0) {
                wasRes.getReferenceProperties().put("SELECTEDSUBTYPES", selectedTypes);
            }
            if (ConfigPropertiesHelper.isExtensionSkiped(filter, wasRes)) continue;
            wasRes.getReferenceProperties().put("EnvironmentVariablesObject", varObject);
            ConfigPropertiesHelper.getAllPropertiesFromResource(session, cs, wasRes, os, sectionNumber);
            if (options != null && options.getProperty("GENERATETEMPLATE", "false").equals("true")) {
                wasRes.getReferenceProperties().remove("GENERATETEMPLATE");
            }
            if (selectedTypes != null && selectedTypes.length > 0 && filter != null && filter.equals(SELECTEDSUBTYPES)) {
                wasRes.getReferenceProperties().remove("SELECTEDSUBTYPES");
            }
            wasRes.getReferenceProperties().remove("EnvironmentVariablesObject");
        }
        if (filter == null || !filter.equals(NOSUBTYPES) && !filter.equals(NOSUBTYPESANDEXTENTIONS)) {
            for (i = 0; !genericType && wasResources != null && i < wasResources.size(); ++i) {
                wasRes = (WASResource)wasResources.get(i);
                sectionNumber = ConfigPropertiesHelper.nextSectionNumber(sectionNumber, i, true);
                List childResources = wasRes.getRelationships(1, false);
                for (int j = 0; childResources != null && j < childResources.size(); ++j) {
                    WASResourceReferenceParameters childResRef = (WASResourceReferenceParameters)childResources.get(j);
                    WASResource childRes = WASResourceManager.getInstance().createResource(childResRef.getReferenceProperties(), session);
                    if (childRes instanceof GenericType) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Found a child for which there is no implementation. Not processing : ", childResources.get(j));
                        continue;
                    }
                    sectionNumber = ConfigPropertiesHelper.nextSectionNumber(sectionNumber, j, false);
                    if (childRes.getConfigData() == null) {
                        String configIdAndConfigType = (String)childRes.getReferenceProperties().get(WASResourcesConstants.WAS_WSDM_Resource_ConfigID) + ":" + childRes.getResourceType();
                        ConfigPropertiesHelper.extractProperties(session, cs, childRes.getConfigData(), os, sectionNumber, configIdAndConfigType, options, filter, selectedTypes, varObject);
                        continue;
                    }
                    ConfigPropertiesHelper.extractProperties(session, cs, childRes.getConfigData(), os, sectionNumber, null, options, filter, selectedTypes, varObject);
                }
            }
        }
        for (i = 0; wasResources != null && i < wasResources.size(); ++i) {
            wasRes = (WASResource)wasResources.get(i);
            if (ConfigPropertiesHelper.isFiltered(wasRes, selectedTypes) || ConfigPropertiesHelper.isExtensionSkiped(filter, wasRes)) continue;
            if (i != 0) {
                savedSectionNumber = savedSectionNumber + "_" + i;
            }
            wasRes.getReferenceProperties().put("EnvironmentVariablesObject", varObject);
            SectionedPropertiesHelper.writeEndConfigId(wasRes.getConfigID(), null, os, savedSectionNumber, wasRes);
            wasRes.getReferenceProperties().remove("EnvironmentVariablesObject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractProperties");
        }
    }

    private static boolean isExtensionSkiped(String filter, WASResource wasRes) {
        Boolean ext;
        return filter != null && filter.equals(NOSUBTYPESANDEXTENTIONS) && (ext = (Boolean)wasRes.getReferenceProperties().get("WASResourceExtension")) != null && ext != false;
    }

    private static boolean isFiltered(WASResource res, String[] selectedTypes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFiltered", res.getResourceType());
        }
        boolean filtered = false;
        String cType = res.getResourceType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "selected types ", selectedTypes);
        }
        if (selectedTypes != null && selectedTypes.length > 0) {
            filtered = true;
            for (int i = 0; i < selectedTypes.length; ++i) {
                if (!cType.equals(selectedTypes[i])) continue;
                filtered = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFiltered", new Boolean(filtered));
        }
        return filtered;
    }

    public static String nextSectionNumber(String oldSectionNumber, int i, boolean newSection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextSectionNumber", new Object[]{oldSectionNumber, new Integer(i), new Boolean(newSection)});
        }
        String newSectionNumber = oldSectionNumber;
        if (newSection) {
            newSectionNumber = oldSectionNumber + "." + i;
        } else {
            String lastSectionNumber = oldSectionNumber;
            int inx = oldSectionNumber.lastIndexOf(".");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "last index ", new Integer(inx));
            }
            if (inx != -1) {
                lastSectionNumber = oldSectionNumber.substring(inx + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "last section number ", lastSectionNumber);
                }
                int n = Integer.parseInt(lastSectionNumber);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "last section number ", new Integer(n));
                }
                newSectionNumber = oldSectionNumber.substring(0, inx) + "." + i;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nextSectionNumber", newSectionNumber);
        }
        return newSectionNumber;
    }

    private static void getAllPropertiesFromResource(Session session, ConfigService cs, WASResource resource, OutputStream os, String sectionNumber) throws Exception {
        IConfiguration iConfResource;
        Properties props;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllPropertiesFromResource", new Object[]{cs, session, resource});
        }
        if (tc.isAuditEnabled()) {
            Tr.audit(tc, "Extracting configuration from " + resource.getResourceType() + ":" + resource.getConfigID());
        }
        if (resource instanceof PropWASResource) {
            PropWASResource pResource = (PropWASResource)resource;
            SectionedProperties[] propArray = pResource.getSectionedProperties();
            SectionedPropertiesHelper.writeProperties(propArray, os, pResource, sectionNumber);
        } else if (resource instanceof IConfiguration && (props = (iConfResource = (IConfiguration)((Object)resource)).getProperties()) != null && !props.isEmpty()) {
            String resId = resource.getConfigID();
            try {
                EnvVariables varObject = (EnvVariables)resource.getReferenceProperties().get("EnvironmentVariablesObject");
                resId = PropertiesUtils.convertConfigIdToConfigScope(resource.getConfigID(), resource.getSession(), resource.getConfigService(), varObject);
            }
            catch (Exception e) {
                resId = resource.getConfigID();
            }
            SectionedPropertiesHelper.writeConfigId(resId, resource.getResourceType(), iConfResource.getUniqueId(), os, sectionNumber);
            SectionedPropertiesHelper.writeProperties(props, os);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllPropertiesFromResource");
        }
    }

    private static void initializeAllResources(List resources, HashMap resourceProp) throws Exception {
        for (WASResource wasRes : resources) {
            wasRes.initialize(resourceProp);
        }
    }

    public static List getWASResources(Session session, ObjectName configData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWASResources", new Object[]{session, configData});
        }
        String configType = ConfigServiceHelper.getConfigDataType(configData);
        String configId = ConfigServiceHelper.getConfigDataId(configData).toString();
        if (configType != null && configType.equals("Deployment")) {
            configType = "Application";
        }
        List wasResources = ConfigPropertiesHelper.getWASResources(session, configType, configId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASResources", wasResources);
        }
        return wasResources;
    }

    public static List getGenericWASResources(Session session, ObjectName configData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGenericWASResources", configData);
        }
        String configType = "GenericType";
        String configId = ConfigServiceHelper.getConfigDataId(configData).toString();
        List wasResources = ConfigPropertiesHelper.getWASResources(session, configType, configId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGenericWASResources", wasResources);
        }
        return wasResources;
    }

    public static List getWASResources(Session session, String configType, String configId) {
        if (configType != null && configType.equals("Deployment")) {
            configType = "Application";
        }
        return ConfigPropertiesHelper.getWASResources(session, configType, configId, null);
    }

    public static List getWASResources(Session session, String configType, String configId, Section[] sections) {
        ArrayList<WASResource> wasResources;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWASResources", new Object[]{session, configType, configId, sections});
            }
            wasResources = new ArrayList<WASResource>();
            try {
                List resExts;
                HashMap<Object, Object> referenceProperties = new HashMap<Object, Object>();
                if (configId == null) {
                    referenceProperties.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(configType, "NONEXISTENTRESOURCE"));
                } else {
                    referenceProperties.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(configType, configId));
                }
                referenceProperties.put(WASResourcesConstants.WAS_WSDM_Resource_Type, configType);
                if (configId != null) {
                    referenceProperties.put(WASResourcesConstants.WAS_WSDM_Resource_ConfigID, configId);
                }
                if (sections != null) {
                    referenceProperties.put("ALLSECTIONS", sections);
                }
                WASResourceManager wasResMgr = WASResourceManager.getInstance();
                if (sections == null || sections[0].getExtensionId() == null) {
                    WASResource wasRes = wasResMgr.createResource(referenceProperties, session);
                    wasResources.add(wasRes);
                    List resExts2 = wasResMgr.createResourceExtension(referenceProperties, session);
                    wasResources.addAll(resExts2);
                } else if (sections != null && sections[0].getExtensionId() != null && (resExts = wasResMgr.createResourceExtension(referenceProperties, session)) != null) {
                    Iterator itr = resExts.iterator();
                    while (itr.hasNext()) {
                        WASResource wRes = (WASResource)itr.next();
                        if (wRes instanceof IConfiguration) {
                            IConfiguration iConf = (IConfiguration)((Object)wRes);
                            if (iConf.getUniqueId().equals(sections[0].getExtensionId())) continue;
                            itr.remove();
                            continue;
                        }
                        itr.remove();
                    }
                    wasResources.addAll(resExts);
                }
                ConfigPropertiesHelper.initializeAllResources(wasResources, referenceProperties);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Resource type is not registered ", configType);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASResources", wasResources);
        }
        return wasResources;
    }

    protected ObjectName getConfigData(String configId, Session session, ConfigService cs) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigData", new Object[]{configId, session, cs});
        }
        ObjectName type = configId.equals("Cell") ? ConfigServiceHelper.createObjectName(null, "Cell") : ConfigServiceHelper.createObjectName(new ConfigDataId(configId));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config type is " + type);
        }
        ObjectName resultConfigData = cs.queryConfigObjects(session, null, type, null)[0];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigData", resultConfigData);
        }
        return resultConfigData;
    }

    public static void logReport(FileOutputStream os, String key, Object[] objs) throws IOException {
        String auditMessage = TemplateConfigHelper.getFormattedMessage(resBundle, key, objs);
        if (tc.isAuditEnabled()) {
            Tr.audit(tc, auditMessage);
        }
        String newLine = "\n";
        if (os != null) {
            try {
                os.write(auditMessage.getBytes());
                os.write(newLine.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isFilterSet(WASResource res) {
        String filterSpec = (String)res.getReferenceProperties().get("REPORTFILTER");
        return filterSpec != null && !filterSpec.equals(ALL);
    }

    private static boolean filtered(WASResource res, String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filtered", new Object[]{res, key});
        }
        boolean filtered = false;
        String filterSpec = (String)res.getReferenceProperties().get("REPORTFILTER");
        if (filterSpec != null) {
            filtered = true;
            if (filterSpec.equals(ALL)) {
                filtered = false;
            } else if (filterSpec.equals(ERRORSONLY)) {
                if (ConfigPropertiesHelper.isError(key)) {
                    filtered = false;
                }
            } else if (filterSpec.equals(ERRORSANDCHANGESONLY) && (ConfigPropertiesHelper.isError(key) || ConfigPropertiesHelper.isChanges(key))) {
                filtered = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filtered", new Boolean(filtered));
        }
        return filtered;
    }

    public static boolean isError(String key) {
        boolean iserror = false;
        if (key.endsWith("E")) {
            iserror = true;
        } else {
            for (int i = 0; i < ErrorMessages.length; ++i) {
                if (!ErrorMessages[i].equals(key)) continue;
                iserror = true;
            }
        }
        return iserror;
    }

    private static boolean isChanges(String key) {
        boolean ischanges = false;
        for (int i = 0; i < ChangeMessages.length; ++i) {
            if (!ChangeMessages[i].equals(key)) continue;
            ischanges = true;
        }
        return ischanges;
    }

    private static String getSectionInfo(WASResource res) {
        String sectionInfo = null;
        Section[] sections = (Section[])res.getReferenceProperties().get("SECTIONS");
        if (sections != null && sections.length > 0) {
            sectionInfo = sections[0].getCfgId();
        }
        return "(Section=" + sectionInfo + ")";
    }

    private static String getSectionInfo(SectionData sectionData) {
        return sectionData.getType() + ":" + sectionData.getContainingType();
    }

    public static void logReport(WASResource res, FileOutputStream os, String key, Object[] objs) throws IOException {
        String auditMessage = TemplateConfigHelper.getFormattedMessage(resBundle, key, objs);
        if (tc.isAuditEnabled()) {
            Tr.audit(tc, auditMessage);
        }
        String newLine = "\n";
        String additionalMessage = null;
        if (os != null && ConfigPropertiesHelper.filtered(res, key)) {
            return;
        }
        if (ConfigPropertiesHelper.isFilterSet(res)) {
            additionalMessage = ConfigPropertiesHelper.getSectionInfo(res);
        }
        try {
            os.write(auditMessage.getBytes());
            if (additionalMessage != null) {
                os.write(additionalMessage.getBytes());
            }
            os.write(newLine.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void applyProperties(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName) throws Exception {
        ConfigPropertiesHelper.applyProperties(session, cs, fileName, variableMapFileName, varMap, reportFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void applyProperties(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName, String filter) throws Exception {
        block35: {
            if (ConfigPropertiesHelper.tc.isEntryEnabled()) {
                Tr.entry(ConfigPropertiesHelper.tc, "applyProperties", new Object[]{cs, session, fileName, variableMapFileName});
            }
            in = null;
            os = null;
            try {
                userDefinedVariableMap = new UserDefinedVariableMap();
                userDefinedVariableMap.clear();
                if (variableMapFileName != null) {
                    userDefinedVariableMap.loadVariableMapFile(variableMapFileName);
                } else if (varMap != null) {
                    userDefinedVariableMap.loadVarMap(varMap);
                }
                propertiesFileData = new PropertiesFileData();
                propertiesFileData.clear();
                in = new FileInputStream(fileName);
                os = null;
                if (reportFileName != null) {
                    os = new FileOutputStream(reportFileName);
                }
                pParser = new PropertiesFileParser(propertiesFileData, userDefinedVariableMap);
                pParser.parse(in);
                sections = propertiesFileData.getAllSections();
                ConfigPropertiesHelper.logReport(os, "ADMG0820I", new Object[]{fileName});
                for (i = 0; i < sections.length; ++i) {
                    commonSectionsList = ConfigPropertiesHelper.getCommonSections(sections, i);
                    i = i + commonSectionsList.size() - 1;
                    commonSections = ConfigPropertiesHelper.removeSkippedSections(commonSectionsList);
                    if (commonSections.length < 1) continue;
                    s = commonSections[0];
                    objType = s.getType();
                    resType = s.getImplementingResourceType();
                    configId = s.getCfgId();
                    configData = null;
                    if (ConfigPropertiesHelper.resourceExists(cs, session, resType, objType, configId, null, ConfigPropertiesHelper.getNameProperty(s))) ** GOTO lbl45
                    if (s.canCreate()) {
                        if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                            Tr.debug(ConfigPropertiesHelper.tc, "No object found in config tree for this config id and will be created ", configId);
                        }
                        ConfigPropertiesHelper.logReport(os, "ADMG0803I", new Object[]{configId});
                        configId = null;
                    } else {
                        configId = null;
                        if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                            Tr.debug(ConfigPropertiesHelper.tc, "No object found in config tree for this config id and will not be created because, create is disabled for this section ", configId);
                        }
                        ConfigPropertiesHelper.logReport(os, "ADMG0804I", new Object[]{configId});
                        continue;
lbl45:
                        // 1 sources

                        if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                            Tr.debug(ConfigPropertiesHelper.tc, "Applying properties to ", configId);
                        }
                        for (j = 0; commonSections != null && j < commonSections.length; ++j) {
                            section = commonSections[j];
                            iType = section.getImplementingResourceType();
                            if (ConfigPropertiesHelper.resourceExists(cs, session, iType, cType = section.getType(), cId = section.getCfgId(), null, ConfigPropertiesHelper.getNameProperty(section))) continue;
                            if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                                Tr.debug(ConfigPropertiesHelper.tc, "No object found in config tree for this config id and will be created ", cId);
                            }
                            ConfigPropertiesHelper.logReport(os, "ADMG0803I", new Object[]{cId});
                        }
                    }
                    if (ConfigPropertiesHelper.isScopeId(configId) && (newId = ConfigPropertiesHelper.getConfigId(cs, session, null, resType, configId, null)) != null) {
                        configId = newId;
                    }
                    if (configId != null) {
                        configData = ConfigServiceHelper.createObjectName(new ConfigDataId(configId));
                    }
                    if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                        Tr.debug(ConfigPropertiesHelper.tc, "Processing section ", new Object[]{resType, configId});
                    }
                    if ((wasResources = ConfigPropertiesHelper.getWASResources(session, resType, configId, commonSections)).size() <= 0) {
                        if (!ConfigPropertiesHelper.tc.isDebugEnabled()) continue;
                        Tr.debug(ConfigPropertiesHelper.tc, "No resource implementation for ", resType);
                        continue;
                    }
                    for (j = 0; wasResources != null && j < wasResources.size(); ++j) {
                        wasRes = (WASResource)wasResources.get(j);
                        wasRes.getReferenceProperties().put("REPORTFILE_OS", os);
                        if (filter != null && !filter.equals(ConfigPropertiesHelper.ALL)) {
                            wasRes.getReferenceProperties().put("REPORTFILTER", filter);
                        }
                        if ((skipApply = userDefinedVariableMap.getValue("SKIP_APPLICATION_DEPLOY")) != null && skipApply.equals("true")) {
                            wasRes.getReferenceProperties().put("SKIP_APPLICATION_DEPLOY", skipApply);
                        }
                        if (commonSections != null) {
                            wasRes.getReferenceProperties().put("ALLSECTIONPROPERTIES", ConfigPropertiesHelper.getProperties(commonSections));
                        }
                        if (wasRes instanceof PropWASResource) {
                            pwasRes = (PropWASResource)wasRes;
                            pwasRes.setSectionedProperties(commonSections);
                        } else if (wasRes instanceof IConfiguration) {
                            iConfRes = (IConfiguration)wasRes;
                            for (k = 0; k < commonSections.length; ++k) {
                                section = commonSections[k];
                                if (!section.canApply()) {
                                    if (!ConfigPropertiesHelper.tc.isDebugEnabled()) continue;
                                    Tr.debug(ConfigPropertiesHelper.tc, "Skipping this section ", section);
                                    continue;
                                }
                                extensionId = null;
                                sectionExtensionId = section.getExtensionId();
                                try {
                                    extensionId = iConfRes.getUniqueId();
                                }
                                catch (WASResourceException wre) {
                                    // empty catch block
                                }
                                if (extensionId == null || sectionExtensionId == null || !extensionId.equals(sectionExtensionId)) continue;
                                iConfRes.setProperties(section.getProperties());
                            }
                        }
                        wasRes.getReferenceProperties().remove("REPORTFILE_OS");
                        if (skipApply != null && skipApply.equals("true")) {
                            wasRes.getReferenceProperties().remove("SKIP_APPLICATION_DEPLOY");
                        }
                        if (filter == null || filter.equals(ConfigPropertiesHelper.ALL)) continue;
                        wasRes.getReferenceProperties().remove("REPORTFILTER");
                    }
                }
                ConfigPropertiesHelper.logReport(os, "ADMG0821I", new Object[]{fileName});
                if (ConfigPropertiesHelper.tc.isEntryEnabled()) {
                    Tr.exit(ConfigPropertiesHelper.tc, "applyProperties");
                }
                var32_34 = null;
                if (in == null) break block35;
            }
            catch (Throwable var31_36) {
                var32_35 = null;
                if (in != null) {
                    in.close();
                }
                if (os != null) {
                    os.close();
                }
                throw var31_36;
            }
            in.close();
        }
        if (os != null) {
            os.close();
        }
    }

    public static void validateProperties(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName) throws Exception {
        boolean result = ConfigPropertiesHelper.validateAndReportError(session, cs, fileName, variableMapFileName, varMap, reportFileName);
    }

    public static boolean validateAndReportError(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName) throws Exception {
        return ConfigPropertiesHelper.validateAndReportError(session, cs, fileName, variableMapFileName, varMap, reportFileName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean validateAndReportError(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName, String filter, boolean isDeleteValidation) throws Exception {
        block41: {
            if (ConfigPropertiesHelper.tc.isEntryEnabled()) {
                Tr.entry(ConfigPropertiesHelper.tc, "validateProperties", new Object[]{cs, session, fileName, variableMapFileName});
            }
            in = null;
            os = null;
            try {
                valid = true;
                userDefinedVariableMap = new UserDefinedVariableMap();
                userDefinedVariableMap.clear();
                if (variableMapFileName != null) {
                    userDefinedVariableMap.loadVariableMapFile(variableMapFileName);
                } else if (varMap != null) {
                    userDefinedVariableMap.loadVarMap(varMap);
                }
                propertiesFileData = new PropertiesFileData();
                propertiesFileData.clear();
                in = new FileInputStream(fileName);
                if (reportFileName != null) {
                    os = new FileOutputStream(reportFileName);
                }
                pParser = new PropertiesFileParser(propertiesFileData, userDefinedVariableMap);
                pParser.parse(in);
                sections = propertiesFileData.getAllSections();
                ConfigPropertiesHelper.logReport(os, "ADMG0824I", new Object[]{fileName});
                for (i = 0; i < sections.length; ++i) {
                    commonSectionsList = ConfigPropertiesHelper.getCommonSections(sections, i);
                    i = i + commonSectionsList.size() - 1;
                    commonSections = ConfigPropertiesHelper.removeSkippedSections(commonSectionsList);
                    if (commonSections.length < 1) continue;
                    s = commonSections[0];
                    objType = s.getType();
                    resType = s.getImplementingResourceType();
                    configId = s.getCfgId();
                    configData = null;
                    if (ConfigPropertiesHelper.resourceExists(cs, session, resType, objType, configId, null, ConfigPropertiesHelper.getNameProperty(s))) ** GOTO lbl50
                    if (s.canCreate()) {
                        if (isDeleteValidation || ConfigPropertiesHelper.isTemplateObjectInNonTemplateSection(s)) {
                            if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                                Tr.debug(ConfigPropertiesHelper.tc, "Object was not found in the config tree.  Validation will be failed ", configId);
                            }
                            ConfigPropertiesHelper.logReport(os, "ADMG0805I", new Object[]{configId});
                            valid = false;
                            continue;
                        }
                        if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                            Tr.debug(ConfigPropertiesHelper.tc, "No object found in config tree for this config id and will be created ", configId);
                        }
                        ConfigPropertiesHelper.logReport(os, "ADMG0803I", new Object[]{configId});
                        configId = null;
                    } else {
                        if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                            Tr.debug(ConfigPropertiesHelper.tc, "No object found in config tree for this config id and will not be created because, create is disabled for this section ", configId);
                        }
                        ConfigPropertiesHelper.logReport(os, "ADMG0804I", new Object[]{configId});
                        continue;
lbl50:
                        // 1 sources

                        if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                            Tr.debug(ConfigPropertiesHelper.tc, "Validating properties of ", configId);
                        }
                        for (j = 0; commonSections != null && j < commonSections.length; ++j) {
                            section = commonSections[j];
                            iType = section.getImplementingResourceType();
                            if (ConfigPropertiesHelper.resourceExists(cs, session, iType, cType = section.getType(), cId = section.getCfgId(), null, ConfigPropertiesHelper.getNameProperty(section))) continue;
                            if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                                Tr.debug(ConfigPropertiesHelper.tc, "No object found in config tree for this config id and will be created ", cId);
                            }
                            ConfigPropertiesHelper.logReport(os, "ADMG0803I", new Object[]{cId});
                        }
                    }
                    if (ConfigPropertiesHelper.isScopeId(configId) && (newId = ConfigPropertiesHelper.getConfigId(cs, session, null, resType, configId, null)) != null) {
                        configId = newId;
                    }
                    if (configId != null) {
                        configData = ConfigServiceHelper.createObjectName(new ConfigDataId(configId));
                    }
                    if (ConfigPropertiesHelper.tc.isDebugEnabled()) {
                        Tr.debug(ConfigPropertiesHelper.tc, "Processing section ", new Object[]{resType, configId});
                    }
                    if ((wasResources = ConfigPropertiesHelper.getWASResources(session, resType, configId, commonSections)).size() <= 0) {
                        if (!ConfigPropertiesHelper.tc.isDebugEnabled()) continue;
                        Tr.debug(ConfigPropertiesHelper.tc, "No resource implementation for ", resType);
                        continue;
                    }
                    for (j = 0; wasResources != null && j < wasResources.size(); ++j) {
                        wasRes = (WASResource)wasResources.get(j);
                        resList = new ArrayList<E>();
                        wasRes.getReferenceProperties().put("REPORTFILE_OS", os);
                        if (filter != null && !filter.equals(ConfigPropertiesHelper.ALL)) {
                            wasRes.getReferenceProperties().put("REPORTFILTER", filter);
                        }
                        if ((skipApply = userDefinedVariableMap.getValue("SKIP_APPLICATION_DEPLOY")) != null && skipApply.equals("true")) {
                            wasRes.getReferenceProperties().put("SKIP_APPLICATION_DEPLOY", skipApply);
                        }
                        if (commonSections != null) {
                            wasRes.getReferenceProperties().put("ALLSECTIONPROPERTIES", ConfigPropertiesHelper.getProperties(commonSections));
                        }
                        if (wasRes instanceof PropWASResource) {
                            pwasRes = (PropWASResource)wasRes;
                            pwasRes.setValidationError(false);
                            resList = pwasRes.validateSectionedProperties(commonSections);
                        } else if (wasRes instanceof IConfiguration) {
                            iConfRes = (IConfiguration)wasRes;
                            for (k = 0; k < commonSections.length; ++k) {
                                section = commonSections[k];
                                if (!section.canApply()) {
                                    if (!ConfigPropertiesHelper.tc.isDebugEnabled()) continue;
                                    Tr.debug(ConfigPropertiesHelper.tc, "Skipping this section ", section);
                                    continue;
                                }
                                extensionId = null;
                                sectionExtensionId = section.getExtensionId();
                                try {
                                    extensionId = iConfRes.getUniqueId();
                                }
                                catch (WASResourceException wre) {
                                    // empty catch block
                                }
                                if (extensionId == null || sectionExtensionId == null || !extensionId.equals(sectionExtensionId)) continue;
                                errRes = iConfRes.validateProperties(section.getProperties());
                                resList.add(new ValidationError(null, null, errRes));
                            }
                        }
                        wasRes.getReferenceProperties().remove("REPORTFILE_OS");
                        if (skipApply != null && skipApply.equals("true")) {
                            wasRes.getReferenceProperties().remove("SKIP_APPLICATION_DEPLOY");
                        }
                        if (filter != null && !filter.equals(ConfigPropertiesHelper.ALL)) {
                            wasRes.getReferenceProperties().remove("REPORTFILTER");
                        }
                        resourceType = wasRes.getResourceType();
                        for (k = 0; k < resList.size(); ++k) {
                            vErr = (ValidationError)resList.get(k);
                            sectionData = vErr.getSectionData();
                            section = vErr.getSection();
                            errs = vErr.getErrs();
                            sb = new StringBuffer("ResourceType=");
                            sb = sb.append(resourceType).append("\n");
                            if (sectionData != null) {
                                configType = sectionData.getType();
                                containingType = sectionData.getContainingType();
                                attrName = sectionData.getAttrName();
                                sb.append("ConfigType=").append(configType).append("ContainingConfigType=").append(containingType).append("AttributeName=").append(attrName).append("\n");
                            }
                            if (section != null) {
                                cId = section.getCfgId();
                                sb = sb.append("ConfigId=").append(cId).append("\n");
                            }
                            if (errs == null) continue;
                            valid = false;
                            for (l = 0; errs != null && l < errs.length; ++l) {
                                sb = sb.append("Error=").append(errs[l]).append("\n\n");
                            }
                            ConfigPropertiesHelper.logReport(os, "ADMG0826I", new Object[]{sb.toString()});
                        }
                        if (!valid || !(wasRes instanceof PropWASResource) || !(pres = (PropWASResource)wasRes).getValidationError()) continue;
                        valid = false;
                        pres.setValidationError(false);
                    }
                }
                ConfigPropertiesHelper.logReport(os, "ADMG0825I", new Object[]{fileName});
                if (ConfigPropertiesHelper.tc.isEntryEnabled()) {
                    Tr.exit(ConfigPropertiesHelper.tc, "validateProperties", valid);
                }
                var15_15 = valid;
                var39_44 = null;
                if (in == null) break block41;
            }
            catch (Throwable var38_46) {
                block42: {
                    var39_45 = null;
                    if (in != null) {
                        in.close();
                    }
                    if (os == null) break block42;
                    os.close();
                }
                throw var38_46;
            }
            in.close();
        }
        if (os != null) {
            os.close();
        }
        return var15_15;
    }

    private static Properties[] getPropertiesFromSections(Section[] sections) {
        Properties[] properties = new Properties[sections.length];
        for (int i = 0; i < sections.length; ++i) {
            Section s = sections[i];
            properties[i] = s.getProperties();
        }
        return properties;
    }

    public static void deleteProperties(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName) throws Exception {
        ConfigPropertiesHelper.deleteProperties(session, cs, fileName, variableMapFileName, varMap, reportFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteProperties(Session session, ConfigService cs, String fileName, String variableMapFileName, Properties varMap, String reportFileName, String filter) throws Exception {
        FileOutputStream os;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteProperties", new Object[]{cs, session, fileName, variableMapFileName});
            }
            FileInputStream in = null;
            os = null;
            try {
                UserDefinedVariableMap userDefinedVariableMap = new UserDefinedVariableMap();
                userDefinedVariableMap.clear();
                if (variableMapFileName != null) {
                    userDefinedVariableMap.loadVariableMapFile(variableMapFileName);
                } else if (varMap != null) {
                    userDefinedVariableMap.loadVarMap(varMap);
                }
                PropertiesFileData propertiesFileData = new PropertiesFileData();
                propertiesFileData.clear();
                in = new FileInputStream(fileName);
                os = null;
                if (reportFileName != null) {
                    os = new FileOutputStream(reportFileName);
                }
                PropertiesFileParser pParser = new PropertiesFileParser(propertiesFileData, userDefinedVariableMap);
                pParser.parse(in);
                Section[] sections = propertiesFileData.getAllSections();
                ConfigPropertiesHelper.logReport(os, "ADMG0822I", new Object[]{fileName});
                for (int i = 0; i < sections.length; ++i) {
                    String newId;
                    List commonSectionsList = ConfigPropertiesHelper.getCommonSections(sections, i);
                    i = i + commonSectionsList.size() - 1;
                    Section[] commonSections = ConfigPropertiesHelper.removeSkippedSections(commonSectionsList);
                    if (commonSections.length < 1) continue;
                    Section s = commonSections[0];
                    String objType = s.getType();
                    String resType = s.getImplementingResourceType();
                    String configId = s.getCfgId();
                    ObjectName configData = null;
                    if (ConfigPropertiesHelper.isScopeId(configId) && (newId = ConfigPropertiesHelper.getConfigId(cs, session, null, resType, configId, null)) != null) {
                        configId = newId;
                    }
                    if (configId != null) {
                        configData = ConfigServiceHelper.createObjectName(new ConfigDataId(configId));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing section ", new Object[]{resType, configId});
                    }
                    if (!ConfigPropertiesHelper.resourceExists(cs, session, resType, objType, configId, null, ConfigPropertiesHelper.getNameProperty(s))) {
                        if (!s.canDelete()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No object found in config tree for this config id and will not be removed ", configId);
                        }
                        ConfigPropertiesHelper.logReport(os, "ADMG0805I", new Object[]{configId});
                        String msg = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0805I", new Object[]{configId});
                        throw new Exception(msg);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleting ", configId);
                    }
                    ConfigPropertiesHelper.logReport(os, "ADMG0808I", new Object[]{configId});
                    for (int j = 0; commonSections != null && j < commonSections.length; ++j) {
                        String cId;
                        String cType;
                        Section section = commonSections[j];
                        String iType = section.getImplementingResourceType();
                        if (ConfigPropertiesHelper.resourceExists(cs, session, iType, cType = section.getType(), cId = section.getCfgId(), null, ConfigPropertiesHelper.getNameProperty(section))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No object found in config tree for this config id and will not be deleted ", cId);
                        }
                        ConfigPropertiesHelper.logReport(os, "ADMG0805I", new Object[]{cId});
                    }
                    List wasResources = ConfigPropertiesHelper.getWASResources(session, resType, configId, commonSections);
                    if (wasResources.size() <= 0) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No resource implementation for ", resType);
                        continue;
                    }
                    for (int j = 0; wasResources != null && j < wasResources.size(); ++j) {
                        WASResource wasRes = (WASResource)wasResources.get(j);
                        wasRes.getReferenceProperties().put("REPORTFILE_OS", os);
                        if (filter != null && !filter.equals(ALL)) {
                            wasRes.getReferenceProperties().put("REPORTFILTER", filter);
                        }
                        if (commonSections != null) {
                            wasRes.getReferenceProperties().put("ALLSECTIONPROPERTIES", ConfigPropertiesHelper.getProperties(commonSections));
                        }
                        if (wasRes instanceof PropWASResource) {
                            PropWASResource pwasRes = (PropWASResource)wasRes;
                            pwasRes.deleteSectionedProperties(commonSections);
                        } else if (wasRes instanceof IConfiguration) {
                            IConfiguration iConfRes = (IConfiguration)((Object)wasRes);
                            wasRes.getReferenceProperties().put("DELETERESOURCE", new Boolean(true));
                            for (int k = 0; k < commonSections.length; ++k) {
                                Section section = commonSections[k];
                                String extensionId = null;
                                if (!section.canDelete()) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Skipping this section ", section);
                                    continue;
                                }
                                String sectionExtensionId = section.getExtensionId();
                                try {
                                    extensionId = iConfRes.getUniqueId();
                                }
                                catch (WASResourceException wre) {
                                    // empty catch block
                                }
                                if (extensionId == null || sectionExtensionId == null || !extensionId.equals(sectionExtensionId)) continue;
                                iConfRes.setProperties(section.getProperties());
                            }
                            wasRes.getReferenceProperties().remove("DELETERESOURCE");
                        }
                        wasRes.getReferenceProperties().remove("REPORTFILE_OS");
                        if (filter == null || filter.equals(ALL)) continue;
                        wasRes.getReferenceProperties().remove("REPORTFILTER");
                    }
                }
                ConfigPropertiesHelper.logReport(os, "ADMG0823I", new Object[]{fileName});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteProperties");
                }
                Object var31_33 = null;
                if (in == null) break block31;
            }
            catch (Throwable throwable) {
                Object var31_34 = null;
                if (in != null) {
                    in.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (os != null) {
            os.close();
        }
    }

    public static WASResourceReferenceParameters createReferenceParameters(String configId, String configType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createReferenceParameters", new Object[]{configId, configType});
        }
        HashMap<QName, String> referenceParameters = new HashMap<QName, String>();
        if (configId == null) {
            referenceParameters.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(configType, "NONEXISTENTRESOURCE"));
        } else {
            referenceParameters.put(WASResourcesConstants.WAS_WSDM_Resource_MRID, WASResourceUtilities.constructMRID(configType, configId));
        }
        referenceParameters.put(WASResourcesConstants.WAS_WSDM_Resource_Type, configType);
        if (configId != null) {
            referenceParameters.put(WASResourcesConstants.WAS_WSDM_Resource_ConfigID, configId);
        }
        WASResourceReferenceParameters wasResRefParams = new WASResourceReferenceParameters("", referenceParameters);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createReferenceParameters", referenceParameters);
        }
        return wasResRefParams;
    }

    public static List getWASResources(Session session, String configType) {
        ArrayList<WASResource> wasResources;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWASResources", configType);
            }
            wasResources = new ArrayList<WASResource>();
            try {
                WASResourceManager wasResMgr = WASResourceManager.getInstance();
                Set resTypes = wasResMgr.getAllResourceTypes();
                for (String resourceType : resTypes) {
                    List eprs;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource Type ", resourceType);
                    }
                    if (configType != null && !resourceType.equals(configType) || (eprs = wasResMgr.queryResource(resourceType, null)) == null) continue;
                    boolean create = true;
                    for (WASResourceReferenceParameters wrrp : eprs) {
                        HashMap resourceProp = wrrp.getReferenceProperties();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Resource Prop ", resourceProp);
                        }
                        WASResource wasRes = null;
                        if (create) {
                            wasRes = wasResMgr.createResource(resourceProp, session);
                            wasResources.add(wasRes);
                            List resExts = wasResMgr.createResourceExtension(resourceProp, session);
                            wasResources.addAll(resExts);
                            create = false;
                        } else {
                            ConfigPropertiesHelper.initializeAllResources(wasResources, resourceProp);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Resource ", wasRes);
                    }
                    if (configType == null) continue;
                    break;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Resource Type is not registered ", configType);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWASResources", wasResources);
        }
        return wasResources;
    }

    public static boolean resourceExists(ConfigService cs, Session session, String implType, String resType, String cfgId, ObjectName scope, String name) {
        boolean result;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resourceExists", new Object[]{implType, resType, cfgId, name});
            }
            result = false;
            ObjectName configData = null;
            if (resType.equals("AuthorizationGroup") && cfgId.equals(CELL_AUTHORIZATION_GROUP_CFG_ID)) {
                return true;
            }
            if (cfgId != null) {
                if (ConfigPropertiesHelper.isConfigId(cfgId)) {
                    configData = ConfigServiceHelper.createObjectName(new ConfigDataId(cfgId));
                    try {
                        ObjectName[] matches = cs.queryConfigObjects(session, null, configData, null);
                        if (matches.length == 1) {
                            result = true;
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ConfigObject not found", cfgId);
                        }
                        break block19;
                    }
                }
                if (ConfigPropertiesHelper.isScopeId(cfgId)) {
                    try {
                        configData = PropertiesUtils.convertConfigScopeToConfigObject(scope, cfgId, session, cs);
                        if (configData != null) {
                            result = true;
                        }
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ConfigObject not found", cfgId);
                        }
                    }
                }
            } else {
                try {
                    String containmentPath;
                    String cfgType = resType;
                    if (cfgType != null && cfgType.equals("Application")) {
                        cfgType = "Deployment";
                    }
                    if ((configData = cs.resolve(session, scope, containmentPath = cfgType + "=" + name)[0]) != null) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "ConfigObject not found", resType + name);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resourceExists", new Boolean(result));
        }
        return result;
    }

    public static String getConfigId(ConfigService cs, Session session, String implType, String resType, String cfgId, ObjectName scope) {
        ObjectName configData;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConfigId", new Object[]{cs, session, implType, resType, cfgId});
            }
            configData = null;
            if (cfgId != null) {
                if (ConfigPropertiesHelper.isConfigId(cfgId)) {
                    configData = ConfigServiceHelper.createObjectName(new ConfigDataId(cfgId));
                    try {
                        ObjectName[] matches = cs.queryConfigObjects(session, null, configData, null);
                        if (matches.length == 1) {
                            configData = matches[0];
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ConfigObject not found", configData);
                        }
                        break block12;
                    }
                }
                if (ConfigPropertiesHelper.isScopeId(cfgId)) {
                    try {
                        configData = PropertiesUtils.convertConfigScopeToConfigObject(scope, cfgId, session, cs);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "ConfigObject not found", configData);
                    }
                }
            }
        }
        String res = null;
        if (configData != null) {
            res = ConfigServiceHelper.getConfigDataId(configData).toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigId", res);
        }
        return res;
    }

    public static boolean isConfigId(String cfgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConfigId", new Object[]{cfgId});
        }
        boolean result = false;
        if (cfgId.indexOf(124) > 0 || cfgId.indexOf(47) > 0) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConfigId", new Boolean(result));
        }
        return result;
    }

    public static boolean isScopeId(String cfgId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isScopeId", new Object[]{cfgId});
        }
        boolean result = false;
        if (cfgId != null && cfgId.indexOf(61) > 0) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isScopeId", new Boolean(result));
        }
        return result;
    }

    public static List getCommonSections(Section[] sections, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommonSections", new Object[]{sections, new Integer(i)});
        }
        ArrayList<Section> commonSections = new ArrayList<Section>();
        Section firstSection = null;
        if (i < sections.length) {
            firstSection = sections[i];
        }
        String savedResourceType = null;
        String savedExtensionId = null;
        while (i < sections.length) {
            Section s = sections[i];
            String resType = s.getImplementingResourceType();
            if (savedResourceType == null) {
                savedResourceType = resType;
                savedExtensionId = s.getExtensionId();
                commonSections.add(s);
            } else {
                if (!savedResourceType.equals(resType) || !ConfigPropertiesHelper.sameResourceId(firstSection, sections[i])) break;
                if (savedExtensionId != null) {
                    String newExtensionId = s.getExtensionId();
                    if (newExtensionId == null || !newExtensionId.equals(savedExtensionId)) break;
                    commonSections.add(s);
                } else {
                    if (s.getExtensionId() != null) break;
                    commonSections.add(s);
                }
            }
            ++i;
        }
        if (tc.isDebugEnabled()) {
            for (int j = 0; j < commonSections.size(); ++j) {
                Tr.debug(tc, "common section = ", commonSections.get(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommonSections", commonSections);
        }
        return commonSections;
    }

    private static boolean sameResourceId(Section section1, Section section2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameResourceId", new Object[]{section1, section2});
        }
        boolean result = true;
        String firstSectionConfigId = section1.getCfgId();
        String firstSectionResourceType = section1.getType();
        String firstSectionImplementingResourceType = section1.getImplementingResourceType();
        String secondSectionConfigId = section2.getCfgId();
        String secondSectionResourceType = section2.getType();
        String secondSectionImplementingResourceType = section2.getImplementingResourceType();
        if (firstSectionResourceType.equals(secondSectionResourceType) && firstSectionImplementingResourceType.equals(secondSectionImplementingResourceType)) {
            if (firstSectionConfigId == null) {
                result = false;
            } else if (!firstSectionConfigId.equals(secondSectionConfigId)) {
                result = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sameResourceId", new Boolean(result));
        }
        return result;
    }

    private static List getAllNestedTypes(String type, String implType) {
        int j;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNestedTypes", new Object[]{type, implType});
        }
        SectionData[] sectionData = SectionedPropertiesHelper.getSections(implType);
        ArrayList<String> allTypes = new ArrayList<String>();
        allTypes.add(type);
        for (j = 0; sectionData != null && j < sectionData.length && !sectionData[j].getType().equals(type); ++j) {
        }
        while (j < sectionData.length) {
            String containingType = sectionData[j].getContainingType();
            if (containingType.equals(type)) {
                allTypes.add(sectionData[j].getType());
            } else if (allTypes.contains(containingType)) {
                allTypes.add(sectionData[j].getType());
            }
            ++j;
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < allTypes.size(); ++i) {
                Tr.debug(tc, "type = ", allTypes.get(i));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNestedTypes", allTypes);
        }
        return allTypes;
    }

    private static Section[] getSubSections(Section[] sections, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommonSections", new Object[]{sections, new Integer(i)});
        }
        int origIndex = i;
        String origCfgId = sections[i].getCfgId();
        ArrayList<Section> subSections = new ArrayList<Section>();
        String implType = sections[i].getImplementingResourceType();
        String type = sections[i].getType();
        List allTypes = ConfigPropertiesHelper.getAllNestedTypes(type, implType);
        Object savedResourceType = null;
        while (i < sections.length) {
            Section s = sections[i];
            String resType = s.getType();
            String configId = s.getCfgId();
            if (i != origIndex && resType.equals(type) && !configId.equals(origCfgId)) break;
            if (allTypes.contains(resType)) {
                subSections.add(s);
            }
            ++i;
        }
        if (tc.isDebugEnabled()) {
            for (int j = 0; j < subSections.size(); ++j) {
                Tr.debug(tc, "common section = ", subSections.get(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommonSections", subSections);
        }
        return subSections.toArray(new Section[0]);
    }

    private static String createResource(ConfigService cs, Session session, String resType, String objType, String configId, Section s, Section[] commonSections) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResource", new Object[]{cs, session, resType, objType, configId, s});
        }
        String res = null;
        List wasResources = ConfigPropertiesHelper.getWASResources(session, resType, null);
        if (wasResources.size() <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No resource implementation for ", resType);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createResource", res);
            }
            return res;
        }
        for (int j = 0; wasResources != null && j < wasResources.size(); ++j) {
            WASResource wasRes = (WASResource)wasResources.get(j);
            wasRes.getReferenceProperties().put("CREATERESOURCE", new Boolean(true));
            if (commonSections != null) {
                wasRes.getReferenceProperties().put("ALLSECTIONPROPERTIES", ConfigPropertiesHelper.getProperties(commonSections));
            }
            if (wasRes instanceof PropWASResource) {
                PropWASResource pwasRes = (PropWASResource)wasRes;
                Section[] sections = new Section[]{s};
                pwasRes.setSectionedProperties(sections);
            } else if (wasRes instanceof IConfiguration) {
                IConfiguration iConfRes = (IConfiguration)((Object)wasRes);
                String extensionId = null;
                String sectionExtensionId = s.getExtensionId();
                try {
                    extensionId = iConfRes.getUniqueId();
                }
                catch (WASResourceException wre) {
                    // empty catch block
                }
                if (extensionId != null && sectionExtensionId != null && extensionId.equals(sectionExtensionId)) {
                    iConfRes.setProperties(s.getProperties());
                }
            }
            wasRes.getReferenceProperties().remove("CREATERESOURCE");
        }
        res = ConfigPropertiesHelper.getConfigId(cs, session, resType, objType, configId, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResource", res);
        }
        return res;
    }

    private static Properties[] getProperties(Section[] sections) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", sections);
        }
        ArrayList<Properties> pList = new ArrayList<Properties>();
        for (int i = 0; sections != null && i < sections.length; ++i) {
            Properties p = sections[i].getProperties();
            pList.add(p);
        }
        Properties[] props = pList.toArray(new Properties[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public static String getNameProperty(Section s) {
        Properties props = s.getProperties();
        String name = props.getProperty("name");
        if (name == null) {
            name = props.getProperty("Name");
        }
        return name;
    }

    public static SectionedProperties[] getPropertiesForCommand(String commandName, WASResource wasRes, boolean create) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForCommand", new Object[]{commandName, wasRes, new Boolean(create)});
        }
        SectionedProperties[] sps = null;
        ArrayList<SectionedProperties> spList = new ArrayList<SectionedProperties>();
        String configType = (String)wasRes.getReferenceProperties().get("RESOURCETYPE");
        String implType = wasRes.getResourceType();
        String configId = wasRes.getConfigID();
        ConfigService cs = wasRes.getConfigService();
        Session session = wasRes.getSession();
        if (configType == null) {
            configType = implType;
        }
        if (configId == null) {
            configId = configType + "=";
        }
        SectionedProperties sp = null;
        sp = create ? SectionedPropertiesHelper.getCreateSectionedProperties(configType, implType, configId) : SectionedPropertiesHelper.getDeleteSectionedProperties(configType, implType, configId);
        CommandMetadata cmdMetadata = ConfigPropertiesHelper.getCommandMetadata(cs, commandName);
        Properties props = ConfigPropertiesHelper.getCommandProperties(cmdMetadata);
        sp.setConfigProperties(props);
        spList.add(sp);
        if (cmdMetadata instanceof TaskCommandMetadata) {
            TaskCommandMetadata taskMetadata = (TaskCommandMetadata)cmdMetadata;
            EList steps = taskMetadata.getSteps();
            for (int i = 0; steps != null && i < steps.size(); ++i) {
                CommandStepMetadata stepMetadata = (CommandStepMetadata)steps.get(i);
                SectionedProperties stepSp = null;
                stepSp = create ? SectionedPropertiesHelper.getCreateSectionedPropertiesForStep(configType, implType, configId) : SectionedPropertiesHelper.getDeleteSectionedPropertiesForStep(configType, implType, configId);
                Properties stepProps = ConfigPropertiesHelper.getCommandStepProperties(stepMetadata);
                stepSp.setConfigProperties(stepProps);
                spList.add(stepSp);
            }
        }
        sps = spList.toArray(new SectionedProperties[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForCommand", sps);
        }
        return sps;
    }

    private static CommandMetadata getCommandMetadata(ConfigService cs, String commandName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", new Object[]{cs, commandName});
        }
        CommandMgr cmgr = ConfigPropertiesHelper.getCmdMgr(cs);
        CommandMetadata cmdMetadata = null;
        try {
            cmdMetadata = cmgr.getCommandMetadata(commandName);
        }
        catch (CommandNotFoundException cnfe) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetadata", cmdMetadata);
        }
        return cmdMetadata;
    }

    private static Properties getCommandProperties(CommandMetadata cmdMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandProperties", cmdMetadata);
        }
        Properties props = new Properties();
        if (cmdMetadata.isTargetObjectAllowed()) {
            if (cmdMetadata.isTargetObjectRequired()) {
                props.setProperty("targetObject", "targetObject #" + cmdMetadata.getTargetObjectConfigType() + ",required ");
            } else {
                String targetObjType = cmdMetadata.getTargetObjectConfigType();
                if (targetObjType == null) {
                    targetObjType = "String";
                }
                props.setProperty("targetObject", "null #" + targetObjType);
            }
        }
        EList params = cmdMetadata.getParameters();
        for (int i = 0; params != null && i < params.size(); ++i) {
            ParameterMetadata pMetadata = (ParameterMetadata)params.get(i);
            if (pMetadata.isRequired()) {
                props.setProperty(pMetadata.getName(), pMetadata.getName() + " #" + pMetadata.getType() + ",required");
                continue;
            }
            props.setProperty(pMetadata.getName(), "null #" + pMetadata.getType());
        }
        props.setProperty("commandName", cmdMetadata.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandProperties", props);
        }
        return props;
    }

    private static Properties getCommandStepProperties(CommandStepMetadata cmdStepMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandProperties", cmdStepMetadata);
        }
        Properties props = new Properties();
        if (cmdStepMetadata.isTargetObjectAllowed()) {
            if (cmdStepMetadata.isTargetObjectRequired()) {
                props.setProperty("targetObject", "targetObject #" + cmdStepMetadata.getTargetObjectConfigType() + ",required");
            } else {
                props.setProperty("targetObject", "null #" + cmdStepMetadata.getTargetObjectConfigType());
            }
        }
        EList params = cmdStepMetadata.getParameters();
        for (int i = 0; params != null && i < params.size(); ++i) {
            ParameterMetadata pMetadata = (ParameterMetadata)params.get(i);
            if (pMetadata.isRequired()) {
                props.setProperty(pMetadata.getName(), pMetadata.getName() + " #" + pMetadata.getType() + ",required");
                continue;
            }
            props.setProperty(pMetadata.getName(), "null #" + pMetadata.getType());
        }
        props.setProperty("stepName", cmdStepMetadata.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandStepProperties", props);
        }
        return props;
    }

    private static CommandMgr getCmdMgr(ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCmdMgr", configService);
        }
        CommandMgr cmdMgr = null;
        cmdMgr = configService instanceof ConfigServiceProxy ? CommandMgr.getCommandMgr(((ConfigServiceProxy)configService).getAdminClient()) : CommandMgr.getCommandMgr();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCmdMgr", cmdMgr);
        }
        return cmdMgr;
    }

    private static int skipCreateDeleteTemplateSections(Section[] sections, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "skipCreateDeleteSections", new Object[]{sections, new Integer(i)});
        }
        int cnt = 0;
        while (sections != null && i < sections.length) {
            if (sections[i].isCreateTemplate() || sections[i].isDeleteTemplate()) {
                ++cnt;
            } else {
                if (!sections[i].skipSection()) break;
                ++cnt;
            }
            ++i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "skipCreateDeleteSections", new Integer(cnt));
        }
        return cnt;
    }

    private static Section[] getCommandSections(Section[] sections, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandSections", new Object[]{sections, new Integer(i)});
        }
        Section[] result = null;
        ArrayList<Section> cList = new ArrayList<Section>();
        boolean commandFound = false;
        while (sections != null && i < sections.length && sections[i].getCreateDeleteCommandProperties() != null && sections[i].getCreateDeleteCommandProperties().equals("true")) {
            Properties props = sections[i].getProperties();
            if (!commandFound) {
                if (props.getProperty("commandName") != null) {
                    commandFound = true;
                }
            } else if (props.getProperty("commandName") != null) break;
            cList.add(sections[i]);
            ++i;
        }
        result = cList.toArray(new Section[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandSections", result);
        }
        return result;
    }

    public static void handleCommandProperties(WASResource wasRes, Section[] sections) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleCommandProperties", new Object[]{wasRes, sections});
        }
        if (sections == null || sections.length <= 0) {
            return;
        }
        int i = 0;
        while (i < sections.length) {
            int skips;
            if ((i += (skips = ConfigPropertiesHelper.skipCreateDeleteTemplateSections(sections, i))) >= sections.length) continue;
            Section[] cmdSections = ConfigPropertiesHelper.getCommandSections(sections, i);
            i += cmdSections.length;
            AdminCommand cmd = ConfigPropertiesHelper.createCommandAndSteps(wasRes, cmdSections);
            cmd.execute();
            CommandResult res = cmd.getCommandResult();
            if (res.isSuccessful()) continue;
            throw new Exception(res.getException());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleCommandProperties");
        }
    }

    public static AdminCommand createCommandAndSteps(WASResource wasRes, Section[] sections) throws Exception {
        CommandStep step;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandAndSteps", new Object[]{wasRes, sections});
        }
        AdminCommand command = null;
        command = ConfigPropertiesHelper.createCommand(wasRes, sections[0].getProps());
        for (int i = 1; command != null && i < sections.length && (step = ConfigPropertiesHelper.createStep(wasRes, command, sections[i].getProps())) != null; ++i) {
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandAndSteps", command);
        }
        return command;
    }

    private static AdminCommand createCommand(WASResource wasRes, Props[] props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", new Object[]{wasRes, props});
        }
        AdminCommand command = null;
        CommandMgr cmdMgr = ConfigPropertiesHelper.getCmdMgr(wasRes.getConfigService());
        String commandName = ConfigPropertiesHelper.getCommandName(props);
        if (commandName != null) {
            command = cmdMgr.createCommand(commandName);
            command.setConfigSession(wasRes.getSession());
            ConfigPropertiesHelper.setParameters(wasRes.getConfigService(), command, props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommand", command);
        }
        return command;
    }

    private static CommandStep createStep(WASResource wasRes, AdminCommand command, Props[] props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStep", new Object[]{wasRes, command, props});
        }
        CommandStep step = null;
        TaskCommand taskCommand = (TaskCommand)command;
        String stepName = ConfigPropertiesHelper.getStepName(props);
        if (stepName != null) {
            step = taskCommand.getCommandStep(stepName);
            ConfigPropertiesHelper.setParameters(wasRes.getConfigService(), step, props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStep", step);
        }
        return step;
    }

    private static void setParameters(ConfigService cs, AdminCommand command, Props[] props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameters", new Object[]{command, props});
        }
        for (int i = 0; props != null && i < props.length; ++i) {
            String pType;
            Object pValue;
            String pName = props[i].getName();
            if (pName.equals("targetObject")) {
                pValue = props[i].getValue();
                pType = ConfigPropertiesHelper.getTargetObjectType(cs, command, pName);
                ConfigPropertiesHelper.setTargetObject(cs, command, pName, (String)pValue, pType);
                continue;
            }
            if (pName.equals("commandName") || pName.equals("stepName")) continue;
            if (props[i].isArray()) {
                pValue = props[i].getValues();
                pType = ConfigPropertiesHelper.getParameterType(cs, command, pName);
                ConfigPropertiesHelper.setParameter(cs, command, pName, (List)pValue, pType);
                continue;
            }
            pValue = props[i].getValue();
            pType = ConfigPropertiesHelper.getParameterType(cs, command, pName);
            ConfigPropertiesHelper.setParameter(cs, command, pName, (String)pValue, pType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameters");
        }
    }

    private static void setParameter(ConfigService cs, AdminCommand command, String pName, List pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{command, pName, pValue, pType});
        }
        if (pValue == null || pValue.size() <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setParameter", "null value specified for " + pName);
            }
            return;
        }
        Class<?> typeClass = null;
        try {
            typeClass = Class.forName(pType);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                typeClass = Class.forName("java.lang." + pType);
            }
            catch (ClassNotFoundException cnfe1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " unknown type ", pType);
                }
                typeClass = Class.forName("java.lang.String");
            }
        }
        if (typeClass == Properties.class) {
            command.setParameter(pName, ConfigPropertiesHelper.getProperties(pValue));
        } else {
            Object res = Array.newInstance(typeClass.getComponentType(), pValue.size());
            for (int i = 0; i < pValue.size(); ++i) {
                Array.set(res, i, ConfigPropertiesHelper.convert((String)pValue.get(i), pType));
            }
            command.setParameter(pName, res);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    private static void setTargetObject(ConfigService cs, AdminCommand command, String pName, String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetObject", new Object[]{command, pName, pValue, pType});
        }
        if (pValue == null || pValue.equals("null")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setParameter", "null value specified for " + pName);
            }
            return;
        }
        command.setTargetObject(ConfigPropertiesHelper.convert(pValue, pType));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargetObject");
        }
    }

    private static void setParameter(ConfigService cs, AdminCommand command, String pName, String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{command, pName, pValue, pType});
        }
        if (pValue == null || pValue.equals("null")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setParameter", "null value specified for " + pName);
            }
            return;
        }
        command.setParameter(pName, ConfigPropertiesHelper.convert(pValue, pType));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    public static Object convert(String pValue, String pType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convert", new Object[]{pValue, pType});
        }
        Object res = null;
        if (pType == null) {
            pType = "String";
        }
        if (pType.indexOf("String") >= 0) {
            res = pValue;
        } else if (pType.indexOf("Integer") >= 0) {
            res = new Integer(pValue);
        } else if (pType.indexOf("Long") >= 0) {
            res = new Long(pValue);
        } else if (pType.indexOf("Boolean") >= 0) {
            res = new Boolean(pValue);
        } else if (pType.indexOf("Byte") >= 0) {
            res = new Byte(pValue);
        } else if (pType.indexOf("Short") >= 0) {
            res = new Short(pValue);
        } else if (pType.indexOf("Double") >= 0) {
            res = new Double(pValue);
        } else if (pType.indexOf("Float") >= 0) {
            res = new Float(pValue);
        } else if (pType.indexOf("Character") >= 0) {
            res = new Character(pValue.charAt(0));
        } else if (pType.indexOf("ObjectName") >= 0) {
            ObjectName on = ConfigServiceHelper.createObjectName(new ConfigDataId(pValue));
            res = on;
        } else if (pType.indexOf("URL") >= 0) {
            res = new URL(new String(pValue));
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown type", pType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convert", res);
        }
        return res;
    }

    private static Properties getProperties(List pValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", pValue);
        }
        Properties props = new Properties();
        for (int i = 0; i < pValue.size(); ++i) {
            String val = (String)pValue.get(i);
            StringTokenizer st = new StringTokenizer(val, "=");
            String name = st.nextToken();
            String value = st.nextToken();
            props.setProperty(name, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    private static String getParameterType(ConfigService cs, AdminCommand command, String pName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameterType", new Object[]{command, pName});
        }
        String pType = "String";
        CommandMgr cmgr = ConfigPropertiesHelper.getCmdMgr(cs);
        CommandMetadata cm = command.getCommandMetadata();
        EList pmList = cm.getParameters();
        for (int i = 0; pmList != null && i < pmList.size(); ++i) {
            ParameterMetadata pm = (ParameterMetadata)pmList.get(i);
            if (!pm.getName().equals(pName)) continue;
            pType = pm.getType();
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, " found metadata ", pm);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameterType", pType);
        }
        return pType;
    }

    private static String getTargetObjectType(ConfigService cs, AdminCommand command, String pName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetObjectType", new Object[]{command, pName});
        }
        String pType = "String";
        CommandMgr cmgr = ConfigPropertiesHelper.getCmdMgr(cs);
        CommandMetadata cm = command.getCommandMetadata();
        pType = cm.getTargetObjectConfigType();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetObjectType", pType);
        }
        return pType;
    }

    private static String getCommandName(Props[] props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandName", props);
        }
        String commandName = null;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals("commandName")) continue;
            commandName = props[i].getValue();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandName", commandName);
        }
        return commandName;
    }

    private static String getStepName(Props[] props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepName", props);
        }
        String stepName = null;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equals("stepName")) continue;
            stepName = props[i].getValue();
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepName", stepName);
        }
        return stepName;
    }

    public static String[] getVariables(InputStream in) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariables", new Object[]{in});
        }
        PropertiesFileData propertiesFileData = new PropertiesFileData();
        propertiesFileData.clear();
        PropertiesFileParser pParser = new PropertiesFileParser(propertiesFileData, null);
        pParser.parse(in);
        Section[] sections = propertiesFileData.getAllSections();
        ArrayList<String> lst = new ArrayList<String>();
        for (int i = 0; sections != null && i < sections.length; ++i) {
            String[] vars = sections[i].getAllVariables();
            for (int j = 0; vars != null && j < vars.length; ++j) {
                if (lst.contains(vars[j])) continue;
                lst.add(vars[j]);
            }
        }
        String[] result = lst.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariables", result);
        }
        return result;
    }

    public static Hashtable getPropertiesByResourceType(InputStream in, String resourceType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesByResourceType", new Object[]{in, resourceType});
        }
        PropertiesFileData propertiesFileData = new PropertiesFileData();
        propertiesFileData.clear();
        PropertiesFileParser pParser = new PropertiesFileParser(propertiesFileData, null);
        pParser.parse(in);
        Section[] sections = propertiesFileData.getAllSections();
        Hashtable<String, Hashtable> table = new Hashtable<String, Hashtable>();
        for (int i = 0; sections != null && i < sections.length; ++i) {
            Properties props;
            String taskName = null;
            if (!sections[i].getType().equals(resourceType) || (taskName = (props = sections[i].getProperties()).getProperty("taskName")) == null) continue;
            props.remove("taskName");
            if (props.containsKey("mutables")) {
                props.remove("mutables");
            }
            Hashtable tableValue = ConfigPropertiesHelper.convertPropsToTable(props);
            table.put(taskName, tableValue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesByResourceType", table);
        }
        return table;
    }

    private static Hashtable convertPropsToTable(Properties props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertPropsToTable", props);
        }
        Hashtable<String, String[]> table = new Hashtable<String, String[]>();
        for (int i = 0; i < props.size(); ++i) {
            String key = "row" + i;
            String propValue = props.getProperty(key);
            String[] value = ConfigPropertiesHelper.getValues(propValue);
            table.put(key, value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertPropsToTable", table);
        }
        return table;
    }

    public static String[] getVariables(String[] values) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariables", values);
        }
        String[] result = null;
        ArrayList varList = new ArrayList();
        for (int i = 0; values != null && i < values.length; ++i) {
            String value = values[i];
            List allVars = UserDefinedVariableMap.getAllVars(value);
            for (int j = 0; allVars != null && j < allVars.size(); ++j) {
                if (varList.contains(allVars.get(j))) continue;
                varList.add(allVars.get(j));
            }
        }
        result = varList.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariables", result);
        }
        return result;
    }

    private static String[] getValues(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValues", value);
        }
        String[] values = null;
        ArrayList<String> lst = new ArrayList<String>();
        String val = new String(value);
        int inx = val.indexOf("{");
        int einx = val.lastIndexOf("}");
        if (inx >= 0 && einx > 0) {
            val = val.substring(inx + 1, einx);
        }
        val = val.trim();
        int len = 0;
        int totlen = val.length();
        while (len < totlen) {
            String tok;
            int endIndex;
            if (val.startsWith("\"")) {
                endIndex = val.indexOf("\"", 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "inx = " + endIndex);
                }
                tok = val.substring(1, endIndex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tok = " + tok);
                }
                lst.add(tok);
                if ((len = len + tok.length() + 3) >= totlen) continue;
                val = val.substring(tok.length() + 3);
                continue;
            }
            endIndex = val.indexOf(" ");
            if (endIndex == -1) {
                endIndex = val.length();
            }
            tok = val.substring(0, endIndex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tok = " + tok);
            }
            lst.add(tok);
            if ((len = len + tok.length() + 1) >= totlen) continue;
            val = val.substring(tok.length() + 1);
        }
        values = lst.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValues", values);
        }
        return values;
    }

    private static boolean isTemplateObjectInNonTemplateSection(Section s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTemplateObjectInNonTemplateSection", s);
        }
        boolean result = false;
        boolean isTemplateSection = s.getCreateDeleteCommandProperties() != null && s.getCreateDeleteCommandProperties().equals("true");
        boolean isTemplateObject = TemplateObjectList.contains(s.getType());
        if (isTemplateObject && s.getCfgId() != null && s.getCfgId().equals(CELL_AUTHORIZATION_GROUP_CFG_ID)) {
            isTemplateObject = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Values - isTemplateSection, isTemplateObject are respectively " + isTemplateSection + " " + isTemplateObject);
        }
        boolean bl = result = !isTemplateSection && isTemplateObject;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTemplateObjectInNonTemplateSection", result);
        }
        return result;
    }

    public static Section[] removeSkippedSections(List sectionList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSkippedSections.  The length of the incoming list is + ", sectionList.size());
        }
        Iterator i = sectionList.iterator();
        while (i.hasNext()) {
            Section s = (Section)i.next();
            if (!s.skipSection()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Skipped section found.  Removing from List", s);
            }
            i.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSkippedSections.  The length of the list after processing is + ", sectionList.size());
        }
        return sectionList.toArray(new Section[0]);
    }

    static {
        TemplateObjectList.add("Server");
        TemplateObjectList.add("ServerCluster");
        TemplateObjectList.add("Cluster");
        TemplateObjectList.add("Deployment");
        TemplateObjectList.add("Application");
        TemplateObjectList.add("AuthorizationGroup");
    }
}

