/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.helper;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;

public class SecurityCommandHelper {
    private static TraceComponent tc = Tr.register(SecurityCommandHelper.class, "Admin", "com.ibm.ws.management.commands.helper");

    public static void prepareKeysForSingleProfile(Session session, String profileRoot, String cellName, String nodeName, String hostName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareKeysForSingleProfile", new Object[]{session, profileRoot, cellName, nodeName, hostName});
        }
        String defaultCertDN = "cn=" + hostName + ",ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        String rootCertDN = "cn=" + hostName + ",ou=Root Certificate,ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand cmd = cmdMgr.createCommand("prepareKeysForSingleProfile");
        cmd.setConfigSession(session);
        cmd.setParameter("profileRoot", profileRoot);
        cmd.setParameter("cellName", cellName);
        cmd.setParameter("nodeName", nodeName);
        cmd.setParameter("defaultCertDN", defaultCertDN);
        cmd.setParameter("defaultCertValidityPeriod", "1");
        cmd.setParameter("rootCertDN", rootCertDN);
        cmd.setParameter("rootCertValidityPeriod", "20");
        cmd.setParameter("skipLTPAKeys", "true");
        cmd.setParameter("regenCerts", "true");
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            Throwable t = result.getException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareKeysForSingleProfile");
        }
    }

    public static void prepareKeysForCellProfile(Session session, String dmgrProfileRoot, String nodeProfileRoot, String cellName, String nodeName, String hostName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareKeysForCellProfile", new Object[]{session, dmgrProfileRoot, nodeProfileRoot, cellName, nodeName, hostName});
        }
        String defaultCertDN = "cn=" + hostName + ",ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        String rootCertDN = "cn=" + hostName + ",ou=Root Certificate,ou=" + cellName + ",ou=" + nodeName + ",o=IBM,c=US";
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        AdminCommand cmd = cmdMgr.createCommand("prepareKeysForSingleProfile");
        cmd.setConfigSession(session);
        cmd.setParameter("dmgrProfileRoot", dmgrProfileRoot);
        cmd.setParameter("nodeProfileRoot", dmgrProfileRoot);
        cmd.setParameter("cellName", cellName);
        cmd.setParameter("nodeName", nodeName);
        cmd.setParameter("defaultCertDN", defaultCertDN);
        cmd.setParameter("defaultCertValidityPeriod", "1");
        cmd.setParameter("rootCertDN", rootCertDN);
        cmd.setParameter("rootCertValidityPeriod", "20");
        cmd.setParameter("skipLTPAKeys", "true");
        cmd.setParameter("regenCerts", "true");
        cmd.execute();
        CommandResult result = cmd.getCommandResult();
        if (!result.isSuccessful()) {
            Throwable t = result.getException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareKeysForCellProfile");
        }
    }
}

