/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.authzgroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.topology.authorizationgroup.AuthorizationGroup;
import com.ibm.websphere.models.config.topology.authorizationgroup.AuthorizationGroupMember;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class AuthzGroupUtil {
    private static TraceComponent tc = Tr.register(AuthzGroupUtil.class, "management", "com.ibm.ws.management.resources.configservice");

    public static boolean removeResourceFromAuthorizationGroup(ConfigService cs, Session session, String resourceID, String resourceType) throws Exception {
        ObjectName authzGroup;
        int inx2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeResourceFromAuthorizationGroup", new Object[]{resourceID, resourceType});
        }
        if (cs == null) {
            cs = ConfigServiceFactory.getConfigService();
        }
        if (cs == null) {
            Properties prop = new Properties();
            prop.setProperty("location", "local");
            try {
                cs = ConfigServiceFactory.createConfigService(true, prop);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (cs == null) {
            return false;
        }
        String altResourceName = resourceID;
        int inx = resourceID.indexOf("#");
        if (inx > 0) {
            altResourceName = resourceID.substring(0, inx);
        }
        if (resourceType == null && inx > 0 && (inx2 = resourceID.indexOf("_", inx)) > 0) {
            resourceType = resourceID.substring(inx + 1, inx2);
        }
        if (resourceType == null || resourceID == null) {
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resourceType ", resourceType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "alt ResourceID ", altResourceName);
        }
        if ((resourceType.equals("Server") || resourceType.equals("ServerCluster") || resourceType.equals("Application") || resourceType.equals("Node") || resourceType.equals("NodeGroup")) && (authzGroup = AuthzGroupUtil.findAuthzGroupForResource(cs, session, resourceID, resourceType)) != null) {
            ArrayList members = (ArrayList)cs.getAttribute(session, authzGroup, "members", false);
            for (int j = 0; j < members.size(); ++j) {
                ObjectName member = (ObjectName)members.get(j);
                String memberName = (String)cs.getAttribute(session, member, "resourceName");
                String memberType = (String)cs.getAttribute(session, member, "resourceType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member ", memberName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type ", memberType);
                }
                if (!memberName.equals(resourceID) && !memberName.equals(altResourceName) || !memberType.equals(resourceType)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting member ", memberName);
                }
                cs.deleteConfigData(session, member);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeResourceFromAuthorizationGroup");
        }
        return true;
    }

    private static ObjectName findAuthzGroupForResource(ConfigService cs, Session session, String resourceID, String resourceType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAuthzGroupForResource", new Object[]{resourceID, resourceType});
        }
        ObjectName result = null;
        ObjectName[] authzGroups2 = AuthzGroupUtil.getAuthzGroupObjectName(session, cs, null);
        boolean found = false;
        for (int i = 0; i < authzGroups2.length; ++i) {
            ObjectName authzGroup = authzGroups2[i];
            ArrayList members = (ArrayList)cs.getAttribute(session, authzGroup, "members", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authzGroup ", authzGroup);
            }
            for (int j = 0; j < members.size(); ++j) {
                ObjectName member = (ObjectName)members.get(j);
                String memberName = (String)cs.getAttribute(session, member, "resourceName");
                String memberType = (String)cs.getAttribute(session, member, "resourceType");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member type ", memberType);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member name ", memberName);
                }
                if (!memberName.equals(resourceID) || !memberType.equals(resourceType)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found member ", memberName);
                }
                result = authzGroup;
                found = true;
                break;
            }
            if (found) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAuthzGroupForResource", result);
        }
        return result;
    }

    private static ObjectName[] getAuthzGroupObjectName(Session session, ConfigService cs, String authzGrpName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthzGroupObjectName", authzGrpName);
        }
        ObjectName[] result = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] authzGroups2 = cs.queryConfigObjects(session, null, pattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + authzGroups2);
        }
        if (authzGrpName == null || authzGrpName.equals("")) {
            result = authzGroups2;
        } else if (authzGroups2 != null) {
            for (int i = 0; i < authzGroups2.length; ++i) {
                ObjectName authzGrp = authzGroups2[i];
                String name = (String)cs.getAttribute(session, authzGrp, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authorization group name to check:  " + name);
                }
                if (!name.equals(authzGrpName)) continue;
                result = new ObjectName[]{authzGrp};
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthzGroupObjectName", result);
        }
        return result;
    }

    public static void changeNodeName(ConfigService cs, Session session, String oldNode, String newNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeNodeName", new Object[]{newNode, oldNode});
        }
        String cellName = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName[] cells = cs.queryConfigObjects(session, null, pattern, null);
        if (cells != null && cells.length > 0) {
            ObjectName cell = cells[0];
            cellName = ConfigServiceHelper.getDisplayName(cell);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell name " + cellName);
        }
        String oldNodeUri = "cells/" + cellName + "/nodes/" + oldNode;
        String newNodeUri = "cells/" + cellName + "/nodes/" + newNode;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "old Node uri " + oldNodeUri);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new Node uri " + newNodeUri);
        }
        pattern = ConfigServiceHelper.createObjectName(null, "AuthorizationGroup");
        ObjectName[] authzGroups2 = cs.queryConfigObjects(session, null, pattern, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "authzGroups ObjectNames are " + authzGroups2);
        }
        for (int i = 0; authzGroups2 != null && i < authzGroups2.length; ++i) {
            AuthorizationGroup ag;
            EList members;
            ObjectName authzGrp = authzGroups2[i];
            String name = (String)cs.getAttribute(session, authzGrp, "name");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authorization group name to check:  " + name);
            }
            if ((members = (ag = (AuthorizationGroup)MOFUtil.convertToEObject(session, authzGrp)).getMembers()) != null) {
                for (AuthorizationGroupMember agMember : members) {
                    boolean found = false;
                    String resName = agMember.getResourceName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "member name " + resName);
                    }
                    if (resName.startsWith(oldNodeUri)) {
                        found = true;
                        resName = newNodeUri + resName.substring(oldNodeUri.length());
                        agMember.setResourceName(resName);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "member name " + agMember.getResourceName());
                    }
                    EList props = null;
                    if (found) {
                        props = agMember.getMemberProperties();
                    }
                    if (props == null) continue;
                    for (Property prop : props) {
                        String parentName = prop.getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "parent name " + parentName);
                        }
                        if (parentName.startsWith(oldNodeUri)) {
                            parentName = newNodeUri + parentName.substring(oldNodeUri.length());
                            prop.setValue(parentName);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "parent name " + prop.getValue());
                    }
                }
            }
            ag.eResource().save(Collections.EMPTY_MAP);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeNodeName");
        }
    }
}

