/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class UpdateClusterCommand
extends AbstractAdminCommand
implements NotificationListener {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static TraceComponent tc = Tr.register(UpdateClusterCommand.class, "UpdateClusterCommand", "com.ibm.ws.management.commands.application");
    private static String APPNAME_PARAM = "ApplicationName";
    private static String TIMEOUT_PARAM = "timeout";
    private static final String UPDATEAPPONCLUSTERTASK_WAIT_PROP = "com.ibm.websphere.management.application.updateapponcluster.timeout";
    private String waitTarget = null;
    private long WAIT_TIME = 3600000L;
    private String waitObject = null;
    private ArrayList res = new ArrayList();
    private boolean successFlag = false;
    private AppManagementProxy appM = null;
    private WorkSpace ws = null;
    private String[] appNames = null;

    public UpdateClusterCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
        this.waitObject = new String("UpdateClusterCommandWaitObject");
    }

    public UpdateClusterCommand(CommandData inCommandData) throws CommandNotFoundException, CommandLoadException {
        super(inCommandData);
        this.waitObject = new String("UpdateClusterCommandWaitObject");
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.appNames = (String[])this.getParameter("ApplicationNames");
        Locale locale = this.getLocale();
        Vector<String> validApps = new Vector<String>();
        StringBuffer invalidApps = new StringBuffer();
        Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
        prefs.put("app.client.locale", locale);
        try {
            for (int i = 0; i < this.appNames.length; ++i) {
                boolean exists = this.appM.checkIfAppExists(this.appNames[i], prefs, this.ws.getUserName());
                if (!exists) {
                    if (invalidApps.length() != 0) {
                        invalidApps.append(' ');
                    }
                    invalidApps.append(this.appNames[i]);
                    String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.AppDeploymentMessages", "ADMA5045E", locale, new Object[]{this.appNames[i]}, "The application name " + this.appNames[i] + " cannot be found under any cell in the repository.");
                    this.res.add(msg);
                    Tr.error(tc, msg);
                    continue;
                }
                validApps.add(this.appNames[i]);
            }
        }
        catch (AdminException ae) {
            throw new CommandValidationException(ae, ae.getMessage());
        }
        if (validApps.size() == 0) {
            throw new InvalidParameterValueException(this.getName(), "ApplicationNames", "\"" + invalidApps.toString() + "\"");
        }
        if (invalidApps.length() > 0) {
            this.appNames = new String[validApps.size()];
            validApps.toArray(this.appNames);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting the command result.");
        }
        CommandResultImpl thisCmdResult = new CommandResultImpl();
        this.setCommandResult(thisCmdResult);
        thisCmdResult.reset();
        try {
            Integer timeout;
            Hashtable<String, Locale> prefs;
            block35: {
                CommandProviderHelper ch = CommandMgr.getCommandMgr().getCommandProviderHelper();
                ConfigService cs = ch.getConfigService();
                Session session = this.getConfigSession();
                Properties props = new Properties();
                props.setProperty("workspace.user.id", session.toString());
                this.ws = WorkSpaceManagerFactory.getManager().getWorkSpace(props);
                this.appM = (AppManagementProxy)AppManagementProxy.getJMXProxyForServer();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating " + this.getName() + " command.");
                }
                this.validate();
                if (this.appNames == null) {
                    this.appNames = (String[])this.getParameter("ApplicationNames");
                }
                prefs = new Hashtable<String, Locale>();
                prefs.put("app.client.locale", this.getLocale());
                String concAppNames = new String();
                for (int i = 0; i < this.appNames.length; ++i) {
                    concAppNames = concAppNames.concat(this.appNames[i]);
                    if (i >= this.appNames.length - 1) continue;
                    concAppNames = concAppNames.concat(";");
                }
                timeout = (Integer)this.getParameter("timeout");
                String id = "UpdateCluster:" + concAppNames;
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("websphere.admin.appmgmt");
                AdminServiceFactory.getAdminService().addNotificationListener(this.getAppMObjectName(), this, (NotificationFilter)filter, (Object)id);
                if (System.getProperty(UPDATEAPPONCLUSTERTASK_WAIT_PROP) != null) {
                    String tasktimeout = System.getProperty(UPDATEAPPONCLUSTERTASK_WAIT_PROP);
                    try {
                        this.WAIT_TIME = Long.parseLong(tasktimeout) * 1000L;
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block35;
                        Tr.debug(tc, "Invalid UpdateAppOnCluster time out value - " + tasktimeout);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting to update clusters.");
            }
            String string = this.waitObject;
            synchronized (string) {
                this.appM.updateCluster(this.appNames, timeout, prefs, this.ws.getUserName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UpdateAppOnCluster Wait time: " + this.WAIT_TIME / 1000L + "secs");
                }
                this.waitTarget = "UpdateCluster";
                this.waitObject.wait(this.WAIT_TIME);
                if (this.waitTarget != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Time out performing cluster update " + this.getName());
                    }
                    this.res.add("operation timed out.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting result of " + this.getName());
            }
            thisCmdResult.setResult(this.res);
        }
        catch (CommandValidationException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "command validation failed with exception", e);
            }
            this.appM = null;
            thisCmdResult.setException(e);
            thisCmdResult.setResult(this.res);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "command execution failed with exception", e);
            }
            thisCmdResult.setException(e);
            thisCmdResult.setResult(this.res);
        }
        finally {
            try {
                if (this.appM != null) {
                    AdminServiceFactory.getAdminService().removeNotificationListener(this.getAppMObjectName(), this);
                }
            }
            catch (Exception e) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    public void handleNotification(Notification notf, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification" + notf + " " + handback);
        }
        if (notf == null) {
            return;
        }
        Object ud = notf.getUserData();
        if (ud instanceof AppNotification) {
            this.appEventReceived((AppNotification)ud);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appEventReceived(AppNotification ev) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appEventReceived " + ev);
        }
        String msg = ev.message;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event received : " + ev.toString());
        }
        String string = this.waitObject;
        synchronized (string) {
            if (ev.taskName.equals(this.waitTarget) && ev.taskStatus.equals("Completed") || ev.taskStatus.equals("Failed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received : " + ev.taskStatus);
                }
                this.res.add(msg);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got STATUS_COMPLETED");
                }
                this.successFlag = ev.taskStatus.equals("Completed");
                this.waitTarget = null;
                this.waitObject.notifyAll();
            } else if (ev.taskName.equals(this.waitTarget)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received : " + msg);
                }
                this.res.add(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appEventReceived");
        }
    }

    private ObjectName getAppMObjectName() throws Exception {
        String q = "WebSphere:type=AppManagement,process=";
        q = q + AdminServiceFactory.getAdminService().getProcessName();
        q = q + ",*";
        ObjectName qName = new ObjectName(q);
        Iterator it = AdminServiceFactory.getAdminService().queryNames(qName, null).iterator();
        return (ObjectName)it.next();
    }
}

