/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.CommandGenerator;
import com.ibm.ws.management.commands.LangUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class AdminConfigCommands
implements CommandGenerator {
    private static TraceComponent tc = Tr.register(AdminConfigCommands.class, "AdminConfigCommands", "com.ibm.ws.management.commands");
    public static final String JACL = "jacl";
    public static final String JYTHON = "jython";
    private String commandName = "";
    private String messageKey = "";
    private String jaclScript = "";
    private String jythonScript = "";

    public void setSaveCmdData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSaveCmdData");
        }
        this.commandName = "save";
        this.messageKey = "ADMINCONFIG_HELP_SAVE";
        this.jaclScript = "$AdminConfig save";
        this.jythonScript = "AdminConfig.save()";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSaveCmdData");
        }
    }

    public void setRemoveCmdData(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRemoveCmdData", new Object[]{objectName});
        }
        this.commandName = "remove";
        this.messageKey = "ADMINCONFIG_HELP_REMOVE";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig remove \"" + configDataId.toString() + "\"";
        this.jythonScript = "AdminConfig.remove('(" + configDataId.toString() + ")')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRemoveCmdData");
        }
    }

    public void setCreateCmdData(String configObjType, EObject newObject, RepositoryContext repositoryContext, Properties attributes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCreateCmdData", new Object[]{configObjType, attributes, repositoryContext, newObject});
        }
        this.commandName = "create";
        this.messageKey = "ADMINCONFIG_HELP_CREATE";
        String parentString = this.buildParentString(newObject, repositoryContext);
        String jythonParentString = null;
        String jaclParentString = null;
        if (parentString.indexOf(124) < 0 && parentString.indexOf(35) < 0) {
            jaclParentString = "[$AdminConfig getid \"" + parentString + "\"] ";
            jythonParentString = "AdminConfig.getid('" + parentString + "'), ";
        } else {
            jaclParentString = "[ \"" + parentString + "\"] ";
            jythonParentString = "'(" + parentString + ")', ";
        }
        this.jaclScript = "$AdminConfig create " + configObjType + jaclParentString + LangUtils.formDisplayString(attributes, JACL);
        this.jythonScript = "AdminConfig.create('" + configObjType + "', " + jythonParentString + "'" + LangUtils.formDisplayString(attributes, JYTHON) + "')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCreateCmdData");
        }
    }

    public void setShowCmdData(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setShowCmdData", new Object[]{objectName});
        }
        this.commandName = "show";
        this.messageKey = "ADMINCONFIG_HELP_SHOW";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig show \"" + configDataId.toString() + "\"";
        this.jythonScript = "AdminConfig.show('(" + configDataId.toString() + ")')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setShowCmdData");
        }
    }

    public void setModifyCmdData(ObjectName objectName, Properties attributes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setModifyCmdData", new Object[]{objectName, attributes});
        }
        this.commandName = "modify";
        this.messageKey = "ADMINCONFIG_HELP_MODIFY";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig modify \"" + configDataId.toString() + "\" " + LangUtils.formDisplayString(attributes, JACL);
        this.jythonScript = "AdminConfig.modify('(" + configDataId.toString() + ")', '" + LangUtils.formDisplayString(attributes, JYTHON) + "')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setModifyCmdData");
        }
    }

    public void setListCmdData(String configObjType, ObjectName parentObject, RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setListCmdData", new Object[]{configObjType, parentObject, repositoryContext});
        }
        this.commandName = "list";
        this.messageKey = "ADMINCONFIG_HELP_LIST";
        String parentObjType = "";
        String parentObjName = "";
        try {
            if (parentObject != null) {
                parentObjType = ConfigServiceHelper.getConfigDataType(parentObject);
                parentObjName = ConfigServiceHelper.getDisplayName(parentObject);
            }
            String contextUri = this.transformContextUri(repositoryContext.getURI());
            if (parentObjType != null && parentObjType.length() > 0 && (parentObjName == null || parentObjName.length() == 0) || AdminConfigCommands.isTemplateContext(repositoryContext)) {
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(parentObject);
                this.jaclScript = "$AdminConfig list " + configObjType + " [" + configDataId.toString() + "]";
                this.jythonScript = "AdminConfig.list('" + configObjType + "', '(" + configDataId.toString() + ")')";
            } else {
                String parentObjTypeAndName;
                String tempContextUri = contextUri;
                if (parentObjType != null && parentObjType.length() > 0 && parentObjName != null && parentObjName.length() > 0 && !tempContextUri.endsWith(parentObjTypeAndName = parentObjType + ":" + parentObjName + "/")) {
                    tempContextUri = tempContextUri + parentObjTypeAndName;
                }
                this.jaclScript = "$AdminConfig list " + configObjType + " [$AdminConfig getid \"" + tempContextUri + "\"]";
                this.jythonScript = "AdminConfig.list('" + configObjType + "', AdminConfig.getid( '" + tempContextUri + "'))";
            }
        }
        catch (Throwable t) {
            this.jaclScript = this.jythonScript = "Exception caught while trying to generate command assistance: " + t.toString();
            t.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setListCmdData");
        }
    }

    public void setUnsetAttributesCmdData(ObjectName objectName, String[] attributes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUnsetAttributesCmdData", new Object[]{objectName, attributes});
        }
        this.commandName = "unsetAttributes";
        this.messageKey = "ADMINCONFIG_HELP_UNSETATTRIBUTES";
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        this.jaclScript = "$AdminConfig unsetAttributes \"" + configDataId.toString() + "\" " + LangUtils.formDisplayString(attributes, JACL);
        this.jythonScript = "AdminConfig.unsetAttributes('(" + configDataId.toString() + ")', '" + LangUtils.formDisplayString(attributes, JYTHON) + "')";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setModifyCmdData");
        }
    }

    public String getName() {
        return this.commandName;
    }

    public String generateScript(String lang) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScript", new Object[]{lang});
        }
        String cmdScript = "";
        if (lang.equals(JACL)) {
            cmdScript = this.jaclScript;
        } else if (lang.equals(JYTHON)) {
            cmdScript = this.jythonScript;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScript", new Object[]{cmdScript});
        }
        return cmdScript;
    }

    public String getDescription(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescription");
        }
        String desc = "";
        if (this.messageKey != null && this.messageKey.length() > 0) {
            desc = TraceNLS.getStringFromBundle("com.ibm.ws.scripting.resources.wscpMessage", this.messageKey, locale);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescription", new Object[]{desc});
        }
        return desc;
    }

    public String toString() {
        return "AdminConfig " + this.getName();
    }

    private String transformContextUri(String currContextUri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformContextUri");
        }
        StringBuffer uri = new StringBuffer("");
        if (!currContextUri.startsWith("templates")) {
            uri.append("/");
            StringTokenizer st = new StringTokenizer(currContextUri, "/");
            while (st.hasMoreElements()) {
                String name = st.nextToken();
                if ((name = String.valueOf(name.charAt(0)).toUpperCase() + name.substring(1)).equals("Nodegroups")) {
                    name = "NodeGroups";
                }
                if (name.equals("Coregroups")) {
                    name = "CoreGroups";
                }
                if (name.equals("Clusters")) {
                    name = "ServerCluster";
                }
                if (name.endsWith("s")) {
                    name = name.substring(0, name.length() - 1);
                }
                String value = st.nextToken();
                uri.append(name);
                uri.append(":");
                uri.append(value);
                uri.append("/");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformContextUri", new Object[]{uri.toString()});
        }
        return uri.toString();
    }

    private String buildParentString(EObject eObject, RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildParentString", new Object[]{eObject, repositoryContext});
        }
        String parentString = "";
        try {
            parentString = this.transformContextUri(repositoryContext.getURI());
            boolean needToUseConfigId = false;
            EObject parent = eObject.eContainer();
            if (AdminConfigCommands.isTemplateContext(repositoryContext)) {
                needToUseConfigId = true;
            } else if (parent == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This is a root object");
                }
            } else if (parent.eContainer() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This is a second level object");
                }
                ObjectName parentObject = MOFUtil.createObjectName(parent);
                String parentObjType = ConfigServiceHelper.getConfigDataType(parentObject);
                String parentObjName = ConfigServiceHelper.getDisplayName(parentObject);
                if (parentObjType != null && parentObjType.length() > 0 && parentObjName != null && parentObjName.length() > 0) {
                    String parentObjTypeAndName = parentObjType + ":" + parentObjName + "/";
                    if (!parentString.endsWith(parentObjTypeAndName)) {
                        parentString = parentString + parentObjTypeAndName;
                    }
                } else {
                    needToUseConfigId = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This is a third level (or deeper) object");
                }
                needToUseConfigId = true;
            }
            if (needToUseConfigId) {
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(MOFUtil.createObjectName(parent));
                parentString = configDataId.toString();
            }
        }
        catch (RuntimeException e) {
            Tr.error(tc, "Caught exception in AdminConfigCommands::buildParentString");
            e.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildParentString", new Object[]{parentString});
        }
        return parentString;
    }

    public static boolean isTemplateContext(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTemplateContext", new Object[]{repositoryContext});
        }
        boolean isTemplateContext = false;
        if (repositoryContext != null && repositoryContext.getURI().startsWith("templates")) {
            isTemplateContext = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTemplateContext", new Object[]{isTemplateContext});
        }
        return isTemplateContext;
    }
}

