/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.authorizer.ResourceRelationHandler;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResourceRelations {
    private static TraceComponent tc = Tr.register(ResourceRelationHandler.class, "ResourceRelationHandler", "com.ibm.ws.management.authorizer");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static HashMap resourceRelations;
    private static HashMap classNames;
    private static ResourceRelations resourceRelationsInstance;

    private ResourceRelations() {
        resourceRelations = new HashMap(5);
        classNames = new HashMap(5);
    }

    public static ResourceRelations getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)adminPermission);
        }
        return resourceRelationsInstance;
    }

    public synchronized void addResourceRelations(String resourceName, List parentResourceNames, String className) {
        Iterator ditr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceRelations", resourceName + " className= " + className);
        }
        ArrayList<String> removeList = new ArrayList<String>();
        List parentResources = (List)resourceRelations.get(resourceName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parent types = ");
            ditr = parentResourceNames.iterator();
            while (ditr.hasNext()) {
                Tr.debug(tc, (String)ditr.next());
            }
        }
        if (parentResources == null || parentResources.isEmpty()) {
            resourceRelations.put(resourceName, parentResourceNames);
        } else {
            Iterator itr = parentResourceNames.iterator();
            while (itr.hasNext()) {
                boolean duplicate = false;
                String pResourceName = (String)itr.next();
                for (String pResource : parentResources) {
                    if (!pResource.equals(pResourceName)) continue;
                    duplicate = true;
                    break;
                }
                if (!duplicate) continue;
                removeList.add(pResourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Duplicates list = ");
                ditr = removeList.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            for (String pResourceName : removeList) {
                if (!parentResourceNames.contains(pResourceName)) continue;
                parentResourceNames.remove(pResourceName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding these parents ");
                ditr = parentResourceNames.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
            for (String pResourceName : parentResourceNames) {
                resourceRelations.put(resourceName, pResourceName);
            }
        }
        if (className != null) {
            classNames.put(resourceName, className);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceRelations");
        }
    }

    public synchronized List getParentResources(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParentResources", resourceName);
        }
        List parentResources = (List)resourceRelations.get(resourceName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parents =");
            if (parentResources != null) {
                Iterator ditr = parentResources.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
        }
        if (parentResources == null) {
            return new ArrayList();
        }
        ArrayList parents = new ArrayList();
        parents.addAll(parentResources);
        return parents;
    }

    public synchronized List getAllParentResources(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentResources", resourceName);
        }
        HashSet lst = new HashSet();
        this.getAllParentResources(resourceName, lst);
        ArrayList newList = new ArrayList(lst);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllParentResources");
        }
        return newList;
    }

    private void getAllParentResources(String resourceName, Set lst) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllParentResources", resourceName);
        }
        List parentResources = (List)resourceRelations.get(resourceName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parents =");
            if (parentResources != null) {
                Iterator ditr = parentResources.iterator();
                while (ditr.hasNext()) {
                    Tr.debug(tc, (String)ditr.next());
                }
            }
        }
        if (parentResources == null) {
            return;
        }
        if (parentResources.isEmpty()) {
            return;
        }
        lst.addAll(parentResources);
        for (String parentResource : parentResources) {
            this.getAllParentResources(parentResource, lst);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllParentResources");
        }
    }

    public synchronized String getClassName(String resourceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassName", classNames.get(resourceName));
        }
        return (String)classNames.get(resourceName);
    }

    public synchronized List getClassNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassNames");
        }
        ArrayList classes = new ArrayList();
        Set keys = classNames.keySet();
        for (String key : keys) {
            classes.add(classNames.get(key));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassNames", classes);
        }
        return classes;
    }

    public synchronized boolean isInitialized() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInitialized");
        }
        boolean result = false;
        if (!resourceRelations.isEmpty()) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInitialized " + new Boolean(result));
        }
        return result;
    }

    public void display() {
        Set keys = resourceRelations.keySet();
        Iterator itr = keys.iterator();
        System.out.println("---------------------");
        System.out.println("---------------------");
        while (itr.hasNext()) {
            String resourceName = (String)itr.next();
            List parentResourceNames = (List)resourceRelations.get(resourceName);
            if (parentResourceNames == null) continue;
            System.out.println("Resource = " + resourceName);
            for (String parentResource : parentResourceNames) {
                System.out.println("    ParentResource = " + parentResource);
            }
            System.out.println("---------------------");
            System.out.println("    Class Name = " + classNames.get(resourceName));
            System.out.println("---------------------");
        }
        System.out.println("---------------------");
        System.out.println("---------------------");
    }

    static {
        resourceRelationsInstance = new ResourceRelations();
    }
}

