/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.authorizer;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzPackage;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class AuthTableParser {
    protected boolean emitTimestamp = true;
    protected boolean multiExtent = false;
    protected RolebasedauthzFactory authFactory;
    protected String url = null;
    protected EList rootExt = null;
    protected AuthorizationTableExt atx = null;
    protected Resource configResource = null;

    public AuthTableParser(String filename) {
        this.url = filename;
        this.initializeFactories();
    }

    public void initializeFactories() {
        ArchiveInit.init();
        CommonarchiveFactory factory = ((CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore")).getCommonarchiveFactory();
        ConfigInit.init();
        RolebasedauthzPackage authPackage = (RolebasedauthzPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi");
        this.authFactory = authPackage.getRolebasedauthzFactory();
    }

    protected Resource makeResource(String uri) {
        Resource resource = null;
        try {
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            URIConverterImpl uric = new URIConverterImpl();
            resourceSet.setURIConverter(uric);
            resource = resourceSet.createResource(URI.createURI(uri));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resource;
    }

    public void read(String fileName) {
        Resource res;
        this.configResource = res = this.makeResource(fileName);
        this.rootExt = res.getContents();
        Iterator iter = this.rootExt.iterator();
        this.atx = (AuthorizationTableExt)iter.next();
    }

    public void write(String filename) {
        try {
            this.configResource.save(new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showUsers(String role) {
        ArrayList<String> users = new ArrayList<String>(0);
        EList assignList = this.atx.getAuthorizations();
        for (RoleAssignmentExt rax : assignList) {
            if (!rax.getRole().getRoleName().equals(role)) continue;
            EList subs = rax.getUsers();
            for (UserExt sx : subs) {
                users.add(sx.getName());
            }
        }
        System.out.println("*** Users of Role " + role + " are : ");
        for (String user : users) {
            System.out.println(user);
        }
    }

    public void addUser(String user, String role) {
        UserExt ue = this.authFactory.createUserExt();
        ue.setName(user);
        System.out.println("Adding " + user + " to role " + role);
        EList assignList = this.atx.getAuthorizations();
        for (RoleAssignmentExt rax : assignList) {
            if (!rax.getRole().getRoleName().equals(role)) continue;
            rax.getUsers().add(ue);
        }
    }

    public void removeUser(String user, String role) {
        EList assignList = this.atx.getAuthorizations();
        Iterator iter = assignList.iterator();
        System.out.println("Removing " + user + " from role " + role);
        while (iter.hasNext()) {
            RoleAssignmentExt rax = (RoleAssignmentExt)iter.next();
            if (!rax.getRole().getRoleName().equals(role)) continue;
            EList users = rax.getUsers();
            Iterator itr = users.iterator();
            while (itr.hasNext()) {
                UserExt ue = (UserExt)itr.next();
                if (!ue.getName().equals(user)) continue;
                itr.remove();
            }
        }
    }

    public static void main(String[] args) {
        String filename = args[0];
        AuthTableParser ab = new AuthTableParser(filename);
        ab.read(filename);
        ab.showUsers("administrator");
        ab.showUsers("configurator");
        ab.showUsers("operator");
        ab.showUsers("monitor");
        System.out.println("************************");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("************************");
        ab.addUser("user1", "monitor");
        ab.addUser("user2", "administrator");
        ab.removeUser("user1", "configurator");
        System.out.println("************************");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("************************");
        ab.showUsers("administrator");
        ab.showUsers("configurator");
        ab.showUsers("operator");
        ab.showUsers("monitor");
        ab.write(filename);
    }
}

