/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MBeanExtensions {
    private static TraceComponent tc = Tr.register(MBeanExtensions.class, "Admin");
    private HashMap map = new HashMap();

    public MBeanExtensions(ConfigObject adminServiceCO, VariableMap variableMap, ExtClassLoader publicClassLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MBeanExtensions", new Object[]{adminServiceCO, variableMap, publicClassLoader});
        }
        List providers = adminServiceCO.getObjectList("extensionMBeanProviders");
        for (int i = 0; i < providers.size(); ++i) {
            ConfigObject providerCO = (ConfigObject)providers.get(i);
            String providerName = providerCO.getString("name", "__null__");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extension mbean provider name", providerName);
            }
            List providerClasspathList = providerCO.getStringList("classpath");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerClassPathList", providerClasspathList);
            }
            ArrayList<String> classpath = new ArrayList<String>();
            for (int ij = 0; ij < providerClasspathList.size(); ++ij) {
                String cp = variableMap.expand((String)providerClasspathList.get(ij));
                classpath.add(cp);
                publicClassLoader.addPath(cp);
            }
            List providerExtensionList = providerCO.getObjectList("extensionMBeans");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerExtensionList", providerExtensionList);
            }
            for (int j = 0; j < providerExtensionList.size(); ++j) {
                ConfigObject extension2 = (ConfigObject)providerExtensionList.get(j);
                String type = extension2.getString("type", "__null__");
                String uri = extension2.getString("descriptorURI", "__null__");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "{type, uri}", new Object[]{type, uri});
                }
                this.map.put(type, new Binder(uri, classpath));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MBeanExtensions");
        }
    }

    public String getDescriptorUri(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptorUri", type);
        }
        String uri = null;
        Binder binder = (Binder)this.map.get(type);
        if (binder != null) {
            uri = binder.uri;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptorUri: " + uri);
        }
        return uri;
    }

    public List getClasspath(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClasspath", type);
        }
        List list = new ArrayList();
        Binder binder = (Binder)this.map.get(type);
        if (binder != null) {
            list = binder.classpath;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClasspath");
        }
        return list;
    }

    private class Binder {
        String uri;
        List classpath;

        Binder(String uri, List classpath) {
            this.uri = uri;
            this.classpath = classpath;
        }
    }
}

