/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.MappingModule;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.AuthDataCredential;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class DataSourceConfigHelperMBean
extends RuntimeCollaborator {
    static final String resBundle = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register(DataSourceConfigHelperMBean.class, "Admin", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static Class configHelper = null;
    private static Method getPropertiesForDataSource = null;
    private static Method testConnectionToDataSource = null;
    private static Method testConnectionForGUI = null;
    private VariableMap variableMap = null;
    private VariableMap contextMap = null;
    private Repository repository = null;
    private static final String MAPPING_ALIAS_TRUSTEDCONNECTIONMAPPING = "TrustedConnectionMapping";

    public DataSourceConfigHelperMBean(VariableMap varMap, Repository rep) throws NoSuchMethodException {
        this.variableMap = varMap;
        this.repository = rep;
    }

    private synchronized Class getConfigHelper() throws ClassNotFoundException {
        if (configHelper == null) {
            configHelper = Class.forName("com.ibm.ws.rsadapter.DSConfigurationHelper");
        }
        return configHelper;
    }

    public ArrayList getPropertiesForDataSource(String dsClassName, String providerLibPath) throws ClassNotFoundException {
        String provLibPath = providerLibPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForDataSource", new Object[]{dsClassName, provLibPath});
        }
        if (getPropertiesForDataSource == null) {
            try {
                getPropertiesForDataSource = this.getConfigHelper().getMethod("getPropertiesForDataSource", String.class, String.class);
            }
            catch (NoSuchMethodException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.getPropertiesForDataSource", (String)"65", (Object)this);
            }
        }
        provLibPath = this.variableMap.expand(provLibPath);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expanded libPath to " + provLibPath);
        }
        Object ret = null;
        try {
            ret = getPropertiesForDataSource.invoke(null, dsClassName, provLibPath);
        }
        catch (IllegalAccessException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.getPropertiesForDataSource", (String)"74", (Object)this);
        }
        catch (InvocationTargetException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.getPropertiesForDataSource", (String)"77", (Object)this);
            throw (ClassNotFoundException)exc.getTargetException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForDataSource", ret);
        }
        return (ArrayList)ret;
    }

    public String testConnectionToDataSource(String dsClassName, String user, String password, Properties dataSourceProps, String providerLibPath, String language, String country) throws ClassNotFoundException {
        String provLibPath = providerLibPath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnectionToDataSource", new Object[]{dsClassName, user, dataSourceProps, provLibPath, language, country});
        }
        this.reload();
        if (testConnectionToDataSource == null) {
            try {
                testConnectionToDataSource = this.getConfigHelper().getMethod("testConnectionToDataSource", String.class, String.class, String.class, Properties.class, String.class, String.class, String.class);
            }
            catch (NoSuchMethodException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.testConnectionToDataSource", (String)"141", (Object)this);
            }
        }
        provLibPath = this.variableMap.expand(provLibPath);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expanded libPath to " + provLibPath);
        }
        Properties dsPropsCopy = new Properties();
        dsPropsCopy.putAll((Map<?, ?>)dataSourceProps);
        Enumeration<?> e = dsPropsCopy.propertyNames();
        while (e.hasMoreElements()) {
            String pName = (String)e.nextElement();
            String pVal = dsPropsCopy.getProperty(pName);
            if (pName.equals("databaseName")) {
                pVal = this.variableMap.expand(pVal);
            }
            dsPropsCopy.put(pName, pVal);
        }
        Object result = null;
        try {
            result = testConnectionToDataSource.invoke(null, dsClassName, user, password, dsPropsCopy, provLibPath, language, country);
        }
        catch (IllegalAccessException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.testConnectionToDataSource", (String)"152", (Object)this);
        }
        catch (InvocationTargetException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.testConnectionToDataSource", (String)"155", (Object)this);
            throw (ClassNotFoundException)exc.getTargetException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnectionToDataSource", result);
        }
        return (String)result;
    }

    public void reload() {
        try {
            this.variableMap.refresh();
            if (AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot Call reload() on ResourceMgr because the service: JNDI name space does not exist");
                }
            } else {
                InitialContext ic = new InitialContext();
                ResourceMgr rm = (ResourceMgr)ic.lookup("services:websphere/Resources/ResourceManager");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling reload() on ResourceMgr");
                }
                rm.reload();
            }
        }
        catch (NamingException ne) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "services:websphere/Resources/ResourceManager is not a valid name");
            }
            FFDCFilter.processException((Throwable)ne, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.reload", (String)"275", (Object)this);
        }
        catch (RuntimeError re) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught runtime error exception = " + re);
            }
            FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.reload", (String)"279", (Object)this);
        }
        catch (RuntimeWarning rw) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught Runtime Warning exception = " + rw);
            }
            FFDCFilter.processException((Throwable)rw, (String)"com.ibm.ws.management.DataSourceConfigHelperMBean.reload", (String)"283", (Object)this);
        }
    }

    public int testConnection(String configId) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection", new Object[]{configId});
        }
        this.reload();
        String out = null;
        int start = configId.lastIndexOf(40);
        int end = configId.lastIndexOf(41);
        out = start != -1 && end != -1 ? configId.substring(start + 1, end) : configId;
        Hashtable ht = null;
        try {
            ht = this.extractWCCMCommonInfo(out);
            String dsClassName = (String)ht.get("dsClassName");
            String user = (String)ht.get("user");
            String password = (String)ht.get("password");
            String providerLibPath = (String)ht.get("providerLibPath");
            String factory = (String)ht.get("factory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling testConnection() on " + factory);
            }
            if (factory.equals("DataSource") || factory.equals("WAS40DataSource")) {
                Properties dataSourceProps = (Properties)ht.get("customProperties");
                dataSourceProps.remove("_Websphere_Config_Data_Type");
                dataSourceProps.remove("_Websphere_Config_Data_Id");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Going into final test with these : ");
                    Tr.debug(tc, "dsClassName " + dsClassName);
                    Tr.debug(tc, "user " + user);
                    Tr.debug(tc, "dataSourceProps " + dataSourceProps.getClass().getName() + dataSourceProps);
                    Tr.debug(tc, "providerLibPath " + providerLibPath);
                }
                return this.testConnectionToDataSource2(dsClassName, user, password, dataSourceProps, providerLibPath);
            }
            if (factory.equals("CICSFactory")) {
                Tr.error(tc, "TEST_DS_FAIL", new Object[]{"", "NLS:CICS not yet implmented"});
                throw new Exception("NLS:CICS not yet implmented");
            }
            Tr.error(tc, "TEST_DS_FAIL", new Object[]{"", "NLS:Unknown resource specified"});
            throw new Exception("NLS:Unknown resource specified");
        }
        catch (Throwable ex) {
            Tr.error(tc, "TEST_DS_FAIL", new Object[]{"", ex});
            ex.printStackTrace();
            if (ex instanceof Exception) {
                throw (Exception)ex;
            }
            throw new SQLException(ex.toString());
        }
    }

    private int testConnectionToDataSource2(String dsClassName, String user, String password, Properties dataSourceProps, String providerLibPath) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnectionForGUI", new Object[]{dataSourceProps, dsClassName, user, providerLibPath});
        }
        Integer result = null;
        try {
            if (testConnectionForGUI == null) {
                testConnectionForGUI = this.getConfigHelper().getMethod("testConnectionForGUI", String.class, String.class, String.class, Properties.class, String.class);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking test connection on the helper");
            }
            result = (Integer)testConnectionForGUI.invoke(null, dsClassName, user, password, dataSourceProps, providerLibPath);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation exception, real exception =  " + t.toString());
            }
            t.printStackTrace();
            throw t;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnectionForGUI", result);
        }
        return result;
    }

    private synchronized Hashtable extractWCCMCommonInfo(String rfID) throws Exception {
        String tempNativePath;
        Hashtable<String, Object> ht;
        block68: {
            String server_name;
            String dbname;
            String databaseName;
            String password;
            J2EEResourceFactory dataSource;
            ht = new Hashtable<String, Object>();
            ConfigDataId cdid = new ConfigDataId(rfID);
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, cdid.getContextUri() + cdid.getHref());
                Tr.debug(tc, "MBean is running in a process of type: " + processType);
            }
            ObjectName ret = new ObjectName("WebSphere", "_Websphere_Config_Data_Id", rfID);
            Properties loc = ConfigServiceHelper.getObjectLocation(ret);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scope =" + loc);
            }
            HashMap<String, String> test = new HashMap<String, String>(17);
            test.put("CELL", this.repository.getCellName());
            test.put("NODE", this.repository.getNodeName());
            test.put("CLUSTER", this.repository.getClusterName());
            if (loc.containsKey("server")) {
                test.put("SERVER", loc.getProperty("server"));
            } else {
                test.put("SERVER", this.repository.getServerName());
            }
            this.contextMap = VariableMapFactory.createVariableMap(test);
            Resource res = null;
            ConfigRoot cr = this.repository.getConfigRoot();
            if (loc.containsKey("server")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for server-scoped resource.");
                    Tr.debug(tc, "ConfigRoot being changed from " + cr.getValue(4) + " to " + loc.getProperty("server"));
                }
                cr.setValue(4, loc.getProperty("server"));
                res = cr.getResource(4, "resources.xml");
                this.contextMap.addVariableMap(cr.getResource(0, "variables.xml"));
                this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                this.contextMap.addVariableMap(cr.getResource(4, "variables.xml"));
            } else if (loc.containsKey("node")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for node-scoped resource.");
                }
                res = cr.getResource(3, "resources.xml");
                this.contextMap.addVariableMap(cr.getResource(0, "variables.xml"));
                this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                if (processType.equals("ManagedProcess") || processType.equals("UnManagedProcess")) {
                    this.contextMap.addVariableMap(cr.getResource(4, "variables.xml"));
                }
            } else if (loc.containsKey("application")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for application-scoped resource.");
                }
                String earName = loc.getProperty("application");
                String appName = null;
                appName = earName.length() > 4 && earName.substring(earName.length() - 4).equalsIgnoreCase(".ear") ? earName.substring(0, earName.length() - 4) : earName;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigRoot APPLICATION value set to " + loc.getProperty("application"));
                    Tr.debug(tc, "ConfigRoot SERVER value set to " + cr.getValue(4));
                    Tr.debug(tc, "ConfigRoot CLUSTER value set to " + cr.getValue(2));
                    Tr.debug(tc, "ConfigRoot NODE value set to " + cr.getValue(3));
                    Tr.debug(tc, "ConfigRoot CELL value set to " + cr.getValue(0));
                }
                cr.setValue(1, loc.getProperty("application"));
                res = cr.getResource(1, "deployments" + File.separator + appName + File.separator + "resources.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Cell variables to Map...");
                }
                this.contextMap.addVariableMap(cr.getResource(0, "variables.xml"));
                if (processType.equals("NodeAgent")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Node variables to Map...");
                    }
                    this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                }
                if (processType.equals("ManagedProcess") || processType.equals("UnManagedProcess")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Node and Server variables to Map...");
                    }
                    this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                    this.contextMap.addVariableMap(cr.getResource(4, "variables.xml"));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Application variables to Map...");
                    }
                    this.contextMap.addVariableMap(cr.getResource(1, "deployments" + File.separator + appName + File.separator + "variables.xml"));
                }
                catch (FileNotFoundException fnfe) {}
            } else if (loc.containsKey("cluster")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for cluster-scoped resource.");
                }
                cr.setValue(2, loc.getProperty("cluster"));
                res = cr.getResource(2, "resources.xml");
                this.contextMap.addVariableMap(cr.getResource(0, "variables.xml"));
                if (processType.equals("NodeAgent") || processType.equals("ManagedProcess")) {
                    this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                }
                try {
                    this.contextMap.addVariableMap(cr.getResource(2, "variables.xml"));
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
                if (processType.equals("ManagedProcess")) {
                    this.contextMap.addVariableMap(cr.getResource(4, "variables.xml"));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for cell-scoped resource.");
                }
                res = cr.getResource(0, "resources.xml");
                this.contextMap.addVariableMap(cr.getResource(0, "variables.xml"));
                if (processType.equals("NodeAgent")) {
                    this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                }
                if (processType.equals("ManagedProcess") || processType.equals("UnManagedProcess")) {
                    this.contextMap.addVariableMap(cr.getResource(3, "variables.xml"));
                    this.contextMap.addVariableMap(cr.getResource(4, "variables.xml"));
                }
            }
            URI uri = URI.createURI(cdid.getHref());
            String dataStoreHelperClass = null;
            String mappingConfigAlias = null;
            try {
                dataSource = (DataSource)res.getEObject(uri.fragment());
                if (dataSource == null) {
                    String text = TraceNLS.getFormattedMessage("resources/IBMDataStoreAdapterNLS", "TEST_DS_NOT_FOUND", Locale.getDefault(), new Object[0], "The DataSource was not found.  Be sure that the DataSource has been saved before attempting the Test Connection operation");
                    Tr.error(tc, text);
                    throw new SQLException(text);
                }
                ht.put("factory", "DataSource");
                MappingModule mapMod = dataSource.getMapping();
                if (mapMod != null) {
                    mappingConfigAlias = mapMod.getMappingConfigAlias();
                }
                String username = null;
                password = null;
                try {
                    AuthDataCredential authDC = null;
                    if (MAPPING_ALIAS_TRUSTEDCONNECTIONMAPPING.equalsIgnoreCase(mappingConfigAlias)) {
                        if (mapMod != null) {
                            authDC = WSDefaultPrincipalMapping.getAuthData((String)mapMod.getAuthDataAlias());
                        }
                    } else {
                        authDC = WSDefaultPrincipalMapping.getAuthData((String)((DataSource)dataSource).getAuthDataAlias());
                        if (authDC == null && mapMod != null) {
                            authDC = WSDefaultPrincipalMapping.getAuthData((String)mapMod.getAuthDataAlias());
                        }
                    }
                    if (authDC != null) {
                        username = authDC.getUserName();
                        password = authDC.getPassword();
                    }
                }
                catch (LoginException le) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (username != null) {
                    ht.put("user", username);
                }
                if (password != null) {
                    ht.put("password", password);
                }
                dataStoreHelperClass = ((DataSource)dataSource).getDatasourceHelperClassname();
            }
            catch (ClassCastException cce) {
                dataSource = (WAS40DataSource)res.getEObject(uri.fragment());
                ht.put("factory", "WAS40DataSource");
                String user = ((WAS40DataSource)dataSource).getDefaultUser();
                password = ((WAS40DataSource)dataSource).getDefaultPassword();
                if (user != null) {
                    ht.put("user", user);
                }
                if (password != null) {
                    ht.put("password", password);
                }
            }
            JDBCProvider jdbcp = (JDBCProvider)dataSource.getProvider();
            String jndiName = dataSource.getJndiName();
            Properties props = new Properties();
            J2EEResourcePropertySet jp = dataSource.getPropertySet();
            if (jp != null) {
                EList propSet = jp.getResourceProperties();
                for (int i = 0; i < propSet.size(); ++i) {
                    J2EEResourceProperty property = (J2EEResourceProperty)propSet.get(i);
                    String value = property.getValue();
                    if (value == null) continue;
                    String name = property.getName();
                    if (name.toLowerCase().indexOf("password") != -1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Decoding property : " + name);
                        }
                        props.put(name, PasswordUtil.passwordDecode((String)value));
                        continue;
                    }
                    props.put(name, value);
                }
            }
            if (ht.get("factory").equals("WAS40DataSource") && (databaseName = ((WAS40DataSource)dataSource).getDatabaseName()) != null) {
                props.setProperty("databaseName", databaseName);
            }
            if ((dbname = props.getProperty("databaseName")) != null) {
                props.setProperty("databaseName", this.contextMap.expand(dbname));
            }
            if ((server_name = props.getProperty("serverName")) != null) {
                props.setProperty("serverName", this.contextMap.expand(server_name));
            }
            if (dataStoreHelperClass != null) {
                props.setProperty("dataStoreHelperClass", dataStoreHelperClass);
            }
            if (processType.equals("UnManagedProcess") || processType.equals("ManagedProcess")) {
                props.setProperty("mbeanProcessType", "server");
            } else {
                props.setProperty("mbeanProcessType", "other");
            }
            props.setProperty("dataSourceJndiName", jndiName);
            if (mappingConfigAlias != null) {
                props.setProperty("dsCfgHelper.mappingConfigAlias", mappingConfigAlias);
            }
            ht.put("customProperties", props);
            ht.put("providerLibPath", this.expandPath(jdbcp.getClasspath()));
            String implementationClassName = jdbcp.getImplementationClassName();
            if (implementationClassName != null) {
                ht.put("dsClassName", this.contextMap.expand(implementationClassName));
            }
            tempNativePath = "";
            try {
                tempNativePath = this.expandPath(jdbcp.getNativepath());
            }
            catch (IllegalArgumentException iae) {
                if (!tc.isDebugEnabled()) break block68;
                Tr.debug(tc, "IllegalStateException ignored while expanding nativepath.\nCOULD be due to a referenced variable which is not defined at the testing scope.\n");
            }
        }
        ht.put("nativepath", tempNativePath);
        if (tc.isDebugEnabled()) {
            Enumeration keys = ht.keys();
            Enumeration elements = ht.elements();
            boolean _undo523266 = Boolean.getBoolean("_undo523266");
            String key = null;
            String value = null;
            while (keys.hasMoreElements()) {
                key = keys.nextElement().toString();
                value = elements.nextElement().toString();
                if (key.equalsIgnoreCase("password") && !_undo523266) {
                    value = "********";
                }
                Tr.debug(tc, key + " = " + value);
            }
        }
        return ht;
    }

    private String expandPath(List list) {
        StringBuffer cpb = null;
        Iterator arrayListIter = list.iterator();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Converting " + list.toString());
        }
        while (arrayListIter.hasNext()) {
            if (cpb == null) {
                cpb = new StringBuffer();
                cpb.append(this.contextMap.expand((String)arrayListIter.next()));
                continue;
            }
            cpb.append(File.pathSeparator);
            cpb.append(this.contextMap.expand((String)arrayListIter.next()));
        }
        if (cpb == null) {
            return "";
        }
        return cpb.toString();
    }

    public String testConnectionToDataSource(String dsClassName, String user, String password, Properties dataSourceProps, String providerLibPath, Locale locale) throws ClassNotFoundException {
        return this.testConnectionToDataSource(dsClassName, user, password, dataSourceProps, providerLibPath, locale.getLanguage(), locale.getCountry());
    }
}

