/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.MBeanExtensions;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.DiscoveryMBean;
import com.ibm.wsspi.management.agent.AdminSubsystemServiceRegistry;
import java.util.Properties;
import javax.management.ObjectName;

public class AdminInitializer {
    private static TraceComponent tc = Tr.register(AdminInitializer.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static AdminInitializer instance;
    private MBeanFactory _mbfactory;
    private AdminServiceImpl _adminService;
    private MBeanExtensions mbeanExtensions;
    private Properties configProps;
    private String adminType;
    private String repositoryRootURI;
    private String thisNodeName;
    private String thisCellName;
    private String thisProcessName;
    private String thisServerType;
    private String thisCellType;
    private boolean thisCellRegistered;
    public static final String ROOT_URI_PROPERTY = "repositoryRootURIProperty";
    public static final String NODENAME_CFG_PROPERTY = "nodeNameConfigProperty";
    public static final String CELLNAME_CFG_PROPERTY = "cellNameConfigProperty";
    public static final String CELLTYPE_CFG_PROPERTY = "cellTypeConfigProperty";
    public static final String CELLREGISTERED_CFG_PROPERTY = "cellRegisteredConfigProperty";
    public static final String PROCESSNAME_CFG_PROPERTY = "processNameConfigProperty";
    public static final String ADMIN_TYPE_PROPERTY = "adminTypeProperty";
    public static final String CELL_DISC_PROTOCOL_CFG_PROPERTY = "cellDiscoveryProtocolConfigProperty";
    public static final String NODE_DISC_PROTOCOL_CFG_PROPERTY = "nodeDiscoveryProtocolConfigProperty";
    private static final String TMX4J_HTTP_PORT_PROPERTY = "jmx.http.port";
    public static final String DEFAULT_HTTP_CONNECTOR_PORT = "8082";
    public static final String SERVERTYPE_CFG_PROPERTY = "serverTypeConfigProperty";
    private String subsystemUUID = null;

    private AdminInitializer() {
    }

    private AdminInitializer(String uuid) {
        this.subsystemUUID = uuid;
    }

    public Properties getProperties() {
        this.checkAdminContext();
        return this.configProps;
    }

    public static AdminInitializer getInstance() {
        AdminInitializer ret;
        String uuid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance, UUID:" + AdminContext.peek());
        }
        if ((uuid = AdminContext.peek()) == null) {
            if (instance == null) {
                instance = new AdminInitializer();
            }
            ret = instance;
        } else {
            ret = (AdminInitializer)AdminSubsystemServiceRegistry.getService((String)AdminInitializer.class.getName());
            if (ret == null) {
                ret = new AdminInitializer(uuid);
                AdminSubsystemServiceRegistry.addService((String)AdminInitializer.class.getName(), (Object)ret);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return ret;
    }

    public void initialize(Properties p) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize AdminContext:" + AdminContext.peek(), p);
        }
        this.checkAdminContext();
        String uuid = AdminContext.peek();
        this.configProps = p;
        this._adminService = (AdminServiceImpl)AdminServiceFactory.getAdminService();
        this._mbfactory = this._adminService.getMBeanFactory();
        this.thisNodeName = (String)this.configProps.get(NODENAME_CFG_PROPERTY);
        this.thisCellName = (String)this.configProps.get(CELLNAME_CFG_PROPERTY);
        this.thisProcessName = (String)this.configProps.get(PROCESSNAME_CFG_PROPERTY);
        this.adminType = (String)this.configProps.get(ADMIN_TYPE_PROPERTY);
        this.repositoryRootURI = (String)this.configProps.get(ROOT_URI_PROPERTY);
        this.thisServerType = (String)this.configProps.get(SERVERTYPE_CFG_PROPERTY);
        this.thisCellType = this.configProps.getProperty(CELLTYPE_CFG_PROPERTY);
        this.thisCellRegistered = new Boolean(this.configProps.getProperty(CELLREGISTERED_CFG_PROPERTY));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellType = ", this.thisCellType);
            Tr.debug(tc, "cellRegistered = ", this.thisCellRegistered);
            Tr.debug(tc, "thisNode = ", this.thisNodeName);
        }
        this._adminService.setProcessType(this.adminType);
        this._adminService.setCellName(this.thisCellName);
        this._adminService.setNodeName(this.thisNodeName);
        this._adminService.setProcessName(this.thisProcessName);
        this._adminService.setServerType(this.thisServerType);
        this._adminService.setCellType(this.thisCellType);
        if (uuid != null) {
            this._adminService.setCellRegistered(this.thisCellRegistered);
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this._adminService.initializeNotificationService();
        }
        if (uuid == null && (!this.adminType.equals("UnManagedProcess") && !this.adminType.equals("AdminAgent") || this.adminType.equals("UnManagedProcess") && this.thisCellRegistered)) {
            try {
                DiscoveryMBean discovery2 = new DiscoveryMBean();
                ObjectName name = this._mbfactory.activateMBean("Discovery", discovery2, "Discovery", null);
                RoutingTable.getInstance().addRoutingListener(discovery2);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.management.component.AdminImpl.initialize", (String)"255", (Object)this);
            }
        }
        Tr.audit(tc, "ADMN0015I");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void setMBeanExtensions(MBeanExtensions ext) {
        this.checkAdminContext();
        this.mbeanExtensions = ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanExtensions getMBeanExtensions() {
        this.checkAdminContext();
        if (this.mbeanExtensions != null || this.subsystemUUID == null) {
            return this.mbeanExtensions;
        }
        boolean pushed = false;
        try {
            pushed = AdminContext.push(null);
            MBeanExtensions mBeanExtensions = AdminInitializer.getInstance().getMBeanExtensions();
            return mBeanExtensions;
        }
        finally {
            if (pushed) {
                AdminContext.pop();
            }
        }
    }

    private void checkAdminContext() {
        String uuid = AdminContext.peek();
        if (this.subsystemUUID == uuid || this.subsystemUUID != null && this.subsystemUUID.equals(uuid) || uuid != null && uuid.equals(this.subsystemUUID)) {
            return;
        }
        IllegalArgumentException ex = new IllegalArgumentException("AdminInitializer was created with subsystem UUID " + this.subsystemUUID + " but is being accessed with AdminContext UUID: " + uuid);
        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.management.component.AdminInitializer.checkAdminContext", (String)"221", (Object)this);
        throw ex;
    }
}

