/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

class StringUtils {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    StringUtils() {
    }

    static String peelQuotes(String aString) {
        boolean done = false;
        while (!done && aString != null) {
            done = true;
            if (aString.startsWith("\"")) {
                aString = aString.substring(1);
                done = false;
            }
            if (!aString.endsWith("\"")) continue;
            aString = aString.substring(0, aString.length() - 1);
            done = false;
        }
        return aString;
    }

    static String[] split(String aString, int ch) {
        int numComponents = 0;
        int curIndex = 0;
        while (true) {
            curIndex = aString.indexOf(ch, curIndex);
            ++numComponents;
            if (curIndex == -1) break;
            ++curIndex;
        }
        String[] result = new String[numComponents];
        int start = 0;
        int end = aString.indexOf(ch, 0);
        for (int i = 0; i < numComponents; ++i) {
            result[i] = i + 1 == numComponents ? aString.substring(start) : aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(ch, start);
        }
        return result;
    }

    static String[] primitiveArrayToString(Object o) {
        if (Byte.TYPE.equals(o.getClass().getComponentType())) {
            return new String[]{StringUtils.byteArrayToHexString((byte[])o)};
        }
        if (Integer.TYPE.equals(o.getClass().getComponentType())) {
            int[] tmp = (int[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Integer.toString(tmp[i]);
            }
            return result;
        }
        return new String[]{"Illegal trace argument: array of " + o.getClass().getComponentType()};
    }

    static String byteArrayToHexString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            result.append(hexChars[b[i] >> 4 & 0xF]);
            result.append(hexChars[b[i] & 0xF]);
        }
        return new String(result);
    }
}

