/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.webcontainerext.ws;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import java.io.File;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSPClassloaderContextImpl
implements JspClassloaderContext {
    private static final String WAS_ROOT_BASE = System.getProperty("was.install.root");
    private static final String WAS_ROOT = WAS_ROOT_BASE + File.separator;
    private static final String WAS_CLASSES = WAS_ROOT + "classes";
    private static final String WAS_LIB = WAS_ROOT + "lib" + File.separator;
    private static final String WAS_LIB_EXT = WAS_LIB + "ext";
    private static final String WAS_BUNDLES = WAS_ROOT_BASE + File.separator + "plugins" + File.separator;
    private static String classesClasspath = null;
    private static String libExtClasspath = null;
    private static String requiredClasspath = null;
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.JSPClassloaderContextImpl";
    private ClassLoader loader = null;
    private String classpath = "";
    private JspXmlExtConfig webAppConfig = null;
    private boolean useOptimizedClasspath = false;

    public JSPClassloaderContextImpl(ClassLoader loader, JspXmlExtConfig webAppConfig) {
        this.loader = loader;
        this.webAppConfig = webAppConfig;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        if (this.classpath.trim().length() > 0) {
            return this.classpath;
        }
        logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "jspCompileClasspath: " + this.webAppConfig.getJspOptions().getJspCompileClasspath());
        StringBuffer additionalClasspath = null;
        if (WAS_ROOT_BASE != null) {
            if (this.webAppConfig.getJspOptions().getJspCompileClasspath() != null) {
                StringTokenizer st = new StringTokenizer(this.webAppConfig.getJspOptions().getJspCompileClasspath(), " ");
                int i = 0;
                int tokenCount = st.countTokens();
                while (st.hasMoreTokens()) {
                    if (additionalClasspath == null) {
                        additionalClasspath = new StringBuffer();
                    }
                    additionalClasspath.append(WAS_ROOT + st.nextToken());
                    if (++i >= tokenCount) continue;
                    additionalClasspath.append(File.pathSeparator);
                }
            }
            logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "additionalClasspath: [" + additionalClasspath + "]");
            logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "loader: [" + this.loader + "]");
            if (this.loader instanceof ReloadableClassLoader || this.loader instanceof CompoundClassLoader) {
                boolean parentParentFirst;
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "about to build classpath");
                boolean parentFirst = false;
                String webappClasspath = null;
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "loader instanceof com.ibm.ws.classloader.ReloadableClassLoader: [" + (this.loader instanceof ReloadableClassLoader) + "]");
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "loader instanceof com.ibm.ws.classloader.CompoundClassLoader: [" + (this.loader instanceof CompoundClassLoader) + "]");
                if (this.loader instanceof ReloadableClassLoader) {
                    webappClasspath = ((ReloadableClassLoader)this.loader).getClassPath();
                    logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "ReloadableClassLoader.getClassPath(): [" + ((ReloadableClassLoader)this.loader).getClassPath() + "]");
                    parentFirst = ((ReloadableClassLoader)this.loader).getDelegationMode();
                } else if (this.loader instanceof CompoundClassLoader) {
                    webappClasspath = ((CompoundClassLoader)this.loader).getClassPath();
                    logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "CompoundClassLoader.getClassPath(): [" + ((CompoundClassLoader)this.loader).getClassPath() + "]");
                    parentFirst = ((CompoundClassLoader)this.loader).getDelegationMode();
                }
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "webappClasspath: [" + webappClasspath + "]");
                ClassLoader parentLoader = this.loader.getParent();
                String parentClasspath = null;
                if (parentLoader instanceof ReloadableClassLoader) {
                    parentClasspath = this.getPathsAsString(((ReloadableClassLoader)parentLoader).getPaths());
                    parentParentFirst = ((ReloadableClassLoader)parentLoader).getDelegationMode();
                    if (parentFirst && !parentParentFirst) {
                        parentFirst = false;
                    }
                } else if (parentLoader instanceof CompoundClassLoader) {
                    parentClasspath = this.getPathsAsString(((CompoundClassLoader)parentLoader).getPaths());
                    parentParentFirst = ((CompoundClassLoader)parentLoader).getDelegationMode();
                    if (parentFirst && !parentParentFirst) {
                        parentFirst = false;
                    }
                }
                StringBuffer cp = new StringBuffer();
                if (parentFirst) {
                    if (classesClasspath.length() > 0) {
                        cp.append(classesClasspath);
                    }
                    cp.append(requiredClasspath);
                    if (libExtClasspath.length() > 0) {
                        cp.append(libExtClasspath);
                    }
                    cp.append(webappClasspath);
                    if (!webappClasspath.endsWith(File.pathSeparator)) {
                        cp.append(File.pathSeparator);
                    }
                    if (parentClasspath != null && !parentClasspath.equals("")) {
                        cp.append(parentClasspath);
                        if (!parentClasspath.endsWith(File.pathSeparator)) {
                            cp.append(File.pathSeparator);
                        }
                    }
                } else {
                    cp.append(webappClasspath);
                    if (!webappClasspath.endsWith(File.pathSeparator)) {
                        cp.append(File.pathSeparator);
                    }
                    if (parentClasspath != null && !parentClasspath.equals("")) {
                        cp.append(parentClasspath);
                        if (!parentClasspath.endsWith(File.pathSeparator)) {
                            cp.append(File.pathSeparator);
                        }
                    }
                    if (classesClasspath.length() > 0) {
                        cp.append(classesClasspath);
                    }
                    cp.append(requiredClasspath);
                    if (libExtClasspath.length() > 0) {
                        cp.append(libExtClasspath);
                    }
                }
                if (additionalClasspath != null) {
                    cp.append(additionalClasspath);
                }
                this.classpath = cp.toString();
                logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "constructed classpath: [" + cp.toString() + "]");
            }
        }
        logger.logp(Level.FINE, CLASS_NAME, "getClassPath", "returning classpath: [" + this.classpath + "]");
        return this.classpath;
    }

    public String getOptimizedClassPath() {
        return this.getClassPath();
    }

    public boolean isPredefineClassEnabled() {
        return CompoundClassLoader.plugin != null;
    }

    public byte[] predefineClass(String className, byte[] classData) {
        if (CompoundClassLoader.plugin != null) {
            return CompoundClassLoader.plugin.preDefineApplicationClass(className, classData);
        }
        return classData;
    }

    private static String loadClasspathFromDirectory(String dir) {
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dir: " + dir);
        StringBuffer cp = new StringBuffer();
        File dirFile = new File(dir);
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dirFile: " + dirFile);
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dirFile.exists(): " + dirFile.exists());
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "dirFile.isDirectory(): " + dirFile.isDirectory());
        if (dirFile.exists() && dirFile.isDirectory()) {
            String[] classesFileList = dirFile.list();
            logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "classesFileList: " + classesFileList);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && classesFileList != null) {
                logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "classesFileList.length: " + classesFileList.length);
            }
            if (classesFileList != null && classesFileList.length > 0) {
                cp.append(dir + File.pathSeparator);
                for (int i = 0; i < classesFileList.length; ++i) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "classesFileList[i]: " + classesFileList[i]);
                    if (!classesFileList[i].endsWith(".jar") && !classesFileList[i].endsWith(".zip")) continue;
                    cp.append(dir + File.separator + classesFileList[i] + File.pathSeparator);
                    logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "appended: " + dir + File.separator + classesFileList[i] + File.pathSeparator);
                }
            }
        }
        logger.logp(Level.FINE, CLASS_NAME, "loadClasspathFromDirectory", "returning cp: " + cp);
        return cp.toString();
    }

    private static String loadRequiredClasspath() {
        int i;
        StringBuffer cp = new StringBuffer();
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "enter loadRequiredClasspath() ");
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "About to load jars from BUNDLES: ");
        for (i = 0; i < Constants.STANDARD_REQUIRED_JSP_JARS.length; ++i) {
            logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "appending WAS_BUNDLES+Constants.STANDARD_REQUIRED_JSP_JARS[i]+File.pathSeparator: " + WAS_BUNDLES + Constants.STANDARD_REQUIRED_JSP_JARS[i] + File.pathSeparator);
            cp.append(WAS_BUNDLES + Constants.STANDARD_REQUIRED_JSP_JARS[i] + File.pathSeparator);
        }
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "About to load jars from LIB: ");
        for (i = 0; i < Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB.length; ++i) {
            logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "appending WAS_LIB+Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB[i]+File.pathSeparator: " + WAS_LIB + Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB[i] + File.pathSeparator);
            cp.append(WAS_LIB + Constants.STANDARD_REQUIRED_JSP_JARS_FROM_LIB[i] + File.pathSeparator);
        }
        logger.logp(Level.FINE, CLASS_NAME, "loadRequiredClasspath", "returning cp: " + cp);
        return cp.toString();
    }

    private String getPathsAsString(String[] paths) {
        StringBuffer cp = new StringBuffer();
        logger.logp(Level.FINE, CLASS_NAME, "getPathsAsString", "entering getPathsAsString");
        for (int i = 0; i < paths.length; ++i) {
            logger.logp(Level.FINE, CLASS_NAME, "getPathsAsString", "appending paths[i]: " + paths[i]);
            cp.append(paths[i]);
            if (i >= paths.length - 1) continue;
            cp.append(File.pathSeparator);
        }
        logger.logp(Level.FINE, CLASS_NAME, "getPathsAsString", "returning cp: " + cp);
        return cp.toString();
    }

    static {
        classesClasspath = JSPClassloaderContextImpl.loadClasspathFromDirectory(WAS_CLASSES);
        libExtClasspath = JSPClassloaderContextImpl.loadClasspathFromDirectory(WAS_LIB_EXT);
        requiredClasspath = JSPClassloaderContextImpl.loadRequiredClasspath();
    }
}

