/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tsx.tag;

import com.ibm.ws.jsp.tsx.tag.DefinedIndexManager;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class RepeatTag
extends BodyTagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 3257568395246778423L;
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tsx.tag.RepeatTag";
    private String index = "";
    private int start = 0;
    private int end = Integer.MAX_VALUE;
    private int currentIteration = 0;
    private StringBuffer internalBodyContent;
    private boolean breakTsxRepeatLoop = false;

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start > 0 ? start : 0;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end >= this.start ? end : Integer.MAX_VALUE;
    }

    public int doStartTag() throws JspException {
        Hashtable<String, Integer> repeatLookup;
        Stack<String> repeatStack;
        this.internalBodyContent = new StringBuffer();
        DefinedIndexManager indexMgr = (DefinedIndexManager)this.pageContext.getAttribute("TSXDefinedIndexManager", 1);
        if (indexMgr == null) {
            indexMgr = new DefinedIndexManager();
            this.pageContext.setAttribute("TSXDefinedIndexManager", indexMgr, 1);
        }
        if ((repeatStack = (Stack<String>)this.pageContext.getAttribute("TSXRepeatStack", 1)) == null) {
            repeatStack = new Stack<String>();
            this.pageContext.setAttribute("TSXRepeatStack", repeatStack, 1);
        }
        if ((repeatLookup = (Hashtable<String, Integer>)this.pageContext.getAttribute("TSXRepeatLookup", 1)) == null) {
            repeatLookup = new Hashtable<String, Integer>();
            this.pageContext.setAttribute("TSXRepeatLookup", repeatLookup, 1);
        }
        if (this.index == null || this.index.equals("")) {
            this.index = indexMgr.getNextIndex();
        } else {
            if (indexMgr.exists(this.index)) {
                throw new JspException("Index specified in <tsx:repeat> tag has already been defined. index =[" + this.index + "]");
            }
            indexMgr.addIndex(this.index);
        }
        if (this.start > 0) {
            this.currentIteration = this.start;
        }
        this.pageContext.setAttribute(this.index, new Integer(this.currentIteration));
        repeatStack.push(this.index);
        repeatLookup.put(this.index, new Integer(this.currentIteration++));
        if (this.end < 0) {
            this.end = Integer.MAX_VALUE;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        Hashtable repeatLookup = (Hashtable)this.pageContext.getAttribute("TSXRepeatLookup", 1);
        Boolean breakRepeat = (Boolean)this.pageContext.findAttribute("TSXBreakRepeat");
        if (this.breakTsxRepeatLoop || breakRepeat != null) {
            return 0;
        }
        BodyContent bodyContent = this.getBodyContent();
        String output = bodyContent.getString();
        this.internalBodyContent.append(output);
        try {
            bodyContent.clearBuffer();
        }
        catch (IOException io) {
            // empty catch block
        }
        if (this.currentIteration <= this.end) {
            this.pageContext.setAttribute(this.index, new Integer(this.currentIteration));
            repeatLookup.put(this.index, new Integer(this.currentIteration++));
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.doOutput(true);
        return 6;
    }

    private void doOutput(boolean writeToClient) throws JspException {
        DefinedIndexManager indexMgr;
        Stack repeatStack = (Stack)this.pageContext.getAttribute("TSXRepeatStack", 1);
        this.index = (String)repeatStack.pop();
        this.currentIteration = 0;
        if (writeToClient) {
            String output = this.internalBodyContent.toString();
            JspWriter out = this.pageContext.getOut();
            try {
                out.write(output);
            }
            catch (IOException io) {
                throw new JspException("Unable to write <tsx:repeat> tag output " + io.getMessage());
            }
            finally {
                this.pageContext.removeAttribute("TSXBreakRepeat", 2);
            }
        }
        if ((indexMgr = (DefinedIndexManager)this.pageContext.getAttribute("TSXDefinedIndexManager", 1)) != null) {
            indexMgr.removeIndex(this.index);
        }
        this.reset();
    }

    public void release() {
        super.release();
        this.reset();
    }

    public void doCatch(Throwable caughtException) throws Throwable {
        this.breakTsxRepeatLoop = true;
        if (caughtException instanceof ArrayIndexOutOfBoundsException || caughtException instanceof NoSuchElementException) {
            this.doOutput(true);
        } else {
            logger.logp(Level.SEVERE, CLASS_NAME, "doCatch", "Caught unexpected exception in tsx:repeat. breaking loop @[" + this.currentIteration + "]", caughtException);
            this.doOutput(false);
        }
    }

    public void doFinally() {
    }

    private void reset() {
        this.index = "";
        this.start = 0;
        this.end = Integer.MAX_VALUE;
        this.internalBodyContent = new StringBuffer();
        this.breakTsxRepeatLoop = false;
    }
}

