/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.tagfilescan;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagFileTagInfo;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

public class TagFileScanVisitor
extends JspVisitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "om.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanVisitor";
    private TagLibraryInfoImpl tli = null;
    private String tagFilePath = null;
    private String name = null;
    private String tagclass = null;
    private TagExtraInfo tei = null;
    private String bodycontent = "scriptless";
    private String description = null;
    private String displayName = null;
    private String smallIcon = null;
    private String largeIcon = null;
    private String dynamicAttributes = null;
    private boolean bodyContentIsDefault = true;
    private ArrayList attributes = new ArrayList();
    private ArrayList variables = new ArrayList();
    private HashMap tagFileUniqueNameGivenVariableNames = new HashMap(19);
    private HashMap tagFileUniqueNameFromAttributeVariableNames = new HashMap(19);

    public TagFileScanVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        this.displayName = this.name = (String)inputMap.get("TagFileName");
        this.tli = (TagLibraryInfoImpl)inputMap.get("TagLibraryInfo");
        this.tagFilePath = (String)inputMap.get("TagFilePath");
        String className = this.tagFilePath.substring(this.tagFilePath.lastIndexOf(47) + 1);
        className = className.substring(0, className.indexOf(".tag"));
        className = NameMangler.mangleClassName(className);
        String dirName = this.tagFilePath.substring(0, this.tagFilePath.lastIndexOf(47));
        if (dirName.startsWith("/WEB-INF/tags")) {
            dirName = dirName.substring(dirName.indexOf("/WEB-INF/tags") + 13);
        } else if (dirName.startsWith("/META-INF/tags")) {
            dirName = dirName.substring(dirName.indexOf("/META-INF/tags") + 14);
        }
        dirName = dirName.replace('/', '.');
        this.tagclass = "com.ibm.ws.jsp.tagfile." + this.tli.getOriginatorId() + dirName + "." + className;
    }

    public JspVisitorResult getResult() throws JspCoreException {
        for (String nameFrom : this.tagFileUniqueNameFromAttributeVariableNames.keySet()) {
            Element nameEntry = (Element)this.tagFileUniqueNameGivenVariableNames.get(nameFrom);
            Element nameFromEntry = (Element)this.tagFileUniqueNameFromAttributeVariableNames.get(nameFrom);
            if (nameEntry == null) {
                throw new JspTranslationException(nameFromEntry, "jsp.error.tagfile.nameFrom.noAttribute", new Object[]{nameFrom});
            }
            Attr typeAttr = nameEntry.getAttributeNode("type");
            String type = "java.lang.String";
            if (typeAttr != null) {
                type = typeAttr.getValue();
            }
            Attr requiredAttr = nameEntry.getAttributeNode("required");
            boolean required = false;
            if (requiredAttr != null) {
                required = JspTranslatorUtil.booleanValue(requiredAttr.getValue());
            }
            Attr rtexprvalueAttr = nameEntry.getAttributeNode("rtexprvalue");
            boolean rtexprvalue = true;
            if (rtexprvalueAttr != null) {
                rtexprvalue = JspTranslatorUtil.booleanValue(rtexprvalueAttr.getValue());
            }
            if ("java.lang.String".equals(type) && required && !rtexprvalue) continue;
            String jspIdString = nameEntry.getAttributeNS("http://java.sun.com/JSP/Page", "id");
            JspId jspId = null;
            String lineNum = "unknown";
            if (!jspIdString.equals("")) {
                jspId = new JspId(jspIdString);
                lineNum = String.valueOf(jspId.getStartSourceLineNum());
            }
            throw new JspTranslationException(nameFromEntry, "jsp.error.tagfile.nameFrom.badAttribute", new Object[]{lineNum, nameFrom});
        }
        TagVariableInfo[] tagVariableInfos = new TagVariableInfo[this.variables.size()];
        tagVariableInfos = this.variables.toArray(tagVariableInfos);
        TagAttributeInfo[] tagAttributeInfo = new TagAttributeInfo[this.attributes.size()];
        tagAttributeInfo = this.attributes.toArray(tagAttributeInfo);
        TagFileTagInfo ti = new TagFileTagInfo(this.name, this.tagclass, this.bodycontent, this.description, (TagLibraryInfo)this.tli, this.tei, tagAttributeInfo, this.displayName, this.smallIcon, this.largeIcon, tagVariableInfos, this.dynamicAttributes);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getResult", "About to call setTagInfo(ti), ti =[\n" + ti + "]");
        }
        TagFileScanResult result = new TagFileScanResult(this.visitorUsage.getJspVisitorDefinition().getId());
        result.setTagInfo(ti);
        return result;
    }

    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
        if (this.bodyContentIsDefault) {
            String newbodycontent = this.checkConflict(jspElement, null, "body-content");
            if (newbodycontent != null) {
                this.bodycontent = newbodycontent;
                this.bodyContentIsDefault = false;
            }
        } else {
            this.bodycontent = this.checkConflict(jspElement, this.bodycontent, "body-content");
        }
        if (this.bodycontent != null && this.jspConfiguration.getServletVersion().equals("2.5") && !this.bodycontent.equalsIgnoreCase("empty") && !this.bodycontent.equalsIgnoreCase("tagdependent") && !this.bodycontent.equalsIgnoreCase("scriptless")) {
            throw new JspTranslationException(jspElement, "jsp.error.tagdirective.badbodycontent", new Object[]{this.bodycontent});
        }
        this.displayName = this.checkConflict(jspElement, this.displayName, "display-name");
        this.dynamicAttributes = this.checkConflict(jspElement, this.dynamicAttributes, "dynamic-attributes");
        this.smallIcon = this.checkConflict(jspElement, this.smallIcon, "small-icon");
        this.largeIcon = this.checkConflict(jspElement, this.largeIcon, "large-icon");
        this.description = this.checkConflict(jspElement, this.description, "description");
    }

    private String checkConflict(Element elem, String oldAttrValue, String attr) throws JspCoreException {
        String result = oldAttrValue;
        String attrValue = null;
        if (elem.getAttributeNode(attr) != null) {
            attrValue = elem.getAttributeNode(attr).getValue();
        }
        if (attrValue != null) {
            if (oldAttrValue != null && !oldAttrValue.equals(attrValue)) {
                throw new JspTranslationException(elem, "jsp.error.tag.conflict.attr", new Object[]{attr, oldAttrValue, attrValue});
            }
            result = attrValue;
        }
        return result;
    }

    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
        Attr nameAttr = jspElement.getAttributeNode("name");
        Attr requiredAttr = jspElement.getAttributeNode("required");
        Attr fragmentAttr = jspElement.getAttributeNode("fragment");
        Attr rtexprvalueAttr = jspElement.getAttributeNode("rtexprvalue");
        Attr typeAttr = jspElement.getAttributeNode("type");
        Attr deferredValueAttr = jspElement.getAttributeNode("deferredValue");
        Attr deferredValueTypeAttr = jspElement.getAttributeNode("deferredValueType");
        Attr deferredMethodAttr = jspElement.getAttributeNode("deferredMethod");
        Attr deferredMethodSignatureAttr = jspElement.getAttributeNode("deferredMethodSignature");
        String name = "";
        boolean required = false;
        boolean fragment = false;
        boolean rtexprvalue = true;
        String type = null;
        boolean deferredValue = false;
        boolean deferredValueSpecified = false;
        String deferredValueString = null;
        if (deferredValueAttr != null) {
            deferredValueString = deferredValueAttr.getValue();
        }
        if (deferredValueString != null) {
            deferredValueSpecified = true;
            deferredValue = JspTranslatorUtil.booleanValue(deferredValueString);
        }
        String deferredValueType = null;
        if (deferredValueTypeAttr != null) {
            deferredValueType = deferredValueTypeAttr.getValue();
        }
        if (deferredValueType != null) {
            if (deferredValueSpecified && !deferredValue) {
                throw new JspTranslationException(jspElement, "jsp.error.deferredvaluetypewithoutdeferredvalue");
            }
            deferredValue = true;
        } else {
            deferredValueType = deferredValue ? "java.lang.Object" : "java.lang.String";
        }
        boolean deferredMethod = false;
        boolean deferredMethodSpecified = false;
        String deferredMethodString = null;
        if (deferredMethodAttr != null) {
            deferredMethodString = deferredMethodAttr.getValue();
        }
        if (deferredMethodString != null) {
            deferredMethodSpecified = true;
            deferredMethod = JspTranslatorUtil.booleanValue(deferredMethodString);
        }
        String deferredMethodSignature = null;
        if (deferredMethodSignatureAttr != null) {
            deferredMethodSignature = deferredMethodSignatureAttr.getValue();
        }
        if (deferredMethodSignature != null) {
            if (deferredMethodSpecified && !deferredMethod) {
                throw new JspTranslationException(jspElement, "jsp.error.deferredmethodsignaturewithoutdeferredmethod");
            }
            deferredMethod = true;
        } else if (deferredMethod) {
            deferredMethodSignature = "void methodname()";
        }
        if (deferredMethod && deferredValue) {
            throw new JspTranslationException(jspElement, "jsp.error.deferredmethodandvalue");
        }
        if (nameAttr != null) {
            name = nameAttr.getValue();
        }
        if (requiredAttr != null) {
            required = JspTranslatorUtil.booleanValue(requiredAttr.getValue());
        }
        if (fragmentAttr != null) {
            fragment = JspTranslatorUtil.booleanValue(fragmentAttr.getValue());
        }
        if (typeAttr != null) {
            type = typeAttr.getValue();
        }
        if (rtexprvalueAttr != null) {
            rtexprvalue = JspTranslatorUtil.booleanValue(rtexprvalueAttr.getValue());
        }
        if (fragment) {
            if (type != null) {
                throw new JspTranslationException(jspElement, "jsp.error.illegal.fragment.and.type", new Object[]{typeAttr.getValue()});
            }
            rtexprvalue = true;
            if (rtexprvalueAttr != null) {
                throw new JspTranslationException(jspElement, "jsp.error.illegal.fragment.and.rtexprvalue", new Object[]{rtexprvalueAttr.getValue()});
            }
        } else {
            if (type == null) {
                type = "java.lang.String";
            } else {
                try {
                    if (this.isPrimitive(type)) {
                        throw new JspTranslationException(jspElement, "jsp.error.illegal.type.primitive", new Object[]{type});
                    }
                    Class<?> typeAttrClass = Class.forName(type, true, this.context.getJspClassloaderContext().getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new JspTranslationException(jspElement, "jsp.error.tagfile.cannot.locate.class.to.validate.primitive", new Object[]{type}, cnfe);
                }
            }
            if (deferredValue) {
                type = ValueExpression.class.getName();
            } else if (deferredMethod) {
                type = MethodExpression.class.getName();
            }
        }
        if (("2.0".equals(this.tli.getRequiredVersion()) || "1.2".equals(this.tli.getRequiredVersion())) && (deferredMethodSpecified || deferredMethod || deferredValueSpecified || deferredValue)) {
            throw new JspTranslationException(jspElement, "jsp.error.invalid.version", new Object[]{this.tagFilePath});
        }
        TagAttributeInfo tai = new TagAttributeInfo(name, required, type, rtexprvalue, fragment, null, deferredValue, deferredMethod, deferredValueType, deferredMethodSignature);
        this.attributes.add(tai);
        this.checkValidTagName(jspElement, this.tagFileUniqueNameGivenVariableNames, name);
    }

    private boolean isPrimitive(String classType) {
        classType = classType.trim();
        boolean primitive = false;
        String[] primitiveList = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
        for (int i = 0; i < primitiveList.length; ++i) {
            if (!classType.equals(primitiveList[i])) continue;
            return true;
        }
        return primitive;
    }

    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
        Attr nameGivenAttr = jspElement.getAttributeNode("name-given");
        Attr nameFromAttributeAttr = jspElement.getAttributeNode("name-from-attribute");
        Attr aliasAttr = jspElement.getAttributeNode("alias");
        Attr variableClassAttr = jspElement.getAttributeNode("variable-class");
        Attr declareAttr = jspElement.getAttributeNode("declare");
        Attr scopeAttr = jspElement.getAttributeNode("scope");
        String nameGiven = null;
        String nameFromAttribute = null;
        String variableClass = "java.lang.String";
        boolean declare = true;
        int scope = 0;
        if (nameGivenAttr != null) {
            nameGiven = nameGivenAttr.getValue();
        }
        if (nameFromAttributeAttr != null) {
            nameFromAttribute = nameFromAttributeAttr.getValue();
        }
        if (nameGivenAttr != null && nameFromAttributeAttr != null) {
            throw new JspTranslationException(jspElement, "variable.attribute.nameGiven.nameFromAttribute.not.both", new Object[]{jspElement.getTagName(), nameGiven, nameFromAttribute});
        }
        if (nameGivenAttr == null && nameFromAttributeAttr == null) {
            throw new JspTranslationException(jspElement, "missing.required.variable.attribute.nameGiven.nameFromAttribute", new Object[]{jspElement.getTagName()});
        }
        if (nameFromAttributeAttr != null && aliasAttr == null) {
            throw new JspTranslationException(jspElement, "required.attribute.alias.required.if.nameFromAttribute.specified", new Object[]{jspElement.getTagName(), nameFromAttribute});
        }
        if (nameGivenAttr != null && aliasAttr != null) {
            throw new JspTranslationException(jspElement, "attribute.alias.not.permitted.if.namegiven.specified", new Object[]{jspElement.getTagName(), nameGiven, aliasAttr.getValue()});
        }
        if (variableClassAttr != null) {
            variableClass = variableClassAttr.getValue();
        }
        if (declareAttr != null) {
            declare = JspTranslatorUtil.booleanValue(declareAttr.getValue());
        }
        if (scopeAttr != null) {
            scope = this.convertScopeToInt(jspElement, scopeAttr.getValue());
        }
        if (aliasAttr != null) {
            nameGiven = aliasAttr.getValue();
        }
        TagVariableInfo tvi = new TagVariableInfo(nameGiven, nameFromAttribute, variableClass, declare, scope);
        this.variables.add(tvi);
        if (nameGivenAttr != null) {
            this.checkValidTagName(jspElement, this.tagFileUniqueNameGivenVariableNames, nameGiven);
        } else {
            this.checkValidTagName(jspElement, this.tagFileUniqueNameFromAttributeVariableNames, nameFromAttribute);
            this.checkValidTagName(jspElement, this.tagFileUniqueNameGivenVariableNames, aliasAttr.getValue());
        }
    }

    protected void checkValidTagName(Element jspElement, HashMap map, String name) throws JspCoreException {
        Element priorElementObj = map.put(name, jspElement);
        if (priorElementObj != null) {
            Element priorElement = priorElementObj;
            throw new JspTranslationException(jspElement, "multiple.occurences.attribute.tagfile.name", new Object[]{jspElement.getTagName(), priorElement.getTagName(), name});
        }
    }

    protected int convertScopeToInt(Element jspElement, String scope) throws JspCoreException {
        if (scope.equals("AT_BEGIN")) {
            return 1;
        }
        if (scope.equals("NESTED")) {
            return 0;
        }
        if (scope.equals("AT_END")) {
            return 2;
        }
        throw new JspTranslationException(jspElement, "invalid.value.for.variable.directive.attribute.scope", new Object[]{jspElement.getTagName(), scope});
    }

    protected void visitJspRootStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspRootEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspTextStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspTextEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitIncludeDirectiveStart(Element jspElement) throws JspCoreException {
    }

    protected void visitIncludeDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitPageDirectiveStart(Element jspElement) throws JspCoreException {
    }

    protected void visitPageDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitTagDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitAttributeDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitVariableDirectiveEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspDeclarationStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspDeclarationEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspExpressionStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspExpressionEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspScriptletStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspScriptletEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspParamStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspParamEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspParamsStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspParamsEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspFallbackStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspFallbackEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspIncludeStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspIncludeEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspForwardStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspForwardEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspUseBeanStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspUseBeanEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspGetPropertyStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspGetPropertyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspSetPropertyStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspSetPropertyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspPluginStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspPluginEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitCustomTagStart(Element jspElement) throws JspCoreException {
    }

    protected void visitCustomTagEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspAttributeStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspAttributeEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspElementStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspElementEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspBodyStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspBodyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspInvokeStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspInvokeEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspDoBodyStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspDoBodyEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitJspOutputStart(Element jspElement) throws JspCoreException {
    }

    protected void visitJspOutputEnd(Element jspElement) throws JspCoreException {
    }

    protected void visitUninterpretedTagStart(Element jspElement) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "visitUninterpretedTagStart", "jspElement =[" + jspElement + "]");
        }
    }

    protected void visitUninterpretedTagEnd(Element jspElement) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "visitUninterpretedTagEnd", "jspElement =[" + jspElement + "]");
        }
    }

    protected void visitCDataTag(CDATASection cdata) throws JspCoreException {
    }
}

