/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.utils.FunctionSignature;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import org.w3c.dom.Element;

public class GeneratorUtils {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils";
    public static String classfileVersion = "unknown";
    public static String fullClassfileInformation = "unknown";
    public static int TAG_FILE_TYPE = 1;
    public static int JSP_FILE_TYPE = 2;

    public static String quote(String s) {
        if (s == null) {
            return "null";
        }
        return '\"' + GeneratorUtils.escape(s) + '\"';
    }

    public static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                b.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\').append('r');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toGetterMethod(String attrName) {
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        return "get" + new String(attrChars) + "()";
    }

    public static String toSetterMethodName(String attrName) {
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        return "set" + new String(attrChars);
    }

    public static void generateLocalVariables(JavaCodeWriter out, Element jspElement) throws JspCoreException {
        if (GeneratorUtils.hasUseBean(jspElement)) {
            out.println("HttpSession session = pageContext.getSession();");
            out.println("ServletContext application = pageContext.getServletContext();");
        }
        if (GeneratorUtils.hasUseBean(jspElement) || GeneratorUtils.hasIncludeAction(jspElement) || GeneratorUtils.hasSetProperty(jspElement) || GeneratorUtils.hasForwardAction(jspElement)) {
            out.println("HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();");
        }
        if (GeneratorUtils.hasIncludeAction(jspElement)) {
            out.println("HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();");
        }
    }

    private static boolean hasUseBean(Element jspElement) {
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "useBean").getLength() > 0) {
            b = true;
        }
        return b;
    }

    private static boolean hasIncludeAction(Element jspElement) {
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "include").getLength() > 0) {
            b = true;
        }
        return b;
    }

    private static boolean hasForwardAction(Element jspElement) {
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "forward").getLength() > 0) {
            b = true;
        }
        return b;
    }

    private static boolean hasSetProperty(Element jspElement) {
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "setProperty").getLength() > 0) {
            b = true;
        }
        return b;
    }

    public static boolean isDeferredInput(TagAttributeInfo tai) {
        return tai != null ? tai.isDeferredValue() : false;
    }

    public static boolean isDeferredMethodInput(TagAttributeInfo tai) {
        return tai != null ? tai.isDeferredMethod() : false;
    }

    public static String getTargetType(Class expectedType) {
        String targetType = expectedType.getName();
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                targetType = Boolean.class.getName();
            } else if (expectedType.equals(Byte.TYPE)) {
                targetType = Byte.class.getName();
            } else if (expectedType.equals(Character.TYPE)) {
                targetType = Character.class.getName();
            } else if (expectedType.equals(Short.TYPE)) {
                targetType = Short.class.getName();
            } else if (expectedType.equals(Integer.TYPE)) {
                targetType = Integer.class.getName();
            } else if (expectedType.equals(Long.TYPE)) {
                targetType = Long.class.getName();
            } else if (expectedType.equals(Float.TYPE)) {
                targetType = Float.class.getName();
            } else if (expectedType.equals(Double.TYPE)) {
                targetType = Double.class.getName();
            }
        }
        targetType = GeneratorUtils.toJavaSourceType(targetType);
        return targetType;
    }

    public static String getPrimitiveConverterMethod(Class expectedType) {
        String primitiveConverterMethod = null;
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                primitiveConverterMethod = "booleanValue";
            } else if (expectedType.equals(Byte.TYPE)) {
                primitiveConverterMethod = "byteValue";
            } else if (expectedType.equals(Character.TYPE)) {
                primitiveConverterMethod = "charValue";
            } else if (expectedType.equals(Short.TYPE)) {
                primitiveConverterMethod = "shortValue";
            } else if (expectedType.equals(Integer.TYPE)) {
                primitiveConverterMethod = "intValue";
            } else if (expectedType.equals(Long.TYPE)) {
                primitiveConverterMethod = "longValue";
            } else if (expectedType.equals(Float.TYPE)) {
                primitiveConverterMethod = "floatValue";
            } else if (expectedType.equals(Double.TYPE)) {
                primitiveConverterMethod = "doubleValue";
            }
        }
        return primitiveConverterMethod;
    }

    public static String interpreterCall(boolean isTagFile, String expression, Class expectedType, String fnmapvar, boolean XmlEscape) {
        String jspCtxt = null;
        jspCtxt = isTagFile ? "getJspContext()" : "pageContext";
        String targetType = GeneratorUtils.getTargetType(expectedType);
        String primitiveConverterMethod = GeneratorUtils.getPrimitiveConverterMethod(expectedType);
        if (primitiveConverterMethod != null) {
            XmlEscape = false;
        }
        StringBuffer call = new StringBuffer("(" + targetType + ") " + "org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate" + "(" + GeneratorUtils.quote(expression) + ", " + targetType + ".class, " + "(PageContext)" + jspCtxt + ", " + fnmapvar + ", " + XmlEscape + ")");
        if (primitiveConverterMethod != null) {
            call.insert(0, "(");
            call.append(")." + primitiveConverterMethod + "()");
        }
        return call.toString();
    }

    public static String createValueExpression(StringBuffer sb, String mark, String elContext, String attrValue, boolean isELinput, Class c, TagAttributeInfo tai, String jspCtxt) {
        sb.append("new org.apache.jasper.el.JspValueExpression(");
        sb.append(GeneratorUtils.quote(mark));
        sb.append(',');
        sb.append("_el_expressionfactory");
        sb.append(".createValueExpression(");
        sb.append(elContext);
        sb.append(',');
        sb.append(GeneratorUtils.quote(attrValue));
        sb.append(',');
        sb.append(GeneratorUtils.toJavaSourceTypeFromTld(GeneratorUtils.getExpectedTypeName(tai)));
        sb.append("))");
        boolean evaluate = false;
        if (tai.canBeRequestTime()) {
            evaluate = true;
        }
        if (GeneratorUtils.isDeferredInput(tai)) {
            evaluate = false;
        }
        if (GeneratorUtils.isDeferredInput(tai) && tai.canBeRequestTime()) {
            boolean bl = evaluate = !attrValue.contains("#{");
        }
        if (evaluate) {
            sb.append(".getValue(");
            sb.append(jspCtxt);
            sb.append(".getELContext()");
            sb.append(")");
        }
        attrValue = sb.toString();
        return sb.toString();
    }

    public static String createMethodExpression(StringBuffer sb, String mark, String elContext, String attrValue, boolean isELinput, Class c, TagAttributeInfo tai, String jspCtxt) {
        sb.append("new org.apache.jasper.el.JspMethodExpression(");
        sb.append(GeneratorUtils.quote(mark));
        sb.append(',');
        sb.append("_el_expressionfactory");
        sb.append(".createMethodExpression(");
        sb.append(elContext);
        sb.append(',');
        sb.append(GeneratorUtils.quote(attrValue));
        sb.append(',');
        sb.append(GeneratorUtils.toJavaSourceTypeFromTld(GeneratorUtils.getExpectedTypeName(tai)));
        sb.append(',');
        sb.append("new Class[] {");
        String[] p = GeneratorUtils.getParameterTypeNames(tai);
        for (int i = 0; i < p.length; ++i) {
            sb.append(GeneratorUtils.toJavaSourceTypeFromTld(p[i]));
            sb.append(',');
        }
        if (p.length > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}))");
        attrValue = sb.toString();
        return sb.toString();
    }

    public static String toJavaSourceTypeFromTld(String type) {
        if (type == null || "void".equals(type)) {
            return "Void.TYPE";
        }
        return type + ".class";
    }

    public static String[] getParameterTypeNames(TagAttributeInfo tai) {
        String m;
        if (tai != null && GeneratorUtils.isDeferredMethodInput(tai) && (m = tai.getMethodSignature()) != null) {
            m = m.trim();
            m = m.substring(m.indexOf(40) + 1);
            if ((m = m.substring(0, m.length() - 1)).trim().length() > 0) {
                String[] p = m.split(",");
                for (int i = 0; i < p.length; ++i) {
                    p[i] = p[i].trim();
                }
                return p;
            }
        }
        return new String[0];
    }

    public static String getExpectedTypeName(TagAttributeInfo tai) {
        if (tai != null) {
            int rti;
            String m;
            if (GeneratorUtils.isDeferredInput(tai)) {
                return tai.getExpectedTypeName();
            }
            if (GeneratorUtils.isDeferredMethodInput(tai) && (m = tai.getMethodSignature()) != null && (rti = m.trim().indexOf(32)) > 0) {
                return m.substring(0, rti).trim();
            }
        }
        return "java.lang.Object";
    }

    public static String nextTemporaryVariableName(Map persistentData) {
        String nextTempVar = "_jspx_temp";
        Integer tempVarIndex = (Integer)persistentData.get("tempVarIndex");
        if (tempVarIndex == null) {
            tempVarIndex = new Integer(0);
        }
        int val = tempVarIndex;
        tempVarIndex = new Integer(++val);
        nextTempVar = nextTempVar + tempVarIndex;
        persistentData.put("tempVarIndex", tempVarIndex);
        return nextTempVar;
    }

    public static String attributeValue(String valueIn, boolean encode, Class expectedType, JspConfiguration jspConfig, boolean isTagFile) {
        String value = valueIn;
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("<\\%", "<%");
        value = value.replaceAll("%\\>", "%>");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "valueIn = [" + valueIn + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "encode = [" + encode + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "expectedType = [" + expectedType + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isTagFile = [" + isTagFile + "]");
        }
        if (JspTranslatorUtil.isExpression(value)) {
            value = value.substring(2, value.length() - 1);
            if (encode) {
                value = "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(String.valueOf(" + value + "), request.getCharacterEncoding())";
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isExpression. value = [" + value + "]");
            }
        } else if (JspTranslatorUtil.isELInterpreterInput(value, jspConfig)) {
            value = encode ? "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + GeneratorUtils.interpreterCall(isTagFile, value, expectedType, "_jspx_fnmap", false) + ", request.getCharacterEncoding())" : GeneratorUtils.interpreterCall(isTagFile, value, expectedType, "_jspx_fnmap", false);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isELInterpreterInput. value = [" + value + "]");
            }
        } else {
            value = encode ? "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + GeneratorUtils.quote(value) + ", request.getCharacterEncoding())" : GeneratorUtils.quote(value);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "default. value = [" + value + "]");
            }
        }
        return value;
    }

    public static String replace(String name, char replace, String with) {
        StringBuffer buf = new StringBuffer();
        int begin = 0;
        int last = name.length();
        while (true) {
            int end;
            if ((end = name.indexOf(replace, begin)) < 0) {
                end = last;
            }
            buf.append(name.substring(begin, end));
            if (end == last) break;
            buf.append(with);
            begin = end + 1;
        }
        return buf.toString();
    }

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%' && chars[i + 1] == '\\' && chars[i + 2] == '>') {
                caw.write(37);
                caw.write(62);
                i += 3;
                continue;
            }
            caw.write(chars[i]);
        }
        return caw.toCharArray();
    }

    public static char[] escapeQuotes(char[] chars) {
        char[] c = GeneratorUtils.escapeScriptingStart(chars);
        c = GeneratorUtils.escapeScriptingEnd(c);
        return c;
    }

    private static char[] escapeScriptingStart(char[] chars) {
        int n;
        String s = new String(chars);
        while ((n = s.indexOf("<\\%")) >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, n));
            sb.append("<%");
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        chars = s.toCharArray();
        return chars;
    }

    private static char[] escapeScriptingEnd(char[] chars) {
        int n;
        String s = new String(chars);
        while ((n = s.indexOf("%\\>")) >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, n));
            sb.append("%>");
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        chars = s.toCharArray();
        return chars;
    }

    public static void generateELFunctionCode(JavaCodeWriter writer, ValidateResult validatorResult) throws JspCoreException {
        writer.println("private static org.apache.jasper.runtime.ProtectedFunctionMapper _jspx_fnmap = null;");
        if (validatorResult.getValidateFunctionMapper().getFnMap().size() > 0) {
            writer.println();
            writer.println("static {");
            writer.println("_jspx_fnmap = org.apache.jasper.runtime.ProtectedFunctionMapper.getInstance();");
            for (String fnQName : validatorResult.getValidateFunctionMapper().getFnMap().keySet()) {
                String fnPrefix = fnQName.substring(0, fnQName.indexOf(58));
                String fnName = fnQName.substring(fnQName.indexOf(58) + 1);
                writer.print("_jspx_fnmap.mapFunction(");
                writer.print(GeneratorUtils.quote(fnPrefix));
                writer.print(", ");
                writer.print(GeneratorUtils.quote(fnName));
                writer.print(", ");
                FunctionSignature functionSignature = validatorResult.getValidateFunctionMapper().getSignature(fnQName);
                writer.print(functionSignature.getFunctionClassName() + ".class, ");
                writer.print(GeneratorUtils.quote(functionSignature.getMethodName()));
                writer.print(", ");
                Class[] args = functionSignature.getParameterTypes();
                if (args != null) {
                    writer.print("new Class[] {");
                    for (int j = 0; j < args.length; ++j) {
                        if (args[j].isArray()) {
                            writer.print("java.lang.reflect.Array.newInstance(" + args[j].getComponentType().getName() + ".class, 0).getClass()");
                        } else {
                            writer.print(args[j].getName() + ".class");
                        }
                        if (j >= args.length - 1) continue;
                        writer.print(", ");
                    }
                    writer.print("} ");
                } else {
                    writer.print("null");
                }
                writer.print(");");
                writer.println();
            }
            writer.println("}");
            writer.println();
        }
    }

    public static void generateDependencyList(JavaCodeWriter writer, ValidateResult validatorResult, JspCoreContext context, boolean isTrackDependencies) {
        writer.println("private static String[] _jspx_dependants;");
        if (validatorResult.getDependencyList().size() > 0 || isTrackDependencies) {
            writer.println("static {");
            writer.print("_jspx_dependants = new String[");
            if (validatorResult.getDependencyList().size() > 0) {
                writer.print("" + validatorResult.getDependencyList().size());
            } else {
                writer.print("0");
            }
            writer.print("];");
            writer.println();
            int count = 0;
            String dependencyName = null;
            String dependencyFullName = null;
            File dependencyFile = null;
            Iterator itr = validatorResult.getDependencyList().iterator();
            while (itr.hasNext()) {
                writer.print("_jspx_dependants[" + count++ + "] = \"");
                dependencyName = (String)itr.next();
                dependencyFullName = context.getRealPath(dependencyName);
                dependencyFile = new File(dependencyFullName);
                writer.print(dependencyName + "^" + dependencyFile.lastModified() + "^" + new Date(dependencyFile.lastModified()).toString());
                writer.print("\";");
                writer.println();
            }
            writer.println("}");
            writer.println();
        }
        writer.println("public String[] getDependants() {");
        writer.println("return _jspx_dependants;");
        writer.println("}");
    }

    public static void generateVersionInformation(JavaCodeWriter writer, boolean isDebugClassFile) {
        writer.println("private static String _jspx_classVersion;");
        writer.println("private static boolean _jspx_isDebugClassFile;");
        writer.println("static {");
        writer.print("_jspx_classVersion = new String(");
        writer.print("\"" + classfileVersion);
        writer.print("\");");
        writer.println();
        writer.print("_jspx_isDebugClassFile = ");
        writer.print("" + isDebugClassFile);
        writer.print(";");
        writer.println();
        writer.println("}");
        writer.println();
        writer.println("public String getVersionInformation() {");
        writer.println("return _jspx_classVersion;");
        writer.println("}");
        writer.println("public boolean isDebugClassFile() {");
        writer.println("return _jspx_isDebugClassFile;");
        writer.println("}");
    }

    public static String coerceToPrimitiveBoolean(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToBoolean(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "false";
        }
        return Boolean.valueOf(s).toString();
    }

    public static String coerceToBoolean(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Boolean) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Boolean.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Boolean(false)";
        }
        return "new Boolean(" + Boolean.valueOf(s).toString() + ")";
    }

    public static String coerceToPrimitiveByte(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToByte(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(byte) 0";
        }
        return "((byte)" + Byte.valueOf(s).toString() + ")";
    }

    public static String coerceToByte(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Byte) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Byte.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Byte((byte) 0)";
        }
        return "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
    }

    public static String coerceToChar(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToChar(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(char) 0";
        }
        char ch = s.charAt(0);
        return "((char) " + ch + ")";
    }

    public static String coerceToCharacter(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Character) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Character.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Character((char) 0)";
        }
        char ch = s.charAt(0);
        return "new Character((char) " + ch + ")";
    }

    public static String coerceToPrimitiveDouble(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToDouble(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(double) 0";
        }
        return Double.valueOf(s).toString();
    }

    public static String coerceToDouble(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Double) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Double.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Double(0)";
        }
        return "new Double(" + Double.valueOf(s).toString() + ")";
    }

    public static String coerceToPrimitiveFloat(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToFloat(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(float) 0";
        }
        return Float.valueOf(s).toString() + "f";
    }

    public static String coerceToFloat(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Float) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Float.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Float(0)";
        }
        return "new Float(" + Float.valueOf(s).toString() + "f)";
    }

    public static String coerceToInt(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToInt(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "0";
        }
        return Integer.valueOf(s).toString();
    }

    public static String coerceToInteger(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Integer) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Integer.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Integer(0)";
        }
        return "new Integer(" + Integer.valueOf(s).toString() + ")";
    }

    public static String coerceToPrimitiveShort(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToShort(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(short) 0";
        }
        return "((short) " + Short.valueOf(s).toString() + ")";
    }

    public static String coerceToShort(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Short) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Short.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Short((short) 0)";
        }
        return "new Short(\"" + Short.valueOf(s).toString() + "\")";
    }

    public static String coerceToPrimitiveLong(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToLong(" + s + ")";
        }
        if (s == null || s.length() == 0) {
            return "(long) 0";
        }
        return Long.valueOf(s).toString() + "l";
    }

    public static String coerceToLong(String s, boolean isNamedAttribute) {
        if (isNamedAttribute) {
            return "(Long) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Long.class)";
        }
        if (s == null || s.length() == 0) {
            return "new Long(0)";
        }
        return "new Long(" + Long.valueOf(s).toString() + "l)";
    }

    public static String toJavaSourceType(String type) {
        if (type.charAt(0) != '[') {
            return type;
        }
        int dims = 1;
        String t = null;
        for (int i = 1; i < type.length(); ++i) {
            if (type.charAt(i) == '[') {
                ++dims;
                continue;
            }
            switch (type.charAt(i)) {
                case 'Z': {
                    t = "boolean";
                    break;
                }
                case 'B': {
                    t = "byte";
                    break;
                }
                case 'C': {
                    t = "char";
                    break;
                }
                case 'D': {
                    t = "double";
                    break;
                }
                case 'F': {
                    t = "float";
                    break;
                }
                case 'I': {
                    t = "int";
                    break;
                }
                case 'J': {
                    t = "long";
                    break;
                }
                case 'S': {
                    t = "short";
                    break;
                }
                case 'L': {
                    t = type.substring(i + 1, type.indexOf(59));
                }
            }
            break;
        }
        StringBuffer resultType = new StringBuffer(t);
        while (dims > 0) {
            resultType.append("[]");
            --dims;
        }
        return resultType.toString();
    }

    public static void generateInitSectionCode(JavaCodeWriter writer, int type) {
        writer.println("private javax.el.ExpressionFactory _el_expressionfactory;");
        if (type == TAG_FILE_TYPE) {
            GeneratorUtils.generateInjectionSection(writer);
            writer.println("private void _jspInit(ServletConfig config) {");
        } else {
            writer.println("public void _jspInit() {");
        }
        writer.print("_el_expressionfactory");
        writer.print(" = _jspxFactory.getJspApplicationContext(");
        if (type == TAG_FILE_TYPE) {
            writer.print("config");
        } else {
            writer.print("getServletConfig()");
        }
        writer.print(".getServletContext()).getExpressionFactory();");
        writer.println();
        writer.println();
        writer.print("com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager _jspx_aHelper = ");
        writer.print("com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager.getInstance (");
        if (type == TAG_FILE_TYPE) {
            writer.print("config");
        } else {
            writer.print("getServletConfig()");
        }
        writer.println(".getServletContext());");
        writer.println("_jspx_iaHelper = _jspx_aHelper.getAnnotationHelper();");
        writer.println("}");
    }

    public static void generateFactoryInitialization(JavaCodeWriter writer) {
        writer.println("private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();");
    }

    public static void generateInjectionSection(JavaCodeWriter writer) {
        writer.println("private com.ibm.wsspi.webcontainer.annotation.AnnotationHelper _jspx_iaHelper;");
    }
}

