/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JspTranslationResult {
    private Map smapGeneratorMap = null;
    private Collection jspLineIds = new ArrayList();
    private List tagFileDependencyList = new ArrayList();
    private JspCompilerResult tagFileCompileResult = null;

    void addSmapGenerator(String resourceId, SmapGenerator smapGenerator) {
        if (this.smapGeneratorMap == null) {
            this.smapGeneratorMap = new HashMap();
        }
        this.smapGeneratorMap.put(resourceId, smapGenerator);
    }

    public boolean hasSmap() {
        return this.smapGeneratorMap != null;
    }

    void addJspLineIds(JspResources jspResources, Document document) {
        JspTranslationResult.loadJspIdList(jspResources, document.getDocumentElement(), this.jspLineIds);
    }

    public Collection getJspLineIds() {
        return this.jspLineIds;
    }

    public SmapGenerator getSmapGenerator(String resourceId) {
        return (SmapGenerator)this.smapGeneratorMap.get(resourceId);
    }

    public List getTagFileDependencyList() {
        return this.tagFileDependencyList;
    }

    public JspCompilerResult getTagFileCompileResult() {
        return this.tagFileCompileResult;
    }

    public void setTagFileCompileResult(JspCompilerResult tagFileCompileResult) {
        this.tagFileCompileResult = tagFileCompileResult;
    }

    public static void loadJspIdList(JspResources jspResources, Element element, Collection jspLineIds) {
        Attr jspIdAttr = element.getAttributeNodeNS("http://java.sun.com/JSP/Page", "id");
        if (jspIdAttr != null) {
            JspId jspId = new JspId(jspIdAttr.getValue());
            JspLineId lineId = new JspLineId(jspId.getFilePath(), jspResources.getGeneratedSourceFile().getPath(), jspResources.getInputSource().getRelativeURL(), jspId.getStartSourceLineNum(), jspId.getStartSourceColNum(), jspId.getSourceLineCount(), jspId.getEndSourceLineNum(), jspId.getEndSourceColNum(), jspId.getStartGeneratedLineNum(), jspId.getStartGeneratedLineCount(), jspId.getEndGeneratedLineNum(), jspId.getEndGeneratedLineCount());
            jspLineIds.add(lineId);
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            Element childElement = (Element)n;
            JspTranslationResult.loadJspIdList(jspResources, childElement, jspLineIds);
        }
    }
}

