/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ws.jsp.JspCoreException;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class JspEncodingScanner {
    protected String pageEncoding = null;
    protected String charset = null;
    protected boolean jspRootFound = false;
    protected Reader jspReader = null;
    protected int charCount = 0;

    public JspEncodingScanner(Reader jspReader) {
        this.jspReader = jspReader;
    }

    public boolean scan() throws JspCoreException {
        boolean scanOk = true;
        try {
            this.jspReader.mark(8192);
            int character = 0;
            boolean endFound = false;
            boolean saveChars = false;
            StringBuffer chars = new StringBuffer();
            block14: while (!endFound) {
                character = this.readCharacter();
                if (this.charCount < 8191) {
                    switch (character) {
                        case -1: {
                            endFound = true;
                            continue block14;
                        }
                        case 60: {
                            int nextChar = this.readCharacter();
                            int nextNextChar = this.readCharacter();
                            if (nextChar == 37 && nextNextChar == 64) {
                                this.scanPageDirective();
                                if (this.pageEncoding == null) continue block14;
                                endFound = true;
                                continue block14;
                            }
                            if (nextChar == 37 && nextNextChar == 45) {
                                int nextNextNextChar = this.readCharacter();
                                if (nextNextNextChar == 45) {
                                    if (!this.ignoreComment()) continue block14;
                                    endFound = true;
                                    continue block14;
                                }
                                saveChars = true;
                                chars.append((char)character);
                                chars.append((char)nextChar);
                                chars.append((char)nextNextChar);
                                chars.append((char)nextNextNextChar);
                                continue block14;
                            }
                            saveChars = true;
                            chars.append((char)character);
                            chars.append((char)nextChar);
                            chars.append((char)nextNextChar);
                            continue block14;
                        }
                        case 62: {
                            if (!saveChars) break;
                            saveChars = false;
                            if (chars.toString().startsWith("<jsp:root")) {
                                this.jspRootFound = true;
                            }
                            chars.delete(0, chars.length());
                        }
                    }
                    if (!saveChars) continue;
                    chars.append((char)character);
                    continue;
                }
                endFound = true;
            }
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            try {
                this.jspReader.reset();
            }
            catch (IOException e) {
                scanOk = false;
            }
        }
        return scanOk;
    }

    public String getEncoding() {
        return this.pageEncoding != null ? this.pageEncoding : this.charset;
    }

    public boolean jspRootFound() {
        return this.jspRootFound;
    }

    protected void scanPageDirective() throws JspCoreException, IOException {
        boolean endFound = false;
        StringBuffer directive = new StringBuffer();
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        boolean inValue = false;
        boolean inDirective = true;
        int prev = 0;
        int character = 0;
        block9: while (!endFound) {
            prev = character;
            character = this.readCharacter();
            switch (character) {
                case -1: {
                    throw new JspCoreException("jsp.error.end.of.file.reached");
                }
                case 60: {
                    if (inValue) {
                        value.append("&lt;");
                        continue block9;
                    }
                    if (inDirective) {
                        throw new JspCoreException("jsp.error.invalid.jsp.syntax", new Object[]{directive.toString()});
                    }
                    throw new JspCoreException("jsp.error.invalid.jsp.syntax", new Object[]{name.toString()});
                }
                case 62: {
                    if (prev == 37) {
                        endFound = true;
                        continue block9;
                    }
                    if (inValue) {
                        value.append("&gt;");
                        continue block9;
                    }
                    if (inDirective) continue block9;
                    name.append("&gt;");
                    continue block9;
                }
                case 13: {
                    continue block9;
                }
                case 61: {
                    if (!inValue) continue block9;
                    value.append((char)character);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 32: {
                    if (inDirective && directive.toString().trim().length() > 0) {
                        inDirective = false;
                        continue block9;
                    }
                    if (!inValue) continue block9;
                    value.append((char)character);
                    continue block9;
                }
                case 34: 
                case 39: {
                    if (inValue) {
                        if (directive.toString().equals("page") || directive.toString().equals("tag")) {
                            if (name.toString().equals("pageEncoding")) {
                                this.pageEncoding = value.toString();
                            } else if (name.toString().equals("contentType") && value != null && value.indexOf(";") != -1) {
                                StringTokenizer st = new StringTokenizer(value.toString(), ";");
                                while (st.hasMoreTokens()) {
                                    String token = st.nextToken();
                                    if (token.indexOf("charset=") == -1) continue;
                                    this.charset = value.substring(value.indexOf("charset=") + 8).trim();
                                }
                            }
                        }
                        name.delete(0, name.length());
                        value.delete(0, value.length());
                        inValue = false;
                        continue block9;
                    }
                    inValue = true;
                    continue block9;
                }
            }
            if (inValue) {
                value.append((char)character);
                continue;
            }
            if (inDirective) {
                directive.append((char)character);
                continue;
            }
            name.append((char)character);
        }
    }

    private int readCharacter() throws IOException {
        int character = this.jspReader.read();
        ++this.charCount;
        return character;
    }

    private boolean ignoreComment() throws IOException {
        StringBuffer comment = new StringBuffer();
        int prev = 0;
        int character = 0;
        boolean endFound = false;
        boolean eofFound = false;
        while (!endFound) {
            prev = character;
            character = this.readCharacter();
            if (character != -1) {
                String fullComment;
                comment.append((char)character);
                if (character != 62 || prev != 37 || !(fullComment = comment.toString()).endsWith("--%>")) continue;
                endFound = true;
                continue;
            }
            endFound = true;
            eofFound = true;
        }
        return eofFound;
    }
}

