/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JspCompilerResultImpl;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JikesJspCompiler
implements JspCompiler {
    protected static Logger logger;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.JikesJspCompiler";
    private static String separatorString;
    protected JspClassloaderContext classloaderContext = null;
    protected JspOptions options = null;
    protected CharArrayWriter out = null;
    protected String fullClasspath = null;
    protected String optimizedClasspath = null;
    protected String sourcepath = null;
    protected boolean isClassDebugInfo = false;
    protected boolean isDebugEnabled = false;
    protected boolean isVerbose = false;
    protected boolean isDeprecation = false;
    protected String jdkSourceLevel = null;
    protected boolean useOptimizedClasspath = false;
    protected String absouluteContextRoot = null;

    public JikesJspCompiler(String absouluteContextRoot, JspClassloaderContext classloaderContext, JspOptions options, String optimizedClasspath, boolean useOptimizedClasspath) {
        this.absouluteContextRoot = absouluteContextRoot;
        this.classloaderContext = classloaderContext;
        this.optimizedClasspath = optimizedClasspath;
        this.options = options;
        this.useOptimizedClasspath = useOptimizedClasspath;
        this.sourcepath = options.getOutputDir().getPath();
        this.isClassDebugInfo = options.isClassDebugInfo();
        this.isDebugEnabled = options.isDebugEnabled();
        this.isVerbose = options.isVerbose();
        this.isDeprecation = options.isDeprecation();
        this.jdkSourceLevel = options.getJdkSourceLevel();
        this.out = new CharArrayWriter();
    }

    public JspCompilerResult compile(JspResources[] jspResources, JspResources[] dependencyResources, Collection jspLineIds, List compilerOptions) {
        return this.compile(jspResources[0].getGeneratedSourceFile().getPath(), jspLineIds, compilerOptions);
    }

    public JspCompilerResult compile(String source, Collection jspLineIds, List compilerOptions) {
        boolean directoryCompile;
        this.out.reset();
        int rc = 0;
        String javaHomePath = null;
        try {
            javaHomePath = new File(System.getProperty("java.home")).getCanonicalPath();
        }
        catch (IOException e) {
            this.out.write(e.toString(), 0, e.toString().length());
            JspCompilerResultImpl result = new JspCompilerResultImpl(1, this.out.toString());
            return result;
        }
        this.fullClasspath = this.classloaderContext.getClassPath() + File.pathSeparatorChar + this.options.getOutputDir().getPath();
        this.fullClasspath = this.createJikesClasspath(this.fullClasspath, javaHomePath);
        this.optimizedClasspath = this.createJikesClasspath(this.optimizedClasspath, javaHomePath);
        String cp = null;
        boolean bl = directoryCompile = source.charAt(0) == '@';
        if (!directoryCompile) {
            source = "\"" + source + "\"";
        }
        cp = directoryCompile && !this.useOptimizedClasspath ? this.fullClasspath : this.optimizedClasspath;
        rc = this.runCompile(source, compilerOptions, cp);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "rc = " + rc + " directoryCompile = " + directoryCompile + " useOptimizedClasspath = " + this.useOptimizedClasspath);
        }
        if (rc != 0 && !directoryCompile && !this.useOptimizedClasspath) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "compile", "Warning: failed to compile " + source + " with optimized classpath [" + cp + "]");
            }
            this.out.reset();
            rc = this.runCompile(source, compilerOptions, this.fullClasspath);
        }
        String output = null;
        if (rc != 0 || rc == 0 && (this.isVerbose || this.isDeprecation)) {
            output = this.out.toString();
            if (rc != 0) {
                output = this.getJspLineErrors(output, jspLineIds);
            }
        }
        JspCompilerResultImpl result = new JspCompilerResultImpl(rc, output);
        return result;
    }

    private int runCompile(String source, List compilerOptions, String cp) {
        int rc = 0;
        List argList = this.buildArgList(source, compilerOptions, cp);
        String[] argsArray = new String[argList.size()];
        argsArray = argList.toArray(argsArray);
        StringBuffer argsbuffer = new StringBuffer();
        for (int i = 0; i < argsArray.length; ++i) {
            argsbuffer.append(argsArray[i]);
            argsbuffer.append(" ");
        }
        String args = "jikes " + argsbuffer.toString();
        long start = System.currentTimeMillis();
        try {
            Process process = Runtime.getRuntime().exec(args, null, new File(this.absouluteContextRoot));
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            while (line != null) {
                this.out.write(line + separatorString);
                line = br.readLine();
            }
            process.waitFor();
            rc = process.exitValue();
        }
        catch (InterruptedException e) {
            this.out.write(e.toString(), 0, e.toString().length());
            rc = 1;
        }
        catch (IOException e) {
            this.out.write(e.toString(), 0, e.toString().length());
            rc = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compiling " + source);
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "classpath [" + cp + "]");
        }
        long end = System.currentTimeMillis();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compile complete for " + source + " time = " + (end - start) + " Milliseconds rc = " + rc);
        }
        return rc;
    }

    private List buildArgList(String source, List compilerOptions, String classpath) {
        ArrayList<String> argList = new ArrayList<String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            argList.add("-g");
        }
        if (this.isVerbose) {
            argList.add("-verbose");
        }
        if (this.isDeprecation) {
            argList.add("-deprecation");
        }
        argList.add("-source");
        if (this.jdkSourceLevel.equals("14")) {
            argList.add("1.4");
        } else if (this.jdkSourceLevel.equals("15")) {
            argList.add("1.5");
        } else {
            argList.add("1.3");
        }
        argList.add("-sourcepath");
        argList.add(this.sourcepath);
        argList.add("-classpath");
        argList.add(classpath);
        argList.add("-Xstdout");
        if (compilerOptions != null) {
            for (int i = 0; i < compilerOptions.size(); ++i) {
                String compilerOption = (String)compilerOptions.get(i);
                if (compilerOption.equals("-verbose")) {
                    this.isVerbose = true;
                }
                if (compilerOption.equals("-deprecation")) {
                    this.isDeprecation = true;
                }
                argList.add(compilerOption);
            }
        }
        argList.add(source);
        return argList;
    }

    private String createJikesClasspath(String string, String javaHomePath) {
        StringBuffer classpath = new StringBuffer();
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "core.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "graphics.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "security.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "server.jar" + File.pathSeparatorChar);
        classpath.append(javaHomePath + File.separator + "lib" + File.separator + "xml.jar" + File.pathSeparatorChar);
        classpath.append(string);
        return classpath.toString();
    }

    public String getJspLineErrors(String compilerOutput, Collection jspLineIds) {
        StringBuffer errorMsg = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(compilerOutput));
        try {
            String line = br.readLine();
            int warningIndex = -1;
            String javaName = null;
            while (line != null) {
                int firstQuote;
                int javaNameEnd = line.indexOf(".java\":");
                if (javaNameEnd > 0 && (firstQuote = line.indexOf("\"")) > 0) {
                    javaName = line.substring(firstQuote + 1, javaNameEnd + 5);
                    javaName = javaName.replace('\\', '/');
                    javaName = javaName.replace('/', File.separatorChar);
                }
                warningIndex = line.indexOf("*** Semantic Warning:");
                if (javaName != null && !line.startsWith("[read ") && !line.startsWith("] ") && warningIndex < 0) {
                    try {
                        int firstDot = line.indexOf(46);
                        if (firstDot > 0) {
                            String nr = line.substring(0, firstDot);
                            String lineNumber = "";
                            for (int i = 0; i < nr.length(); ++i) {
                                if (nr.charAt(i) < '0' || nr.charAt(i) > '9') continue;
                                lineNumber = lineNumber + nr.charAt(i);
                            }
                            int lineNr = Integer.parseInt(lineNumber);
                            String mapping = this.findMapping(jspLineIds, lineNr, javaName);
                            if (mapping == null) {
                                errorMsg.append(separatorString);
                            } else {
                                errorMsg.append(mapping);
                            }
                        }
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                errorMsg.append(line);
                errorMsg.append(separatorString);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJspLineErrors", "Failed to find line number mappings for compiler errors", e);
        }
        return errorMsg.toString();
    }

    private String findMapping(Collection jspLineIds, int lineNr, String javaName) {
        String errorMsg = null;
        for (JspLineId lineId : jspLineIds) {
            if (!lineId.getGeneratedFilePath().equals(javaName)) continue;
            if (lineId.getStartGeneratedLineCount() <= 1 && lineId.getStartGeneratedLineNum() == lineNr) {
                errorMsg = this.createErrorMsg(lineId, lineNr);
                break;
            }
            if (lineId.getStartGeneratedLineNum() > lineNr || lineId.getStartGeneratedLineNum() + lineId.getStartGeneratedLineCount() - 1 < lineNr) continue;
            errorMsg = this.createErrorMsg(lineId, lineNr);
            break;
        }
        return errorMsg;
    }

    private String createErrorMsg(JspLineId jspLineId, int errorLineNr) {
        StringBuffer compilerOutput = new StringBuffer();
        if (jspLineId.getSourceLineCount() <= 1) {
            Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
            if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
            } else {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
            }
        } else {
            int actualLineNum = jspLineId.getStartSourceLineNum() + (errorLineNr - jspLineId.getStartGeneratedLineNum());
            if (actualLineNum >= jspLineId.getStartSourceLineNum() && actualLineNum <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                Object[] objArray = new Object[]{new Integer(actualLineNum), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
                }
            } else {
                Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objArray));
                }
            }
        }
        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}));
        return compilerOutput.toString();
    }

    static {
        separatorString = System.getProperty("line.separator");
        logger = Logger.getLogger("com.ibm.ws.jsp");
    }
}

