/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.inputsource.JspURLConnection;
import com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JspURLStreamHandler
extends URLStreamHandler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspUrlStreamHandler";
    private String relativeUrl = null;
    private ExtendedDocumentRootUtils edru = null;
    private boolean searchOnClasspath = false;
    private ClassLoader classloader = null;
    private static Map ENCODED_CHARACTER_MAP = new HashMap();
    private static Pattern CHARS_REQUIRING_ENCODING = null;

    public JspURLStreamHandler(String relativeUrl, ExtendedDocumentRootUtils edru, boolean searchOnClasspath, ClassLoader classloader) {
        this.relativeUrl = relativeUrl;
        this.edru = edru;
        this.searchOnClasspath = searchOnClasspath;
        this.classloader = classloader;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        return new JspURLConnection(url, this.relativeUrl, this.edru, this.searchOnClasspath, this.classloader);
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        String encodedChars = JspURLStreamHandler.replaceEncodedChars(spec);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST) && !spec.equals(encodedChars)) {
            logger.logp(Level.FINEST, CLASS_NAME, "parseURL", "parseURL spec [" + spec + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "parseURL", "parseURL spec encoded [" + encodedChars + "]");
        }
        int length = encodedChars.length();
        super.parseURL(u, encodedChars, start, start + length);
    }

    public static String replaceEncodedChars(String replaceString) {
        Matcher m = CHARS_REQUIRING_ENCODING.matcher(replaceString);
        StringBuffer sb = new StringBuffer();
        boolean matchFound = false;
        while (m.find()) {
            matchFound = true;
            m.appendReplacement(sb, (String)ENCODED_CHARACTER_MAP.get(m.group()));
        }
        if (matchFound) {
            sb = m.appendTail(sb);
            return sb.toString();
        }
        return replaceString;
    }

    static {
        StringBuffer tmpBuffer = new StringBuffer();
        String reservedCharacterString = "!\"#$%&'()*+,:;<=>?@[]^`{|}~";
        char[] reservedCharacters = reservedCharacterString.toCharArray();
        for (int i = 0; i < reservedCharacters.length; ++i) {
            String reservedChar = String.valueOf(reservedCharacters[i]);
            tmpBuffer.append("(\\" + reservedChar + ")");
            if (i != reservedCharacters.length - 1) {
                tmpBuffer.append("|");
            }
            try {
                String encoded = URLEncoder.encode(reservedChar, "UTF-8");
                ENCODED_CHARACTER_MAP.put(reservedChar, encoded);
                continue;
            }
            catch (Exception e) {
                logger.logp(Level.FINER, CLASS_NAME, "staticInit", "failed\tto add encoding " + reservedChar, e);
            }
        }
        CHARS_REQUIRING_ENCODING = Pattern.compile(tmpBuffer.toString());
    }
}

