/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inmemory.resource;

import com.ibm.ws.jsp.inmemory.resource.InMemoryResources;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationEnvironment;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class InMemoryJspResources
implements JspResources,
InMemoryResources {
    protected JspInputSource inputSource = null;
    protected File sourceFile = null;
    protected long sourceFileTimestamp = 0L;
    protected File generatedSourceFile = null;
    protected String className = null;
    protected String packageName = null;
    protected CharArrayWriter generatedSourceWriter = null;
    protected Map<String, byte[]> classBytesMap = new HashMap<String, byte[]>();

    public InMemoryJspResources(JspInputSource inputSource, JspCoreContext context, JspTranslationEnvironment env) {
        this.inputSource = inputSource;
        String jspUri = inputSource.getRelativeURL();
        this.sourceFile = new File(context.getRealPath(jspUri));
        this.packageName = "com.ibm._jsp";
        this.className = env.mangleClassName(jspUri);
        this.generatedSourceFile = new File(System.getProperty("java.io.tmpdir") + File.separator + this.sourceFile.getName() + ".gen");
        this.generatedSourceWriter = new CharArrayWriter();
    }

    public String getClassName() {
        return this.className;
    }

    public File getGeneratedSourceFile() {
        return this.generatedSourceFile;
    }

    public Writer getGeneratedSourceWriter() {
        return this.generatedSourceWriter;
    }

    public char[] getGeneratedSourceChars() {
        return this.generatedSourceWriter.toCharArray();
    }

    public JspInputSource getInputSource() {
        return this.inputSource;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isExternallyTranslated() {
        return false;
    }

    public boolean isOutdated() {
        return this.sourceFile.lastModified() != this.sourceFileTimestamp;
    }

    public void sync() {
        this.sourceFileTimestamp = this.sourceFile.lastModified();
        this.generatedSourceWriter.reset();
    }

    public void setCurrentRequest(HttpServletRequest request) {
    }

    public byte[] getClassBytes(String className) {
        return this.classBytesMap.get(className);
    }

    public void setClassBytes(byte[] bytes, String className) {
        this.classBytesMap.put(className, bytes);
    }
}

