/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inmemory.compiler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inmemory.compiler.InMemoryJspCompilerResult;
import com.ibm.ws.jsp.inmemory.resource.InMemoryResources;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class InMemoryJDTCompiler
implements JspCompiler {
    private static String separatorString = System.getProperty("line.separator");
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "InMemoryJDTCompiler";
    private ClassLoader loader = null;
    private String javaEncoding = null;
    private String outputDir = null;
    private boolean isClassDebugInfo = false;
    private boolean isDebugEnabled = false;
    private boolean isVerbose = false;
    private boolean isDeprecation = false;
    private String jdkSourceLevel = null;
    private boolean useFullPackageNames = false;

    public InMemoryJDTCompiler(ClassLoader loader, JspOptions options) {
        this.loader = loader;
        this.javaEncoding = options.getJavaEncoding();
        this.outputDir = options.getOutputDir().getPath();
        this.isClassDebugInfo = options.isClassDebugInfo();
        this.isDebugEnabled = options.isDebugEnabled();
        this.isVerbose = options.isVerbose();
        this.isDeprecation = options.isDeprecation();
        this.jdkSourceLevel = options.getJdkSourceLevel();
        this.useFullPackageNames = options.isUseFullPackageNames();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "Entering InMemoryJDTCompiler.");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "javaEncoding: [" + this.javaEncoding + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "outputDir: [" + this.outputDir + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "isClassDebugInfo: [" + this.isClassDebugInfo + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "isDebugEnabled: [" + this.isDebugEnabled + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "isVerbose: [" + this.isVerbose + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "isDeprecation: [" + this.isDeprecation + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "jdkSourceLevel: [" + this.jdkSourceLevel + "]");
            logger.logp(Level.FINE, CLASS_NAME, CLASS_NAME, "useFullPackageNames: [" + this.useFullPackageNames + "]");
        }
    }

    public JspCompilerResult compile(String source, Collection jspLineIds, List compilerOptions) {
        return null;
    }

    public JspCompilerResult compile(JspResources[] jspResources, JspResources[] dependencyResources, Collection jspLineIds, List compilerOptions) {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering InMemoryJDTCompiler.compile");
        }
        ICompilationUnit[] jspCompilationUnits = new JspCompilationUnit[jspResources.length];
        ArrayList<JspResources> resourceList = new ArrayList<JspResources>();
        for (i = 0; i < jspResources.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "compile", "Adding compilation unit for [" + jspResources[i].getClassName() + "]");
            }
            jspCompilationUnits[i] = new JspCompilationUnit(jspResources[i]);
            resourceList.add(jspResources[i]);
        }
        if (dependencyResources != null) {
            for (i = 0; i < dependencyResources.length; ++i) {
                resourceList.add(dependencyResources[i]);
            }
        }
        HashMap<String, String> compilerOptionsMap = new HashMap<String, String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        }
        compilerOptionsMap.put("org.eclipse.jdt.core.encoding", this.javaEncoding);
        if (this.jdkSourceLevel.equals("14")) {
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.source", "1.4");
        } else if (this.jdkSourceLevel.equals("15")) {
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.source", "1.5");
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        } else {
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.source", "1.3");
        }
        if (this.isDeprecation) {
            compilerOptionsMap.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        }
        if (this.isVerbose) {
            // empty if block
        }
        JspCompilerRequestor jspCompilerRequestor = new JspCompilerRequestor(jspLineIds, resourceList);
        Compiler compiler = new Compiler((INameEnvironment)new JspNameEnvironment(jspResources, dependencyResources), DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(compilerOptionsMap), (ICompilerRequestor)jspCompilerRequestor, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "about to call compiler.compile()");
        }
        compiler.compile(jspCompilationUnits);
        return jspCompilerRequestor.getJspCompilerResult();
    }

    public class JspCompilerRequestor
    implements ICompilerRequestor {
        private int rc = 0;
        private StringBuffer compilerMessage = null;
        private Collection jspLineIds = null;
        private List resourceList = null;

        public JspCompilerRequestor(Collection jspLineIds, List resourceList) {
            this.jspLineIds = jspLineIds;
            this.resourceList = resourceList;
        }

        public void acceptResult(CompilationResult compilationResult) {
            boolean compileSucceeded = true;
            if (compilationResult.hasProblems()) {
                CategorizedProblem[] problems = compilationResult.getProblems();
                if (this.compilerMessage == null) {
                    this.compilerMessage = new StringBuffer();
                }
                for (int i = 0; i < problems.length; ++i) {
                    CategorizedProblem problem = problems[i];
                    if (problem.isError()) {
                        compileSucceeded = false;
                        this.rc = 1;
                        this.addMessage((IProblem)problem, ((JspCompilationUnit)compilationResult.getCompilationUnit()).getSourcePath());
                        continue;
                    }
                    if (!problem.isWarning() || !InMemoryJDTCompiler.this.isVerbose && !InMemoryJDTCompiler.this.isDeprecation) continue;
                    this.addMessage((IProblem)problem, ((JspCompilationUnit)compilationResult.getCompilationUnit()).getSourcePath());
                }
            }
            if (compileSucceeded) {
                JspCompilationUnit jspCompilationUnit = (JspCompilationUnit)compilationResult.getCompilationUnit();
                ClassFile[] classFiles = compilationResult.getClassFiles();
                for (int i = 0; i < classFiles.length; ++i) {
                    ClassFile classFile = classFiles[i];
                    char[][] compoundName = classFile.getCompoundName();
                    String className = "";
                    String sep = "";
                    for (int j = 0; j < compoundName.length; ++j) {
                        className = className + sep;
                        className = className + new String(compoundName[j]);
                        sep = ".";
                    }
                    jspCompilationUnit.getInMemoryResources().setClassBytes(classFile.getBytes(), className);
                }
            }
        }

        private void addMessage(IProblem problem, String sourcePath) {
            String mapping = this.findMapping(problem.getSourceLineNumber(), sourcePath);
            if (mapping == null) {
                this.compilerMessage.append(separatorString);
            } else {
                this.compilerMessage.append(mapping);
                this.compilerMessage.append(separatorString);
            }
            this.compilerMessage.append(sourcePath);
            this.compilerMessage.append(" : ");
            this.compilerMessage.append(problem.getSourceLineNumber());
            this.compilerMessage.append(" : ");
            this.compilerMessage.append(problem.getMessage());
            this.compilerMessage.append(separatorString);
        }

        public JspCompilerResult getJspCompilerResult() {
            String msg = null;
            if (this.compilerMessage != null) {
                msg = this.compilerMessage.toString();
            }
            return new InMemoryJspCompilerResult(this.rc, msg, this.resourceList);
        }

        private String findMapping(int lineNr, String javaName) {
            String errorMsg = null;
            for (JspLineId lineId : this.jspLineIds) {
                if (!lineId.getGeneratedFilePath().equals(javaName)) continue;
                if (lineId.getStartGeneratedLineCount() <= 1 && lineId.getStartGeneratedLineNum() == lineNr) {
                    errorMsg = this.createErrorMsg(lineId, lineNr);
                    break;
                }
                if (lineId.getStartGeneratedLineNum() > lineNr || lineId.getStartGeneratedLineNum() + lineId.getStartGeneratedLineCount() - 1 < lineNr) continue;
                errorMsg = this.createErrorMsg(lineId, lineNr);
                break;
            }
            return errorMsg;
        }

        private String createErrorMsg(JspLineId jspLineId, int errorLineNr) {
            StringBuffer compilerOutput = new StringBuffer();
            if (jspLineId.getSourceLineCount() <= 1) {
                Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
                }
            } else {
                int actualLineNum = jspLineId.getStartSourceLineNum() + (errorLineNr - jspLineId.getStartGeneratedLineNum());
                if (actualLineNum >= jspLineId.getStartSourceLineNum() && actualLineNum <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                    Object[] objArray = new Object[]{new Integer(actualLineNum), jspLineId.getFilePath()};
                    if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
                    } else {
                        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
                    }
                } else {
                    Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                    if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objArray));
                    } else {
                        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objArray));
                    }
                }
            }
            compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}) + separatorString);
            return compilerOutput.toString();
        }
    }

    public class JspNameEnvironment
    implements INameEnvironment {
        private JspCompilationUnit[] jspCompilationUnits = null;
        private JspResources[] dependencyResources = null;

        public JspNameEnvironment(JspResources[] jspResources, JspResources[] dependencyResources) {
            this.jspCompilationUnits = new JspCompilationUnit[jspResources.length];
            for (int i = 0; i < jspResources.length; ++i) {
                this.jspCompilationUnits[i] = new JspCompilationUnit(jspResources[i]);
            }
            this.dependencyResources = dependencyResources;
        }

        public void cleanup() {
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            String result = "";
            String sep = "";
            for (int i = 0; i < packageName.length; ++i) {
                result = result + sep;
                result = result + new String(packageName[i]);
                sep = ".";
            }
            result = result + sep;
            result = result + new String(typeName);
            return this.getClass(result);
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            String result = "";
            String sep = "";
            for (int i = 0; i < compoundTypeName.length; ++i) {
                result = result + sep;
                result = result + new String(compoundTypeName[i]);
                sep = ".";
            }
            return this.getClass(result);
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String str;
            String result = "";
            String sep = "";
            if (parentPackageName != null) {
                for (int i = 0; i < parentPackageName.length; ++i) {
                    result = result + sep;
                    String str2 = new String(parentPackageName[i]);
                    result = result + str2;
                    sep = ".";
                }
            }
            if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                return false;
            }
            result = result + sep;
            result = result + str;
            return this.isPackage(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPackage(String result) {
            InputStream is = null;
            boolean retbool = false;
            try {
                for (int i = 0; i < this.jspCompilationUnits.length; ++i) {
                    if (!result.equals(this.jspCompilationUnits[i].getJspClassName())) continue;
                    boolean bl = false;
                    return bl;
                }
                String resourceName = result.replace('.', '/') + ".class";
                is = InMemoryJDTCompiler.this.loader.getResourceAsStream(resourceName);
                retbool = is == null;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException exc) {}
                }
            }
            return retbool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NameEnvironmentAnswer getClass(String className) {
            InputStream is = null;
            ByteArrayOutputStream baos = null;
            NameEnvironmentAnswer answer = null;
            try {
                int count;
                int i;
                for (i = 0; i < this.jspCompilationUnits.length; ++i) {
                    if (!className.equals(this.jspCompilationUnits[i].getJspClassName())) continue;
                    NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((ICompilationUnit)this.jspCompilationUnits[i], null);
                    return nameEnvironmentAnswer;
                }
                if (this.dependencyResources != null) {
                    for (i = 0; i < this.dependencyResources.length; ++i) {
                        String dependencyClassName = (this.dependencyResources[i].getPackageName().length() != 0 ? this.dependencyResources[i].getPackageName() + "." : "") + this.dependencyResources[i].getClassName();
                        if (!className.equals(dependencyClassName)) continue;
                        InMemoryResources inMemoryResources = (InMemoryResources)((Object)this.dependencyResources[i]);
                        ClassFileReader classFileReader = new ClassFileReader(inMemoryResources.getClassBytes(dependencyClassName), className.toCharArray(), true);
                        NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                        return nameEnvironmentAnswer;
                    }
                }
                String resourceName = className.replace('.', '/') + ".class";
                is = InMemoryJDTCompiler.this.loader.getResourceAsStream(resourceName);
                if (is == null) return answer;
                byte[] buff = new byte[4096];
                baos = new ByteArrayOutputStream(buff.length);
                while ((count = is.read(buff, 0, buff.length)) > 0) {
                    baos.write(buff, 0, count);
                }
                baos.flush();
                byte[] classBytes = baos.toByteArray();
                ClassFileReader classFileReader = new ClassFileReader(classBytes, className.toCharArray(), true);
                answer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                return answer;
            }
            catch (IOException e) {
                e.printStackTrace();
                return answer;
            }
            catch (ClassFormatException e) {
                e.printStackTrace();
                return answer;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException exc) {}
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException exc) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getClassFileBytes(String sourcePath) {
            byte[] classBytes = null;
            InputStream is = null;
            ByteArrayOutputStream baos = null;
            try {
                int count;
                String classFilePath = sourcePath.substring(0, sourcePath.lastIndexOf(46));
                classFilePath = classFilePath + ".class";
                is = new FileInputStream(classFilePath);
                byte[] buff = new byte[4096];
                baos = new ByteArrayOutputStream(buff.length);
                while ((count = is.read(buff, 0, buff.length)) > 0) {
                    baos.write(buff, 0, count);
                }
                baos.flush();
                classBytes = baos.toByteArray();
            }
            catch (IOException e) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException e) {}
                }
            }
            return classBytes;
        }
    }

    public class JspCompilationUnit
    implements ICompilationUnit {
        private String sourcePath = null;
        private String jspClassName = null;
        private String sourceFileName = null;
        private InMemoryResources inMemoryResources = null;

        public JspCompilationUnit(JspResources jspResources) {
            this.sourceFileName = jspResources.getGeneratedSourceFile().getName();
            this.sourcePath = jspResources.getGeneratedSourceFile().getPath();
            this.jspClassName = (jspResources.getPackageName().length() != 0 ? jspResources.getPackageName() + "." : "") + jspResources.getClassName();
            this.inMemoryResources = (InMemoryResources)((Object)jspResources);
        }

        public char[] getContents() {
            return this.inMemoryResources.getGeneratedSourceChars();
        }

        public char[] getMainTypeName() {
            char[] mainTypeName = null;
            int dot = this.jspClassName.lastIndexOf(46);
            mainTypeName = dot > 0 ? this.jspClassName.substring(dot + 1).toCharArray() : this.jspClassName.toCharArray();
            return mainTypeName;
        }

        public char[][] getPackageName() {
            StringTokenizer st = new StringTokenizer(this.jspClassName, ".");
            char[][] packages = new char[st.countTokens() - 1][];
            for (int i = 0; i < packages.length; ++i) {
                String token = st.nextToken();
                packages[i] = token.toCharArray();
            }
            return packages;
        }

        public char[] getFileName() {
            return this.sourceFileName.toCharArray();
        }

        public String getJspClassName() {
            return this.jspClassName;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public InMemoryResources getInMemoryResources() {
            return this.inMemoryResources;
        }
    }
}

