/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.configuration;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.GlobalJspConfigProps;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.runtime.metadata.JspComponentMetaData;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspWebAppConfig
implements JspXmlExtConfig {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.configuration.JspWebAppConfig";
    List jspPropertyGroups = null;
    HashMap tagLibMap = null;
    JspOptions jspOptions = null;
    JspComponentMetaData jspMetadata = null;
    boolean isServlet24 = false;
    boolean isServlet24_or_higher = false;
    List jspFileExtensions = new ArrayList();
    List servletClassNameList = new ArrayList();
    File outputDir = null;
    Properties webConProperties = new Properties();

    public JspWebAppConfig(IServletContext webApp) {
        String dir;
        WebAppConfig webGroupCfg = webApp.getWebAppConfig();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "webGroupCfg =[" + webGroupCfg + "]");
        }
        this.populateJspOptions(webGroupCfg);
        this.isServlet24 = webGroupCfg.isServlet2_4();
        this.isServlet24_or_higher = webGroupCfg.isServlet2_4OrHigher();
        boolean autoResponseEncoding = webGroupCfg.isAutoResponseEncoding();
        this.jspOptions.setAutoResponseEncoding(autoResponseEncoding);
        this.jspMetadata = (JspComponentMetaData)webGroupCfg.getMetaData().getJspComponentMetadata();
        this.jspPropertyGroups = this.jspMetadata.getJspPropertyGroups();
        this.tagLibMap = (HashMap)this.jspMetadata.getJspTaglibs();
        this.jspOptions.setLooseLibMap(this.jspMetadata.getLooseLibs());
        this.jspOptions.setServlet2_2(this.jspMetadata.isServlet2_2());
        this.jspOptions.setServletEngineReloadEnabled(this.jspMetadata.isServletEngineReloadEnabled());
        this.jspOptions.setServletEngineReloadInterval(this.jspMetadata.getServletEngineReloadInterval());
        this.outputDir = this.jspOptions.isZOS() ? new File(webApp.getCommonTempDirectory()) : (File)webApp.getAttribute("javax.servlet.context.tempdir");
        if (this.outputDir == null && (dir = System.getProperty("java.io.tmpdir")) != null) {
            this.outputDir = new File(dir);
        }
        if (!this.jspOptions.isReloadEnabledSet()) {
            if (this.jspOptions.isServlet2_2()) {
                this.jspOptions.setReloadEnabled(true);
                this.jspOptions.setReloadInterval(5000L);
                logger.logp(Level.FINE, CLASS_NAME, "JspWebAppConfig", "JSP engine reloadEnabled flag not set for application " + this.jspMetadata.getApplicationDisplayName() + ".  Application is Servlet 2.2; using defaults for reloadEnabled [" + this.jspOptions.isReloadEnabled() + "] and reloadInterval [" + this.jspOptions.getReloadInterval() + "]. " + " TrackDependencies = [" + this.jspOptions.isTrackDependencies() + "], DisableJSPRuntimeCompilation = [" + this.jspOptions.isDisableJspRuntimeCompilation() + "].");
            } else {
                this.jspOptions.setReloadEnabled(this.jspMetadata.isServletEngineReloadEnabled());
                this.jspOptions.setReloadInterval(this.jspMetadata.getServletEngineReloadInterval());
                logger.logp(Level.FINE, CLASS_NAME, "JspWebAppConfig", "JSP engine reloadEnabled flag not set for application " + this.jspMetadata.getApplicationDisplayName() + ".  Using webcontainer's settings for reloadEnabled [" + this.jspOptions.isReloadEnabled() + "] and reloadInterval [" + this.jspOptions.getReloadInterval() + "]. " + " TrackDependencies = [" + this.jspOptions.isTrackDependencies() + "], DisableJSPRuntimeCompilation = [" + this.jspOptions.isDisableJspRuntimeCompilation() + "].");
            }
        } else {
            logger.logp(Level.FINE, CLASS_NAME, "JspWebAppConfig", "JSP engine reload settings for application " + this.jspMetadata.getApplicationDisplayName() + ":  reloadEnabled [" + this.jspOptions.isReloadEnabled() + "], reloadInterval [" + this.jspOptions.getReloadInterval() + "], TrackDependencies = [" + this.jspOptions.isTrackDependencies() + "], DisableJSPRuntimeCompilation = [" + this.jspOptions.isDisableJspRuntimeCompilation() + "].");
        }
        this.jspOptions.setOutputDir(this.outputDir);
        Iterator itr = webGroupCfg.getServletInfos();
        while (itr.hasNext()) {
            IServletConfig sconfig = (IServletConfig)itr.next();
            this.servletClassNameList.add(sconfig.getClassName());
        }
        if (webApp.getAttribute("com.ibm.ws.jsf.JSF_IMPL_CHECK") != null && webApp.getAttribute("com.ibm.ws.jsf.JSF_IMPL_CHECK").toString().equalsIgnoreCase("TRUE")) {
            this.jspOptions.setRecompileJspOnRestart(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "tagLibMap = " + this.tagLibMap);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "jspOptions = " + this.jspOptions);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "isServlet24 = " + this.isServlet24);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "isServlet24_or_higher = " + this.isServlet24_or_higher);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "jspPropertyGroups = " + this.jspPropertyGroups);
        }
    }

    private void populateJspOptions(WebAppConfig webGroupCfg) {
        Map jspPropsMap = webGroupCfg.getJspAttributes();
        Properties jspParams = new Properties();
        for (String key : jspPropsMap.keySet()) {
            String value = (String)jspPropsMap.get(key);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateJspOptions", "JspWebAppConfig jspoption key = [" + key + "] value =[" + value + "]");
            }
            if (key != null && key.equals("jsp.file.extensions")) {
                this.createJspFileExtensionList(value);
            }
            jspParams.put(key, value);
        }
        this.webConProperties = WebContainer.getWebContainerProperties();
        GlobalJspConfigProps globalJspProps = new GlobalJspConfigProps();
        globalJspProps.populateGlobalProperties(jspParams, this.webConProperties);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "populateJspOptions", "JspWebAppConfig GlobalJspProperties = " + globalJspProps.toString());
        }
        this.jspOptions = new JspOptions(jspParams);
        this.jspOptions.setOverriddenJspOptions(globalJspProps.toString());
    }

    public Map getTagLibMap() {
        return new HashMap(this.tagLibMap);
    }

    public List getJspPropertyGroups() {
        return this.jspPropertyGroups;
    }

    public boolean isServlet24() {
        return this.isServlet24;
    }

    public boolean isServlet24_or_higher() {
        return this.isServlet24_or_higher;
    }

    public JspOptions getJspOptions() {
        return this.jspOptions;
    }

    public List getJspFileExtensions() {
        return this.jspFileExtensions;
    }

    private void createJspFileExtensionList(String list) {
        StringTokenizer st = new StringTokenizer(list, ": ;");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (this.jspFileExtensions.contains(ext)) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "createJspFileExtensionList", "duplicate value for jsp init param jsp.file.extensions ", ext);
                continue;
            }
            this.jspFileExtensions.add(ext);
        }
    }

    public boolean containsServletClassName(String servletClassName) {
        return this.servletClassNameList.contains(servletClassName);
    }

    public void setWebContainerProperties(Properties webConProperties) {
        this.webConProperties = webConProperties;
    }

    public Properties getWebContainerProperties() {
        return this.webConProperties;
    }
}

