/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.jsf.util.FacesMessages;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public class FacesBeanUtils {
    private static final Map standardClasses = new HashMap();
    protected static Logger log;
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.FacesBeanUtils";

    public static Object convert(String bean, Class targetType) {
        Object returnedObject = null;
        if (targetType.isPrimitive()) {
            targetType = (Class)standardClasses.get(targetType);
        }
        returnedObject = FacesBeanUtils.convertFromString(bean, targetType);
        return returnedObject;
    }

    public static Object convertFromString(String value, Class valueClass) {
        Object o = null;
        o = valueClass.equals(Boolean.TYPE) ? Boolean.valueOf(value) : (valueClass.equals(Byte.TYPE) ? Byte.valueOf(value) : (valueClass.equals(Character.TYPE) ? new Character(value.charAt(0)) : (valueClass.equals(Double.TYPE) ? Double.valueOf(value) : (valueClass.equals(Float.TYPE) ? Float.valueOf(value) : (valueClass.equals(Integer.TYPE) ? Integer.valueOf(value) : (valueClass.equals(Long.TYPE) ? Long.valueOf(value) : (valueClass.equals(Short.TYPE) ? Short.valueOf(value) : Beans.getInstanceOf(value, valueClass))))))));
        return o;
    }

    public static void setProperty(Object bean, String property, Object value) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "setProperty", "property =[" + property + "] bean =[" + bean + "] value =[" + value + "]");
        if (bean == null || property == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{bean, property, value}));
        }
        try {
            PropertyDescriptor pd = FacesBeanUtils.getPropertyDescriptor(property, bean);
            Method m = pd.getWriteMethod();
            Object[] valueArray = new Object[]{value};
            if (m == null || !FacesBeanUtils.paramsAssignableMatch(m, valueArray)) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.write.method", new Object[]{property, bean.getClass().getName()}));
            }
            m.invoke(bean, valueArray);
        }
        catch (InvocationTargetException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "setProperty", "Failed to invoke method " + property);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.invoke.write.method", new Object[]{property, bean.getClass().getName()}), e);
        }
        catch (IllegalAccessException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "setProperty", "Failed to access method " + property);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.access.write.method", new Object[]{property, bean.getClass().getName()}), e);
        }
        catch (IntrospectionException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "setProperty", "Failed to create property descriptor " + property);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.create.property.descriptor", new Object[]{property, bean.getClass().getName()}), e);
        }
    }

    public static void setSimpleProperty(Object bean, String property, Object value) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "setSimpleProperty", "property =[" + property + "] bean =[" + bean + "] value =[" + value + "]");
        if (bean == null || property == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{bean, property}));
        }
        try {
            PropertyDescriptor pd = FacesBeanUtils.getPropertyDescriptor(property, bean);
            Method m = pd.getWriteMethod();
            Object[] valueArray = new Object[]{value};
            if (m == null || !FacesBeanUtils.paramsAssignableMatch(m, valueArray)) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.write.method", new Object[]{property, bean.getClass().getName()}));
            }
            m.invoke(bean, valueArray);
        }
        catch (InvocationTargetException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "setSimpleProperty", "Failed to invoke write method " + property);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.invoke.write.method", new Object[]{property, bean.getClass().getName()}), e);
        }
        catch (IllegalAccessException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "setSimpleProperty", "Failed to access write method " + property);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.access.write.method", new Object[]{property, bean.getClass().getName()}), e);
        }
        catch (IntrospectionException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "setSimpleProperty", "Failed to introspect write method " + property);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.introspect.write.method", new Object[]{property, bean.getClass().getName()}), e);
        }
    }

    public static Class getPropertyType(Object bean, String property) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "getPropertyType", "property =[" + property + "] bean =[" + bean + "]");
        if (bean == null || property == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{bean, property}));
        }
        Class<?> propertyTypeClass = null;
        try {
            PropertyDescriptor pd = FacesBeanUtils.getPropertyDescriptor(property, bean);
            if (pd == null) {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.property.descriptor", new Object[]{property, bean.getClass().getName()}));
            }
            propertyTypeClass = pd.getPropertyType();
        }
        catch (IntrospectionException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "getPropertyType", "Failed to create property descriptor " + property, e);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.create.property.descriptor", new Object[]{property, bean.getClass().getName()}), e);
        }
        log.logp(Level.FINER, CLASS_NAME, "getPropertyType", "propertyTypeClass =[" + propertyTypeClass + "]");
        return propertyTypeClass;
    }

    public static Object getProperty(Object bean, String property) throws FacesException, NoSuchMethodException {
        log.logp(Level.FINER, CLASS_NAME, "getProperty", "property =[" + property + "] bean =[" + bean + "]");
        if (bean == null || property == null) {
            throw new FacesException(FacesMessages.getMsg("jsf.error.bean.or.property.is.null", new Object[]{bean, property}));
        }
        Object returnValue = null;
        try {
            Method m;
            PropertyDescriptor pd = FacesBeanUtils.getPropertyDescriptor(property, bean);
            log.logp(Level.FINER, CLASS_NAME, "getProperty", "PropertyDescriptor.getReadMethod() = " + pd.getReadMethod());
            if (pd != null) {
                m = pd.getReadMethod();
                log.logp(Level.FINER, CLASS_NAME, "getProperty", "Method = " + m.getName() + " Parameters = " + m.getParameterTypes().length + " ReturnType = " + m.getReturnType());
                if (m == null) {
                    throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.property.descriptor", new Object[]{property, bean.getClass().getName()}));
                }
            } else {
                throw new NoSuchMethodException(FacesMessages.getMsg("jsf.error.unable.find.property.descriptor", new Object[]{property, bean.getClass().getName()}));
            }
            returnValue = m.invoke(bean, (Object[])null);
        }
        catch (InvocationTargetException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "getProperty", "Failed to invoke read method " + property, e);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.invoke.read.method", new Object[]{property, bean.getClass().getName()}), e);
        }
        catch (IllegalAccessException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "getProperty", "Failed to access read method " + property, e);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.access.read.method", new Object[]{property, bean.getClass().getName()}), e);
        }
        catch (IntrospectionException e) {
            log.logp(Level.SEVERE, CLASS_NAME, "getProperty", "Failed to create property descriptor " + property, e);
            throw new FacesException(FacesMessages.getMsg("jsf.error.unable.create.property.descriptor", new Object[]{property, bean.getClass().getName()}), e);
        }
        log.logp(Level.FINER, CLASS_NAME, "getProperty", "property =[" + returnValue + "]");
        return returnValue;
    }

    private static boolean paramsAssignableMatch(Method mWrite, Object[] valueArray) {
        Class<?>[] parameterTypes = mWrite.getParameterTypes();
        boolean paramsMatch = true;
        if (parameterTypes.length != valueArray.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class parameterType = FacesBeanUtils.getWrapperClass(parameterTypes[i]);
            Object valueObject = valueArray[i];
            if (valueObject == null) continue;
            paramsMatch = parameterType.isAssignableFrom(valueObject.getClass());
        }
        return paramsMatch;
    }

    private static Class getWrapperClass(Class originalType) {
        if (originalType.isPrimitive()) {
            return (Class)standardClasses.get(originalType);
        }
        return originalType;
    }

    private static PropertyDescriptor getPropertyDescriptor(String property, Object bean) throws IntrospectionException {
        PropertyDescriptor pd = null;
        try {
            pd = new PropertyDescriptor(property, bean.getClass());
        }
        catch (IntrospectionException e) {
            char[] chars = property.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            String getMethodName = new String(chars);
            getMethodName = "get" + getMethodName;
            chars = property.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            String setMethodName = new String(chars);
            setMethodName = "set" + setMethodName;
            chars = property.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            String isMethodName = new String(chars);
            isMethodName = "is" + isMethodName;
            try {
                pd = new PropertyDescriptor(property, bean.getClass(), null, setMethodName);
            }
            catch (IntrospectionException e1) {
                try {
                    pd = new PropertyDescriptor(property, bean.getClass(), getMethodName, null);
                }
                catch (IntrospectionException e2) {
                    pd = new PropertyDescriptor(property, bean.getClass(), isMethodName, null);
                }
            }
        }
        return pd;
    }

    static {
        standardClasses.put(Boolean.TYPE, Boolean.class);
        standardClasses.put(Byte.TYPE, Byte.class);
        standardClasses.put(Character.TYPE, Character.class);
        standardClasses.put(Short.TYPE, Short.class);
        standardClasses.put(Integer.TYPE, Integer.class);
        standardClasses.put(Long.TYPE, Long.class);
        standardClasses.put(Float.TYPE, Float.class);
        standardClasses.put(Double.TYPE, Double.class);
        log = Logger.getLogger("com.ibm.ws.jsf");
    }
}

