/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.admin;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.jsf.util.FacesMessages;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyJSFImplementationCommand
extends AbstractAdminCommand {
    public static final String LIBRARY_TYPE = "Library";
    public static final String LIBRARY_REF_TYPE = "LibraryRef";
    public static final String DEPLOYMENT_TYPE = "Deployment";
    public static final String WEB_MODULE_TYPE = "WebModuleDeployment";
    public static final String CLASS_LOADER_TYPE = "Classloader";
    public static final String CLASS_LOADER_ATTRIBUTE = "classloader";
    public static final String MY_FACES_LIBRARY_NAME = "com.ibm.org.apache.myfaces1_2";
    public static final String MY_FACES_LIBRARY_PATH = "${WAS_INSTALL_ROOT}/plugins/org.apache.myfaces1_2.jar";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String LIBRARY_NAME_ATTRIBUTE = "libraryName";
    public static final String ISOLATED_CLASS_LOADER_ATTRIBUTE = "isolatedClassLoader";
    public static final String CLASSPATH_ATTRIBUTE = "classPath";
    public static final String SHARED_CLASS_LOADER_ATTRIBUTE = "sharedClassloader";
    public static final String LIBRARIES_ATTRIBUTE = "libraries";
    public static final String IMPL_NAME_PARAM = "implName";
    public static final String SUN_IMPL = "SunRI1.2";
    public static final String MYFACES_IMPL = "MyFaces1.2";
    private static final String CLASS_NAME = "com.ibm.ws.jsf.admin.ModifyJSFImplementation";
    private static transient Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private ConfigService _service = null;
    private Session _session = null;
    private String _appName = "";
    private ObjectName _deployment = null;
    private String _implName = null;

    public ModifyJSFImplementationCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        super(metadata2);
    }

    public ModifyJSFImplementationCommand(CommandData inCommandData) throws CommandNotFoundException, CommandLoadException {
        super(inCommandData);
    }

    public void validate() throws CommandValidationException {
        this._service = this.getConfigService();
        this._session = this.getConfigSession();
        this._appName = (String)this.getTargetObject();
        ObjectName[] matches = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, DEPLOYMENT_TYPE, null);
            matches = this._service.queryConfigObjects(this._session, null, pattern, null);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "validate", " found " + matches.length + " deployment objects");
            }
            for (int i = 0; i < matches.length; ++i) {
                String displayName = ConfigServiceHelper.getDisplayName(matches[i]);
                if (!displayName.equals(this._appName)) continue;
                this._deployment = matches[i];
                if (!log.isLoggable(Level.FINE)) continue;
                log.logp(Level.FINE, CLASS_NAME, "validate", " deploymentObject matched the target");
            }
            if (this._deployment == null) {
                throw new CommandValidationException(FacesMessages.getMsg("jsf.error.unable.locate.app", new Object[]{this._appName}));
            }
            this._implName = (String)this.getParameter(IMPL_NAME_PARAM);
            if (!this._implName.equals(SUN_IMPL) && !this._implName.equals(MYFACES_IMPL)) {
                throw new CommandValidationException(FacesMessages.getMsg("jsf.error.invalid.impl.name"));
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandValidationException(e.getMessage());
        }
        catch (ConnectorException e) {
            throw new CommandValidationException(e.getMessage());
        }
    }

    public void execute() {
        CommandResultImpl result = new CommandResultImpl();
        this._service = this.getConfigService();
        this._session = this.getConfigSession();
        try {
            this.validate();
            this.checkAndCreate();
            if (this._implName.equalsIgnoreCase(SUN_IMPL)) {
                this.removeMyFacesLibraryRef();
            } else {
                this.addMyFacesLibraryRef();
            }
        }
        catch (CommandException e) {
            result.setException(e);
        }
        this.setCommandResult(result);
    }

    private void checkAndCreate() throws CommandException {
        ObjectName pattern = null;
        ObjectName[] matches = null;
        AttributeList attrList = new AttributeList();
        try {
            matches = this._service.resolve(this._session, "Library=com.ibm.org.apache.myfaces1_2");
            if (matches.length != 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "checkAndCreate", " shared library for myfaces found");
                }
                return;
            }
            pattern = ConfigServiceHelper.createObjectName(null, "Cell", null);
            ObjectName cellObj = null;
            matches = this._service.queryConfigObjects(this._session, null, pattern, null);
            if (matches.length < 1) {
                throw new CommandException(FacesMessages.getMsg("jsf.error.unable.locate.cell"));
            }
            cellObj = matches[0];
            ConfigServiceHelper.setAttributeValue(attrList, NAME_ATTRIBUTE, MY_FACES_LIBRARY_NAME);
            ConfigServiceHelper.setAttributeValue(attrList, ISOLATED_CLASS_LOADER_ATTRIBUTE, true);
            ArrayList<String> classpath = new ArrayList<String>();
            classpath.add(MY_FACES_LIBRARY_PATH);
            ConfigServiceHelper.setAttributeValue(attrList, CLASSPATH_ATTRIBUTE, classpath);
            this._service.createConfigData(this._session, cellObj, LIBRARY_TYPE, LIBRARY_TYPE, attrList);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "checkAndCreate", " shared library for myfaces created");
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandException(e);
        }
        catch (ConnectorException e) {
            throw new CommandException(e);
        }
    }

    private void removeMyFacesLibraryRef() throws CommandException {
        ObjectName[] matches = null;
        try {
            matches = this.getWebModules();
            for (int i = 0; i < matches.length; ++i) {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CLASS_LOADER_TYPE);
                ObjectName[] classloaders = this._service.queryConfigObjects(this._session, matches[i], pattern, null);
                for (int j = 0; j < classloaders.length; ++j) {
                    this.removeLibraryFromClassloader(classloaders[j]);
                }
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandException(e);
        }
        catch (ConnectorException e) {
            throw new CommandException(e);
        }
    }

    private void addMyFacesLibraryRef() throws CommandException {
        try {
            ObjectName[] matches = this.getWebModules();
            for (int i = 0; i < matches.length; ++i) {
                ObjectName classloader;
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CLASS_LOADER_TYPE);
                ObjectName[] classloaders = this._service.queryConfigObjects(this._session, matches[i], pattern, null);
                if (classloaders.length > 0) {
                    classloader = classloaders[0];
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "addMyFacesLibraryRef", "no classloader found for web module " + matches[i] + ", attempting to add a new classloader");
                    }
                    classloader = this.addClassloaderToWebModule(matches[i]);
                }
                this.addLibraryToClassloader(classloader);
            }
        }
        catch (ConfigServiceException e) {
            throw new CommandException(e);
        }
        catch (ConnectorException e) {
            throw new CommandException(e);
        }
    }

    private void addLibraryToClassloader(ObjectName classloader) throws ConfigServiceException, ConnectorException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addLibraryToClassloader", "attempting to add my faces to classloader " + classloader);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, LIBRARY_REF_TYPE);
        ObjectName[] libraryRefs = this._service.queryConfigObjects(this._session, classloader, pattern, null);
        for (int i = 0; i < libraryRefs.length; ++i) {
            ObjectName library = libraryRefs[i];
            String name = (String)this._service.getAttribute(this._session, library, LIBRARY_NAME_ATTRIBUTE);
            if (!name.equals(MY_FACES_LIBRARY_NAME)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "addLibraryToClassloader", "MyFaces library already exists in classloader " + classloader);
            }
            return;
        }
        AttributeList attrList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attrList, LIBRARY_NAME_ATTRIBUTE, MY_FACES_LIBRARY_NAME);
        ConfigServiceHelper.setAttributeValue(attrList, SHARED_CLASS_LOADER_ATTRIBUTE, true);
        this._service.createConfigData(this._session, classloader, LIBRARIES_ATTRIBUTE, LIBRARY_REF_TYPE, attrList);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addLibraryToClassloader", "MyFaces library created for classloader " + classloader);
        }
    }

    private ObjectName addClassloaderToWebModule(ObjectName webModule) throws ConfigServiceException, ConnectorException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addClassloaderToWebModule", "attempting to add classloader to web module " + webModule);
        }
        AttributeList attrList = new AttributeList();
        ObjectName classloader = this._service.createConfigData(this._session, webModule, CLASS_LOADER_ATTRIBUTE, CLASS_LOADER_TYPE, attrList);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addClassloaderToWebModule", "Classloader added to web module " + webModule);
        }
        return classloader;
    }

    private void removeLibraryFromClassloader(ObjectName classloader) throws ConfigServiceException, ConnectorException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "removeLibraryFromClassloader", "looking for MyFaces library in classloader " + classloader);
        }
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, LIBRARY_REF_TYPE);
        ObjectName[] libraryRefs = this._service.queryConfigObjects(this._session, classloader, pattern, null);
        for (int i = 0; i < libraryRefs.length; ++i) {
            ObjectName library = libraryRefs[i];
            String name = (String)this._service.getAttribute(this._session, library, LIBRARY_NAME_ATTRIBUTE);
            if (!name.equals(MY_FACES_LIBRARY_NAME)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "removeLibraryFromClassloader", "deleting MyFaces library in classloader " + classloader);
            }
            this._service.deleteConfigData(this._session, library);
        }
    }

    private ObjectName[] getWebModules() throws ConfigServiceException, ConnectorException {
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, WEB_MODULE_TYPE);
        return this._service.queryConfigObjects(this._session, this._deployment, pattern, null);
    }
}

