/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(SystemPropertiesUtils.class);
    private static final String S_CLASS_NAME = SystemPropertiesUtils.class.getName();
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";

    public static Properties setArgumentsIntoSystemProperties(String[] asAllArguments) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        Properties propertiesCurrentSystemProps = SystemPropertiesUtils.getCurrentSystemProperties();
        SystemPropertiesUtils.setArgumentsIntoSystemProperties(SystemPropertiesUtils.convertCommandLineToHashtable(asAllArguments));
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        return propertiesCurrentSystemProps;
    }

    public static Properties setArgumentsIntoSystemProperties(Map mapArgumentsToSet) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        Properties propertiesCurrentSystemProps = SystemPropertiesUtils.getCurrentSystemProperties();
        for (String sArgumentKey : mapArgumentsToSet.keySet()) {
            if (mapArgumentsToSet.get(sArgumentKey) instanceof String) {
                String sArgumentValue = (String)mapArgumentsToSet.get(sArgumentKey);
                SystemPropertiesUtils.setValue(sArgumentKey, sArgumentValue);
                continue;
            }
            if (mapArgumentsToSet.get(sArgumentKey) instanceof Vector) {
                Vector vsValues = (Vector)mapArgumentsToSet.get(sArgumentKey);
                if (vsValues.size() > 1) {
                    for (int i = 0; i < vsValues.size(); ++i) {
                        SystemPropertiesUtils.setValue(sArgumentKey + (i + 1), vsValues.elementAt(i).toString());
                    }
                }
                if (vsValues.size() == 1) {
                    SystemPropertiesUtils.setValue(sArgumentKey, vsValues.elementAt(0).toString());
                }
                if (vsValues.size() != 0) continue;
                SystemPropertiesUtils.setValue(sArgumentKey, S_EMPTY);
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setArgumentsIntoSystemProperties", "Improperly formatted values for argument " + sArgumentKey);
        }
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        return propertiesCurrentSystemProps;
    }

    public static Properties getCurrentSystemProperties() {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "getCurrentSystemProperties");
        Properties propertiesCurrentSystemProps = (Properties)System.getProperties().clone();
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "getCurrentSystemProperties");
        return propertiesCurrentSystemProps;
    }

    public static void resetSystemProperties(Properties propertiesSystemProps) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "resetSystemProperties");
        System.setProperties(propertiesSystemProps);
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "resetSystemProperties");
    }

    private static void setValue(String sArgumentKey, String sArgumentValue) {
        if (sArgumentValue != null && !sArgumentValue.equals(S_EMPTY)) {
            System.setProperty(sArgumentKey, sArgumentValue);
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "setValue", "Set System property " + sArgumentKey);
        } else {
            System.setProperty(sArgumentKey, S_EMPTY);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setValue", "Set System property " + sArgumentKey + " with an empty value");
        }
    }

    private static Hashtable convertCommandLineToHashtable(String[] asArgs) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        Hashtable<String, Vector<String>> hashtableArguments = new Hashtable<String, Vector<String>>();
        if (asArgs.length == 0) {
            return hashtableArguments;
        }
        if (!asArgs[0].startsWith(S_DASH)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convertCommandLineToHashtable", "Invalid incoming command line");
            LOGGER.exiting(SystemPropertiesUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
            return hashtableArguments;
        }
        int nCounter = 0;
        while (nCounter < asArgs.length) {
            String sArgumentKey = asArgs[nCounter].substring(S_DASH.length());
            Vector<String> vsArgumentValues = SystemPropertiesUtils.getArgumentValues(asArgs, nCounter);
            hashtableArguments.put(sArgumentKey, vsArgumentValues);
            nCounter = nCounter + vsArgumentValues.size() + 1;
        }
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return hashtableArguments;
    }

    private static Vector<String> getArgumentValues(String[] asArgs, int nCounter) {
        String sArgThis;
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "getArgumentValues");
        Vector<String> vsRet = new Vector<String>();
        for (int i = nCounter + 1; i < asArgs.length && !(sArgThis = asArgs[i]).startsWith(S_DASH); ++i) {
            vsRet.add(sArgThis);
        }
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "getArgumentValues");
        return vsRet;
    }
}

