/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.osutils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessEnvironment {
    private static Map<String, String> m_mapEnvironment = null;
    private static final String S_EQUALS = "=";
    private static final String S_EOLN = "\n";
    private static final String S_IBM_JAVA = "IBM_JAVA_COMMAND_LINE";
    private static final String S_PASSWORD = "*************************";
    private static final Logger LOGGER = LoggerFactory.createLogger(ProcessEnvironment.class);
    private static final String S_CLASS_NAME = ProcessEnvironment.class.getName();
    protected static final String S_EMPTY = "";

    public static String getEnvironmentVariableValue(String sName) {
        LOGGER.entering(ProcessEnvironment.class.getName(), "getEnvironmentVariableValue");
        ProcessEnvironment.loadEnvironmentMap();
        String sPlatformSpecificEnvironmentVariableName = ProcessEnvironment.convertThisEnvironmentVariableNameToUpperCaseIfWindows(sName);
        String oValue = m_mapEnvironment.get(sPlatformSpecificEnvironmentVariableName);
        if (oValue != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getEnvironmentVariableValue", "Value of " + sName + " from the process environment is: " + oValue.toString());
            LOGGER.exiting(ProcessEnvironment.class.getName(), "getEnvironmentVariableValue");
            return oValue.toString();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getEnvironmentVariableValue", "Value of " + sName + " could not be extracted from the process environment, returning null");
        LOGGER.exiting(ProcessEnvironment.class.getName(), "getEnvironmentVariableValue");
        return null;
    }

    private static void loadEnvironmentMap() {
        if (m_mapEnvironment == null) {
            Map<String, String> envMap = System.getenv();
            m_mapEnvironment = new HashMap<String, String>();
            Set<String> keys = envMap.keySet();
            Iterator<String> it = keys.iterator();
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                String key = it.next();
                String val = envMap.get(key);
                sb.append(key + S_EQUALS + val + S_EOLN);
                key = ProcessEnvironment.convertThisEnvironmentVariableNameToUpperCaseIfWindows(key);
                m_mapEnvironment.put(key, val);
            }
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "loadEnvironmentMap", "Unparsed JVM environment follows\n" + ProcessEnvironment.maskLine(sb.toString(), S_IBM_JAVA, S_EOLN));
        }
    }

    public static String dumpEnvironment() {
        LOGGER.entering(ProcessEnvironment.class.getName(), "dumpEnvironment");
        ProcessEnvironment.loadEnvironmentMap();
        String sReturn = S_EMPTY;
        for (String envName : m_mapEnvironment.keySet()) {
            sReturn = sReturn + envName + S_EQUALS + m_mapEnvironment.get(envName) + S_EOLN;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "dumpEnvironment", "Process environment dump follows: \n" + sReturn);
        LOGGER.exiting(ProcessEnvironment.class.getName(), "dumpEnvironment");
        return sReturn;
    }

    private static String convertThisEnvironmentVariableNameToUpperCaseIfWindows(String sEnvironmentVariableName) {
        if (PlatformConstants.isCurrentPlatformWindows()) {
            return sEnvironmentVariableName.toUpperCase();
        }
        return sEnvironmentVariableName;
    }

    private static String maskLine(String sWholeString, String sParameterToMask, String sDelimiter) {
        try {
            int nMaskedIndex = sWholeString.indexOf(sParameterToMask);
            if (nMaskedIndex != -1) {
                return sWholeString.substring(0, nMaskedIndex) + sParameterToMask + S_EQUALS + S_PASSWORD + sDelimiter + sWholeString.substring(sWholeString.indexOf(sDelimiter, nMaskedIndex) + 1);
            }
            return sWholeString;
        }
        catch (Exception ex) {
            return sWholeString;
        }
    }
}

