/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.logging;

import com.ibm.ws.install.configmanager.logging.EmptyLogHandler;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.install.configmanager.logging.XMLAppendFormatter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;

public class LoggerFactory {
    public static final int N_LOG_OFF = 0;
    public static final int N_LOG_SEVERE = 1;
    public static final int N_LOG_WARNING = 2;
    public static final int N_LOG_INFO = 3;
    public static final int N_LOG_CONFIG = 4;
    public static final int N_LOG_FINE = 5;
    public static final int N_LOG_FINER = 6;
    public static final int N_LOG_FINEST = 7;
    private static Handler m_filehandlerRegularLoggers = null;
    private static int m_nCurrentLogLevel = -1;
    private static String m_sCurrentLogFilePath = null;
    private static Vector<Logger> m_vloggersAll = new Vector();
    private static boolean m_fContextSwitch = false;
    private static final char C_EMPTY = ' ';

    public static Logger createLogger(Class classNeedingTheLogger) {
        LoggerFactory.createFileHandlerForRegularLoggersIfNeeded();
        Logger loggerThis = LoggerFactory.createRegularLogger(classNeedingTheLogger);
        if (m_vloggersAll != null && !m_vloggersAll.contains(loggerThis)) {
            m_vloggersAll.add(loggerThis);
        }
        return loggerThis;
    }

    public static Logger reinitAndCreateLogger(Class classNeedingTheLogger) {
        LoggerFactory.switchLogFilesIfNeeded();
        return LoggerFactory.createLogger(classNeedingTheLogger);
    }

    public static void reinitializeInitLoggers(Vector vloggerNewLoggers, Handler handlerNewHandler, int nNewLogLevel, String sNewLogFilePath) {
        LoggerFactory.reinitializeLogHandlers(vloggerNewLoggers, m_filehandlerRegularLoggers, handlerNewHandler);
        if (m_filehandlerRegularLoggers != null) {
            m_filehandlerRegularLoggers.close();
        }
        m_filehandlerRegularLoggers = handlerNewHandler;
        m_nCurrentLogLevel = nNewLogLevel;
        m_sCurrentLogFilePath = sNewLogFilePath;
    }

    protected static Vector getAllLoggers() {
        return m_vloggersAll;
    }

    protected static Handler getCurrentLogHandler() {
        return m_filehandlerRegularLoggers;
    }

    protected static int getLogLevel() {
        return m_nCurrentLogLevel;
    }

    protected static String getCurrentLogFilePath() {
        return m_sCurrentLogFilePath;
    }

    protected static void setContextSwitchFlag(boolean fContextSwitch) {
        m_fContextSwitch = fContextSwitch;
    }

    private static void switchLogFilesIfNeeded() {
        if (LoggerFactory.isAReInitOfLoggerFactoryRequired()) {
            int i;
            for (i = 0; i < m_vloggersAll.size(); ++i) {
                m_vloggersAll.elementAt(i).removeHandler(m_filehandlerRegularLoggers);
            }
            if (m_filehandlerRegularLoggers != null && !m_fContextSwitch) {
                m_filehandlerRegularLoggers.close();
            }
            m_filehandlerRegularLoggers = null;
            LoggerFactory.createFileHandlerForRegularLoggersIfNeeded();
            for (i = 0; i < m_vloggersAll.size(); ++i) {
                m_vloggersAll.elementAt(i).addHandler(m_filehandlerRegularLoggers);
            }
        }
    }

    private static void reinitializeLogHandlers(Vector vloggerAllLoggers, Handler handlerToBeRemoved, Handler handlerToBeAdded) {
        for (int i = 0; i < vloggerAllLoggers.size(); ++i) {
            ((Logger)vloggerAllLoggers.elementAt(i)).removeHandler(handlerToBeRemoved);
            if (handlerToBeAdded == null) continue;
            ((Logger)vloggerAllLoggers.elementAt(i)).addHandler(handlerToBeAdded);
        }
    }

    private static boolean isAReInitOfLoggerFactoryRequired() {
        if (m_nCurrentLogLevel != LoggerFactoryConstants.getDesiredLogLevel()) {
            return true;
        }
        return !LoggerFactoryConstants.getGlobalLogFilePath().equals(m_sCurrentLogFilePath);
    }

    private static void createFileHandlerForRegularLoggersIfNeeded() {
        if (m_filehandlerRegularLoggers != null) {
            return;
        }
        try {
            if (!LoggerFactoryConstants.isEmptyFileHandlerCase()) {
                LoggerFactory.createLogDirectoryIfNeeded();
                m_filehandlerRegularLoggers = new FileHandler(LoggerFactoryConstants.getGlobalLogFilePath(), LoggerFactoryConstants.getDesiredAppendSetting());
                m_filehandlerRegularLoggers.setLevel(LoggerFactory.getCurrentLogLevel());
                try {
                    if (LoggerFactoryConstants.getDesiredAppendSetting()) {
                        RandomAccessFile rafLog = new RandomAccessFile(LoggerFactoryConstants.getGlobalLogFilePath(), "rw");
                        int nRemoveableTags = new XMLFormatter().getTail(m_filehandlerRegularLoggers).length();
                        if (rafLog.length() >= (long)nRemoveableTags) {
                            rafLog.seek(rafLog.length() - (long)nRemoveableTags);
                            for (int i = 0; i < nRemoveableTags; ++i) {
                                rafLog.writeByte(32);
                            }
                        }
                        rafLog.close();
                        m_filehandlerRegularLoggers.setFormatter(new XMLAppendFormatter());
                        m_filehandlerRegularLoggers.publish(new LogRecord(Level.INFO, null));
                        m_filehandlerRegularLoggers.setFormatter(new XMLFormatter());
                    }
                }
                catch (IOException ioEx) {}
            } else {
                m_filehandlerRegularLoggers = new EmptyLogHandler();
            }
            m_sCurrentLogFilePath = LoggerFactoryConstants.getGlobalLogFilePath();
            m_nCurrentLogLevel = LoggerFactoryConstants.getDesiredLogLevel();
            return;
        }
        catch (IOException e) {
            m_filehandlerRegularLoggers = new ConsoleHandler();
            return;
        }
    }

    private static void createLogDirectoryIfNeeded() {
        File fileLogDirectory = new File(LoggerFactoryConstants.getGlobalLogDirectory());
        if (!fileLogDirectory.exists()) {
            fileLogDirectory.mkdirs();
        }
    }

    private static Logger createRegularLogger(Class classNeedingTheLogger) {
        Logger loggerRegular = Logger.getLogger(classNeedingTheLogger.getName());
        LoggerFactory.initializeLoggerAsRegularLogger(loggerRegular);
        return loggerRegular;
    }

    private static void initializeLoggerAsRegularLogger(Logger loggerThis) {
        loggerThis.setLevel(LoggerFactory.getCurrentLogLevel());
        if (!LoggerFactory.hasHandler(loggerThis, m_filehandlerRegularLoggers)) {
            loggerThis.addHandler(m_filehandlerRegularLoggers);
        }
        loggerThis.setUseParentHandlers(false);
    }

    private static boolean hasHandler(Logger loggerThis, Handler regularLoggers) {
        Handler[] haHandlers = loggerThis.getHandlers();
        for (int i = 0; i < haHandlers.length; ++i) {
            if (!haHandlers[i].equals(regularLoggers)) continue;
            return true;
        }
        return false;
    }

    private static Level getCurrentLogLevel() {
        return LoggerFactory.translateLoggerFactoryLevelToLevelObject(LoggerFactoryConstants.getDesiredLogLevel());
    }

    private static Level translateLoggerFactoryLevelToLevelObject(int nLoggerFactoryLevel) {
        switch (nLoggerFactoryLevel) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.CONFIG;
            }
            case 5: {
                return Level.FINE;
            }
            case 6: {
                return Level.FINER;
            }
            case 7: {
                return Level.FINEST;
            }
        }
        return Level.INFO;
    }
}

