/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.util.JavaEnvUtils;

public class InProcessAntRunner {
    public static final String DEFAULT_BUILD_FILENAME = "wsconfig.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private Vector targets = new Vector(5);
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(5);
    private Vector propertyFiles = new Vector(5);
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed = false;
    private static String antVersion = null;
    private static final Logger LOGGER = LoggerFactory.createLogger(InProcessAntRunner.class);
    private static final String S_CLASS_NAME = InProcessAntRunner.class.getName();

    private static void printMessage(Throwable t) {
        LogUtils.logException(LOGGER, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        InProcessAntRunner m = null;
        try {
            Diagnostics.validateVersion();
            m = new InProcessAntRunner(args);
        }
        catch (Throwable exc) {
            InProcessAntRunner.printMessage(exc);
            return false;
        }
        Enumeration<?> eSys = System.getProperties().propertyNames();
        while (eSys.hasMoreElements()) {
            String key = (String)eSys.nextElement();
            String property = System.getProperty(key);
            m.definedProps.put(key, property);
        }
        if (additionalUserProperties != null) {
            Enumeration<Object> e = additionalUserProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String property = additionalUserProperties.getProperty(key);
                m.definedProps.put(key, property);
            }
        }
        try {
            m.runBuild(coreLoader);
            boolean e = true;
            return e;
        }
        catch (BuildException be) {
            if (err != System.err) {
                InProcessAntRunner.printMessage(be);
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable exc) {
            boolean bl;
            block33: {
                block34: {
                    exc.printStackTrace();
                    InProcessAntRunner.printMessage(exc);
                    bl = false;
                    if (!isLogFileUsed) break block33;
                    if (out == null) break block34;
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return bl;
        }
        finally {
            if (isLogFileUsed) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public static void main(String[] args) {
        InProcessAntRunner.start(args, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InProcessAntRunner(String[] args) throws BuildException {
        String searchForThis = null;
        PrintStream logTo = null;
        for (int i = 0; i < args.length; ++i) {
            String msg;
            String arg = args[i];
            if (arg.equals("-help")) {
                InProcessAntRunner.printUsage();
                return;
            }
            if (arg.equals("-version")) {
                InProcessAntRunner.printVersion();
                return;
            }
            if (arg.equals("-diagnostics")) {
                Diagnostics.doReport(System.out);
                return;
            }
            if (arg.equals("-quiet") || arg.equals("-q")) {
                this.msgOutputLevel = 1;
                continue;
            }
            if (arg.equals("-verbose") || arg.equals("-v")) {
                InProcessAntRunner.printVersion();
                this.msgOutputLevel = 3;
                continue;
            }
            if (arg.equals("-debug")) {
                InProcessAntRunner.printVersion();
                this.msgOutputLevel = 4;
                continue;
            }
            if (arg.equals("-logfile") || arg.equals("-l")) {
                try {
                    File logFile = new File(args[i + 1]);
                    ++i;
                    logTo = new PrintStream(new FileOutputStream(logFile));
                    isLogFileUsed = true;
                    continue;
                }
                catch (IOException ioe) {
                    msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    InProcessAntRunner.logOutputMessage(msg);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a log file when using the -log argument";
                    InProcessAntRunner.logOutputMessage(msg);
                    return;
                }
            }
            if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f")) {
                try {
                    this.buildFile = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a buildfile when using the -buildfile argument";
                    InProcessAntRunner.logOutputMessage(msg);
                    return;
                }
            }
            if (arg.equals("-listener")) {
                try {
                    this.listeners.addElement(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a classname when using the -listener argument";
                    InProcessAntRunner.logOutputMessage(msg);
                    return;
                }
            }
            if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length - 1) {
                    value = args[++i];
                }
                this.definedProps.put(name, value);
                continue;
            }
            if (arg.equals("-logger")) {
                if (this.loggerClassname != null) {
                    InProcessAntRunner.logOutputMessage("Only one logger class may  be specified.");
                    return;
                }
                try {
                    this.loggerClassname = args[++i];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    InProcessAntRunner.logOutputMessage("You must specify a classname when using the -logger argument");
                    return;
                }
            }
            if (arg.equals("-inputhandler")) {
                if (this.inputHandlerClassname != null) {
                    InProcessAntRunner.logOutputMessage("Only one input handler class may be specified.");
                    return;
                }
                try {
                    this.inputHandlerClassname = args[++i];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    InProcessAntRunner.logOutputMessage("You must specify a classname when using the -inputhandler argument");
                    return;
                }
            }
            if (arg.equals("-emacs")) {
                this.emacsMode = true;
                continue;
            }
            if (arg.equals("-projecthelp")) {
                this.projectHelp = true;
                continue;
            }
            if (arg.equals("-find")) {
                if (i < args.length - 1) {
                    searchForThis = args[++i];
                    continue;
                }
                searchForThis = DEFAULT_BUILD_FILENAME;
                continue;
            }
            if (arg.startsWith("-propertyfile")) {
                try {
                    this.propertyFiles.addElement(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a property filename when using the -propertyfile argument";
                    InProcessAntRunner.logOutputMessage(msg);
                    return;
                }
            }
            if (arg.startsWith("-")) {
                String msg2 = "Unknown argument: " + arg;
                InProcessAntRunner.logOutputMessage(msg2);
                InProcessAntRunner.printUsage();
                return;
            }
            this.targets.addElement(arg);
        }
        if (this.buildFile == null) {
            this.buildFile = searchForThis != null ? this.findBuildFile(System.getProperty("user.dir"), searchForThis) : new File(DEFAULT_BUILD_FILENAME);
        }
        if (!this.buildFile.exists()) {
            InProcessAntRunner.logOutputMessage("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            InProcessAntRunner.logOutputMessage("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        for (int propertyFileIndex = 0; propertyFileIndex < this.propertyFiles.size(); ++propertyFileIndex) {
            String filename = (String)this.propertyFiles.elementAt(propertyFileIndex);
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filename);
                props.load(fis);
            }
            catch (IOException e) {
                InProcessAntRunner.logOutputMessage("Could not load property file " + filename + ": " + e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (this.definedProps.getProperty(name) != null) continue;
                this.definedProps.put(name, props.getProperty(name));
            }
        }
        if (this.msgOutputLevel >= 2) {
            InProcessAntRunner.logOutputMessage("Buildfile: " + this.buildFile);
        }
        if (logTo != null) {
            out = err = logTo;
            System.setOut(out);
            System.setErr(out);
        }
        this.readyToRun = true;
    }

    private File getParentFile(File file) {
        String filename = file.getAbsolutePath();
        file = new File(filename);
        if ((filename = file.getParent()) != null && this.msgOutputLevel >= 3) {
            InProcessAntRunner.logOutputMessage("Searching in " + filename);
        }
        return filename == null ? null : new File(filename);
    }

    private File findBuildFile(String start, String suffix) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            InProcessAntRunner.logOutputMessage("Searching for " + suffix + " ...");
        }
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(ClassLoader coreLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        Project project = new Project();
        project.setCoreLoader(coreLoader);
        Throwable error = null;
        try {
            this.addBuildListeners(project);
            this.addInputHandler(project);
            PrintStream err = System.err;
            PrintStream out = System.out;
            SecurityManager oldsm = null;
            if (!JavaEnvUtils.isJavaVersion("1.0") && !JavaEnvUtils.isJavaVersion("1.1")) {
                oldsm = System.getSecurityManager();
            }
            try {
                System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
                if (!this.projectHelp) {
                    project.fireBuildStarted();
                }
                project.init();
                project.setUserProperty("ant.version", InProcessAntRunner.getAntVersion());
                Enumeration<Object> e = this.definedProps.keys();
                while (e.hasMoreElements()) {
                    String arg = (String)e.nextElement();
                    String value = (String)this.definedProps.get(arg);
                    project.setUserProperty(arg, value);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                ProjectHelper.configureProject(project, this.buildFile);
                if (this.projectHelp) {
                    InProcessAntRunner.printDescription(project);
                    InProcessAntRunner.printTargets(project, this.msgOutputLevel > 2);
                    return;
                }
                if (this.targets.size() == 0) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            finally {
                if (oldsm != null) {
                    System.setSecurityManager(oldsm);
                }
                System.setOut(out);
                System.setErr(err);
            }
        }
        catch (RuntimeException exc) {
            error = exc;
            throw exc;
        }
        catch (Error err) {
            error = err;
            throw err;
        }
        finally {
            if (!this.projectHelp) {
                project.fireBuildFinished(error);
            }
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        for (int i = 0; i < this.listeners.size(); ++i) {
            String className = (String)this.listeners.elementAt(i);
            try {
                BuildListener listener = (BuildListener)Class.forName(className).newInstance();
                project.addBuildListener(listener);
                continue;
            }
            catch (Throwable exc) {
                throw new BuildException("Unable to instantiate listener " + className, exc);
            }
        }
    }

    private void addInputHandler(Project project) {
        InputHandler handler = null;
        if (this.inputHandlerClassname == null) {
            handler = new DefaultInputHandler();
        } else {
            try {
                handler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
            }
            catch (ClassCastException e) {
                String msg = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(msg);
            }
            catch (Exception e) {
                String msg = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + e.getClass().getName();
                throw new BuildException(msg);
            }
        }
        project.setInputHandler(handler);
    }

    private BuildLogger createLogger() {
        BuildLogger logger = null;
        if (this.loggerClassname != null) {
            try {
                logger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException e) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception e) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + e.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            logger = new DefaultLogger();
        }
        logger.setMessageOutputLevel(this.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.emacsMode);
        return logger;
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [options] [target [target2 [target3] ...]]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help                  print this message" + lSep);
        msg.append("  -projecthelp           print project help information" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -diagnostics           print information that might be helpful to" + lSep);
        msg.append("                         diagnose or report problems." + lSep);
        msg.append("  -quiet, -q             be extra quiet" + lSep);
        msg.append("  -verbose, -v           be extra verbose" + lSep);
        msg.append("  -debug                 print debugging information" + lSep);
        msg.append("  -emacs                 produce logging information without adornments" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("    -l     <file>                ''" + lSep);
        msg.append("  -logger <classname>    the class which is to perform logging" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("    -file    <file>              ''" + lSep);
        msg.append("    -f       <file>              ''" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        msg.append("  -propertyfile <name>   load all properties from file with -D" + lSep);
        msg.append("                         properties taking precedence" + lSep);
        msg.append("  -inputhandler <class>  the class which will handle input requests" + lSep);
        msg.append("  -find <file>           search for buildfile towards the root of the" + lSep);
        msg.append("                         filesystem and use it" + lSep);
        InProcessAntRunner.logOutputMessage(msg.toString());
    }

    private static void printVersion() throws BuildException {
        InProcessAntRunner.logOutputMessage(InProcessAntRunner.getAntVersion());
    }

    private static void logOutputMessage(String sMessage) {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "logOutputMessage", sMessage);
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties props = new Properties();
                InputStream in = InProcessAntRunner.class.getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                StringBuffer msg = new StringBuffer();
                msg.append("Apache Ant version ");
                msg.append(props.getProperty("VERSION"));
                msg.append(" compiled on ");
                msg.append(props.getProperty("DATE"));
                antVersion = msg.toString();
            }
            catch (IOException ioe) {
                throw new BuildException("Could not load the version information:" + ioe.getMessage());
            }
            catch (NullPointerException npe) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static void printTargets(Project project, boolean printSubTargets) {
        String defaultTarget;
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        while (ptargets.hasMoreElements()) {
            int pos;
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = InProcessAntRunner.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = InProcessAntRunner.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        InProcessAntRunner.printTargets(project, topNames, topDescriptions, "InProcessAntRunner targets:", maxLength);
        if (topNames.size() == 0) {
            printSubTargets = true;
        }
        if (printSubTargets) {
            InProcessAntRunner.printTargets(project, subNames, null, "Subtargets:", 0);
        }
        if ((defaultTarget = project.getDefaultTarget()) != null && !"".equals(defaultTarget)) {
            project.log("Default target: " + defaultTarget);
        }
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        for (int i = 0; i < names.size() && res == names.size(); ++i) {
            if (name.compareTo((String)names.elementAt(i)) >= 0) continue;
            res = i;
        }
        return res;
    }

    private static void printTargets(Project project, Vector names, Vector descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = spaces + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(heading + lSep + lSep);
        for (int i = 0; i < names.size(); ++i) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
        }
        project.log(msg.toString());
    }
}

