/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.Environment;
import com.ibm.ws.install.configmanager.actionengine.Parameter;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.CurrentEnvironment;
import com.ibm.ws.install.configmanager.utils.ParameterPassingUtils;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArgumentConfigAction
extends ConfigAction {
    protected List<Environment> m_listSupportedEnvironments = null;
    protected List<Parameter> m_listParameters = null;
    private static final Logger LOGGER = LoggerFactory.createLogger(ArgumentConfigAction.class);
    private static final String S_CLASS_NAME = ArgumentConfigAction.class.getName();

    protected ArgumentConfigAction(String sActionPath, int nPriority, boolean fFatal, List<Parameter> listParameters, String sResourceBundle, boolean fOptional, String alias, List<Environment> listSupportedEnvironments) {
        super(sActionPath, nPriority, fFatal, new Vector(), sResourceBundle, fOptional, alias);
        this.m_listSupportedEnvironments = listSupportedEnvironments;
        this.m_listParameters = listParameters;
    }

    public List<Parameter> getActionParameters() {
        return this.m_listParameters;
    }

    public String executeArgumentAction() {
        Properties propBackup = SystemPropertiesUtils.getCurrentSystemProperties();
        List<Parameter> listParams = this.getActionParameters();
        ParameterPassingUtils.setParametersIntoSystemProperties(listParams);
        super.executeAction();
        String sOutput = this.getActionOutput();
        SystemPropertiesUtils.resetSystemProperties(propBackup);
        return sOutput;
    }

    @Override
    public boolean doIRun() {
        LOGGER.entering(ConfigAction.class.getName(), "doIRun");
        boolean f_doIRun = this.m_listSupportedEnvironments.contains((Object)CurrentEnvironment.getEnvironment());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", "Does " + this.m_sActionName + " run: " + Boolean.valueOf(f_doIRun).toString());
        LOGGER.exiting(ConfigAction.class.getName(), "doIRun");
        return f_doIRun;
    }
}

