/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ArgumentRegistryParser;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.RegistryStructureException;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.RegistryParsingUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRegistryParser {
    private static final String S_TAG_REG_ACTION = "action";
    private static final String S_TAG_REG_PATH = "path";
    private static final String S_TAG_REG_PRIORITY = "priority";
    private static final String S_TAG_REG_ISFATAL = "isFatal";
    private static final String S_TAG_REG_ISOPTIONAL = "isOptional";
    private static final String S_TAG_REG_ALIAS = "alias";
    private static final String S_TAG_REG_DESCRIPTIONBUNDLE = "descriptionBundle";
    private static final String S_EMPTY = "";
    private static Hashtable<String, List<ConfigAction>> m_htConfigActionList = new Hashtable();
    private static final Logger LOGGER = LoggerFactory.createLogger(ActionRegistryParser.class);
    private static final String S_CLASS_NAME = ActionRegistryParser.class.getName();

    public static List getSortedActionListFromRegistryFile() {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
        File fileActionRegistry = ActionRegistryParser.getActionRegistryFileObject();
        if (m_htConfigActionList == null) {
            m_htConfigActionList = new Hashtable();
        }
        if (fileActionRegistry != null && m_htConfigActionList.containsKey(fileActionRegistry.getAbsolutePath())) {
            List<ConfigAction> listCachedActions = m_htConfigActionList.get(fileActionRegistry.getAbsolutePath());
            Vector<ConfigAction> listForReturn = new Vector<ConfigAction>();
            for (int i = 0; i < listCachedActions.size(); ++i) {
                listForReturn.add(listCachedActions.get(i));
            }
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
            return listForReturn;
        }
        try {
            Document documentActionRegistryDOM = RegistryParsingUtils.parseRegistryXMLFileIntoADOMModel(fileActionRegistry);
            List<ConfigAction> listActions = ActionRegistryParser.convertDOMToActionList(documentActionRegistryDOM, fileActionRegistry);
            ActionRegistryParser.removeAbsentActionsFromList(listActions);
            Collections.sort(listActions);
            m_htConfigActionList.put(fileActionRegistry.getAbsolutePath(), listActions);
            Vector<ConfigAction> listForReturn = new Vector<ConfigAction>();
            for (int i = 0; i < listActions.size(); ++i) {
                listForReturn.add(listActions.get(i));
            }
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
            return listForReturn;
        }
        catch (ParserConfigurationException parserconfigurationexception) {
            LogUtils.logException(LOGGER, parserconfigurationexception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "XML parser initialization exception while trying to parse the action registry, returning null as action list");
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
            return null;
        }
        catch (SAXException saxexception) {
            LogUtils.logException(LOGGER, saxexception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "Action registry is corrupt, returning null as action list");
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
            return null;
        }
        catch (IOException ioexception) {
            LogUtils.logException(LOGGER, ioexception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "I/O exception in accessing the action registry, returning null as action list");
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
            return null;
        }
        catch (RegistryStructureException exception) {
            LogUtils.logException(LOGGER, exception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getSortedActionListFromRegistryFile", "RegistryStructureException was throw while parsing the action registry, argumentdefinitions might be corrupt, returning null as action list.");
            LOGGER.exiting(ActionRegistryParser.class.getName(), "getSortedActionListFromRegistryFile");
            return null;
        }
    }

    public static boolean isAnActionRegistryAvailable() {
        File fileActionRegistry = ActionRegistryParser.getActionRegistryFileObject();
        if (fileActionRegistry == null) {
            return false;
        }
        return fileActionRegistry.exists();
    }

    private static File getActionRegistryFileObject() {
        String sActionRegistryPath = ArgumentValueFetcher.getArgumentValue("WS_CMT_ACTION_REGISTRY");
        if (sActionRegistryPath == null) {
            return null;
        }
        return new File(sActionRegistryPath);
    }

    private static List<ConfigAction> convertDOMToActionList(Document document, File fileRegistry) throws RegistryStructureException {
        LOGGER.entering(ActionRegistryParser.class.getName(), "convertDOMToActionList");
        Vector<ConfigAction> listConfigActions = new Vector<ConfigAction>();
        NodeList nodelistActions = document.getElementsByTagName(S_TAG_REG_ACTION);
        for (int nNodeNumber = 0; nNodeNumber < nodelistActions.getLength(); ++nNodeNumber) {
            Node nodeActionThis = nodelistActions.item(nNodeNumber);
            NamedNodeMap namednodemapAttributes = nodeActionThis.getAttributes();
            String sActionFilePathRelativeToConfigRepository = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namednodemapAttributes);
            String sActionIsFatal = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ISFATAL, namednodemapAttributes);
            String sActionIsOptional = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ISOPTIONAL, namednodemapAttributes);
            String sActionAlias = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ALIAS, namednodemapAttributes);
            String sActionDescriptionBundle = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_DESCRIPTIONBUNDLE, namednodemapAttributes);
            if (sActionFilePathRelativeToConfigRepository == null || sActionIsFatal == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "convertDOMToActionList", "Encountered invalid or missing attributes for an action, skipping it, action registry is possibly corrupt");
                continue;
            }
            String sActionPriority = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PRIORITY, namednodemapAttributes);
            List<Object> listActionArguments = new Vector();
            listActionArguments = ArgumentRegistryParser.isArgumentRegistryAvailable(document) ? RegistryParsingUtils.getActionArgumentListForTheGivenNodeFromArgumentRegistry(document, nodeActionThis) : RegistryParsingUtils.getActionArgumentListForTheGivenNode(nodeActionThis);
            int nActionPriority = 999999999;
            if (sActionPriority != null) {
                nActionPriority = Integer.parseInt(sActionPriority);
            }
            if (sActionAlias == null) {
                sActionAlias = S_EMPTY;
            }
            boolean fIsFatal = Boolean.valueOf(sActionIsFatal);
            boolean fIsOptional = Boolean.valueOf(sActionIsOptional);
            String sActionFileAbsolutePath = new File(ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR"), sActionFilePathRelativeToConfigRepository).getAbsolutePath();
            ConfigAction caThis = ConfigAction.createAction(sActionFileAbsolutePath, nActionPriority, fIsFatal, listActionArguments, sActionDescriptionBundle, fIsOptional, sActionAlias);
            listConfigActions.add(caThis);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "convertDOMToActionList");
        return listConfigActions;
    }

    private static void removeAbsentActionsFromList(List<ConfigAction> listAction) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "removeAbsentActionsFromList");
        Iterator<ConfigAction> iteratorConfigActions = listAction.iterator();
        while (iteratorConfigActions.hasNext()) {
            ConfigAction caThis = iteratorConfigActions.next();
            if (caThis.isThisActionActuallyPresentOnTheFileSystem()) continue;
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "removeAbsentActionsFromList", "Removing absent action " + caThis.getActionPath() + " from action list.");
            iteratorConfigActions.remove();
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "removeAbsentActionsFromList");
    }
}

