/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ws.ejbcontainer.util.BridgeTargetMethodAdapter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeTargetClassAdapter
extends ClassAdapter {
    private final Method[] ivImplMethods;
    private final Map<String, Method> ivBridgeTargetMap = new HashMap<String, Method>();
    private String ivKey;
    private static final int BRIDGE_METHOD_ACCESS = 4161;

    public BridgeTargetClassAdapter(ClassWriter classVisitor, Method[] implMethods) {
        super((ClassVisitor)classVisitor);
        this.ivImplMethods = implMethods;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        BridgeTargetMethodAdapter visitor = null;
        if (access == 4161) {
            this.ivKey = name + ":" + desc;
            visitor = new BridgeTargetMethodAdapter((MethodVisitor)new EmptyVisitor(), this, this.ivImplMethods);
        } else {
            this.ivKey = null;
        }
        return visitor;
    }

    static String getKeyForBridgeTargetMap(Method m) {
        if (!m.isBridge()) {
            throw new IllegalArgumentException("The Method argument for getKeyForBridgeTargetMap must be a bridge method. " + m.toString() + " is not a bridge method.");
        }
        return m.getName() + ":" + MethodAttribUtils.jdiMethodSignature(m);
    }

    public Map<String, Method> getBridgeMethodTargetMap() {
        return this.ivBridgeTargetMap;
    }

    void setBridgeMethodTarget(Method bridgeTarget) {
        this.ivBridgeTargetMap.put(this.ivKey, bridgeTarget);
    }
}

