/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WASDirectoryResourceBundleUtils {
    private static final String S_WASPRODUCT_TEXT_RESOURCE_BUNDLE_NAME = "com.ibm.websphere.product.WASProductNLSText";
    private static final String S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME = "com.ibm.websphere.product.WASProductNLS";
    private static final String S_WASHISTORY_TEXT_RESOURCE_BUNDLE_NAME = "com.ibm.websphere.product.history.WASHistoryNLSText";
    private static final String S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME = "com.ibm.websphere.product.history.WASHistoryNLS";
    private static final Pattern messageKeyPattern = Pattern.compile("WVER[0-9]{4}[A-Z]:\\s");
    private static final String S_EMPTY = "";

    public static String getVersionLocaleString(String sKey, Object sParam) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleText = ResourceBundle.getBundle(S_WASPRODUCT_TEXT_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleText.getString(sKey);
            return MessageFormat.format(sString, sParam);
        }
        catch (MissingResourceException mreProductText) {
            ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return MessageFormat.format(sString, sParam);
            }
            catch (MissingResourceException mreProductMsg) {
                return sKey;
            }
        }
    }

    public static String getHistoryLocaleString(String sKey, Object sParam) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleText = ResourceBundle.getBundle(S_WASHISTORY_TEXT_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleText.getString(sKey);
            return MessageFormat.format(sString, sParam);
        }
        catch (MissingResourceException mreHistoryText) {
            ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return MessageFormat.format(sString, sParam);
            }
            catch (MissingResourceException mreHistoryMsg) {
                return sKey;
            }
        }
    }

    public static String getVersionLocaleString(String sKey, Object[] asParams) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleText = ResourceBundle.getBundle(S_WASPRODUCT_TEXT_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleText.getString(sKey);
            return MessageFormat.format(sString, asParams);
        }
        catch (MissingResourceException mreProductText) {
            ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return MessageFormat.format(sString, asParams);
            }
            catch (MissingResourceException mreProductMsg) {
                return sKey;
            }
        }
    }

    public static String getHistoryLocaleString(String sKey, Object[] asParams) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleText = ResourceBundle.getBundle(S_WASHISTORY_TEXT_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleText.getString(sKey);
            return MessageFormat.format(sString, asParams);
        }
        catch (MissingResourceException mreProductText) {
            ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return MessageFormat.format(sString, asParams);
            }
            catch (MissingResourceException mreProductMsg) {
                return sKey;
            }
        }
    }

    public static String getVersionLocaleString(String sKey) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleText = ResourceBundle.getBundle(S_WASPRODUCT_TEXT_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleText.getString(sKey);
            return sString;
        }
        catch (MissingResourceException mreProductText) {
            ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return sString;
            }
            catch (MissingResourceException mreProductMsg) {
                return sKey;
            }
        }
    }

    public static String getHistoryLocaleString(String sKey) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleText = ResourceBundle.getBundle(S_WASHISTORY_TEXT_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleText.getString(sKey);
            return sString;
        }
        catch (MissingResourceException mreProductText) {
            ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return sString;
            }
            catch (MissingResourceException mreProductMsg) {
                return sKey;
            }
        }
    }

    public static String getLocaleMsgString(String sKey, Object sParam) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleMsg.getString(sKey);
            return MessageFormat.format(sString, sParam);
        }
        catch (MissingResourceException mreProductMsg) {
            resourcebundleMsg = ResourceBundle.getBundle(S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return MessageFormat.format(sString, sParam);
            }
            catch (MissingResourceException mreHistoryMsg) {
                return sKey;
            }
        }
    }

    public static String getLocaleMsgString(String sKey, Object[] asParams) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleMsg.getString(sKey);
            return MessageFormat.format(sString, asParams);
        }
        catch (MissingResourceException mreProductMsg) {
            resourcebundleMsg = ResourceBundle.getBundle(S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return MessageFormat.format(sString, asParams);
            }
            catch (MissingResourceException mreHistoryMsg) {
                return sKey;
            }
        }
    }

    public static String getLocaleMsgString(String sKey) {
        if (sKey == null) {
            return sKey;
        }
        ResourceBundle resourcebundleMsg = ResourceBundle.getBundle(S_WASPRODUCT_MSG_RESOURCE_BUNDLE_NAME);
        try {
            String sString = resourcebundleMsg.getString(sKey);
            return sString;
        }
        catch (MissingResourceException mreProductMsg) {
            resourcebundleMsg = ResourceBundle.getBundle(S_WASHISTORY_MSG_RESOURCE_BUNDLE_NAME);
            try {
                String sString = resourcebundleMsg.getString(sKey);
                return sString;
            }
            catch (MissingResourceException mreHistoryMsg) {
                return sKey;
            }
        }
    }

    public static String removeMessageKeys(String sMessage) {
        Matcher matcher = messageKeyPattern.matcher(sMessage);
        if (matcher.find()) {
            return matcher.replaceAll(S_EMPTY);
        }
        return sMessage;
    }
}

