/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.metadata;

import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import com.ibm.websphere.product.xml.component.component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class WASComponent {
    private WASDirectoryLogger logger;
    private String installRoot = null;
    private String componentName = null;
    private String specVersion = null;
    private String buildVersion = null;
    private String buildDate = null;
    private Vector componentUpdateListThisComponent = new Vector();
    private static final String S_COMPONENT_NAME_FIELD_TAG = "name";
    private static final String S_COMPONENT_SPEC_VERSION_FIELD_TAG = "spec-version";
    private static final String S_COMPONENT_BUILD_VERSION_FIELD_TAG = "build-version";
    private static final String S_COMPONENT_BUILD_DATE_FIELD_TAG = "build-date";
    private static final String S_PATH_COMPONENT = "component";
    private component oldComponentOjbect = new component();

    public WASComponent(InputStream inputStream, EntityResolver entityResolver, String installRoot) throws IOException, ParserConfigurationException, SAXException {
        this.logger = WASDirectoryLogger.getWASDirectoryLogger(installRoot);
        this.logger.entering(this.getClass().getName(), "WASComponent");
        this.setInstallRoot(installRoot);
        this.parseComponentFileInputStream(inputStream, entityResolver);
        this.setComponentObject();
        this.logger.exiting(this.getClass().getName(), "WASComponent");
    }

    protected void parseComponentFileInputStream(InputStream inputStream, EntityResolver entityResolver) throws IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseComponentFileInputStream");
        if (inputStream != null) {
            this.logger.logThisMessage(Level.FINER, this.getClass().getName(), "parseComponentFileInputStream", "Input stream is not null, ready to parse.");
            try {
                SimpleXMLParser sxpFile = new SimpleXMLParser(inputStream, false, entityResolver);
                Vector nodeContainer = sxpFile.getNodes(S_PATH_COMPONENT);
                for (int i = 0; i < nodeContainer.size(); ++i) {
                    Node nodeThis = (Node)nodeContainer.elementAt(i);
                    this.setComponentName(SimpleXMLParser.getNodeAttributeValue(nodeThis, S_COMPONENT_NAME_FIELD_TAG));
                    this.setBuildDate(SimpleXMLParser.getNodeAttributeValue(nodeThis, S_COMPONENT_BUILD_DATE_FIELD_TAG));
                    this.setBuildVersion(SimpleXMLParser.getNodeAttributeValue(nodeThis, S_COMPONENT_BUILD_VERSION_FIELD_TAG));
                    this.setSpecVersion(SimpleXMLParser.getNodeAttributeValue(nodeThis, S_COMPONENT_SPEC_VERSION_FIELD_TAG));
                }
                sxpFile = null;
            }
            catch (IOException ioe) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFileInputStream", ioe.getMessage(), ioe);
                throw ioe;
            }
            catch (ParserConfigurationException pce) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFileInputStream", pce.getMessage(), pce);
                throw pce;
            }
            catch (SAXException saxe) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFileInputStream", saxe.getMessage(), saxe);
                throw saxe;
            }
        } else {
            this.logger.logThisMessage(Level.SEVERE, this.getClass().getName(), "parseComponentFileInputStream", "FileInputStream for component file is null!");
        }
        this.logger.exiting(this.getClass().getName(), "parseComponentFileInputStream");
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    protected void setBuildDate(String buildDate) {
        this.buildDate = buildDate;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setBuildDate", "Build date: " + buildDate);
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    protected void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setBuildVersion", "Build version is: " + buildVersion);
    }

    public String getComponentName() {
        return this.componentName;
    }

    protected void setComponentName(String componentName) {
        this.componentName = componentName;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setComponentName", "Component name is: " + componentName);
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    protected void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setSpecVersion", "Spec version is: " + specVersion);
    }

    public WASComponentUpdate[] getComponentUpdateList() {
        return this.componentUpdateListThisComponent.toArray(new WASComponentUpdate[this.componentUpdateListThisComponent.size()]);
    }

    protected void addComponentUpdateToList(WASComponentUpdate thisComponentUpdate) {
        if (thisComponentUpdate != null) {
            this.componentUpdateListThisComponent.add(thisComponentUpdate);
            this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "addComponentUpdateToList", "Add component update with maintenance package ID: " + thisComponentUpdate.getMaintenancePackageID());
        }
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    protected void setInstallRoot(String installRoot) {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setInstallRoot", "installRoot is: " + installRoot);
        this.installRoot = installRoot;
    }

    public component getComponent() {
        return this.oldComponentOjbect;
    }

    private void setComponentObject() {
        this.logger.logThisMessage(Level.FINEST, this.getClass().getName(), "setComponentObject", "Set component object with component name: " + this.componentName);
        this.oldComponentOjbect.setBuildDate(this.buildDate);
        this.oldComponentOjbect.setBuildVersion(this.buildVersion);
        this.oldComponentOjbect.setName(this.componentName);
        this.oldComponentOjbect.setSpecVersion(this.specVersion);
    }
}

