/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.multibroker.drsclient;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class DRSEncryptionKind
extends AbstractEnumerator {
    public static final int NONE = 0;
    public static final int DES = 1;
    public static final int TRIPLE_DES = 2;
    public static final DRSEncryptionKind NONE_LITERAL = new DRSEncryptionKind(0, "NONE", "NONE");
    public static final DRSEncryptionKind DES_LITERAL = new DRSEncryptionKind(1, "DES", "DES");
    public static final DRSEncryptionKind TRIPLE_DES_LITERAL = new DRSEncryptionKind(2, "TRIPLE_DES", "TRIPLE_DES");
    private static final DRSEncryptionKind[] VALUES_ARRAY = new DRSEncryptionKind[]{NONE_LITERAL, DES_LITERAL, TRIPLE_DES_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static DRSEncryptionKind get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DRSEncryptionKind result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DRSEncryptionKind getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DRSEncryptionKind result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DRSEncryptionKind get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return DES_LITERAL;
            }
            case 2: {
                return TRIPLE_DES_LITERAL;
            }
        }
        return null;
    }

    private DRSEncryptionKind(int value, String name, String literal) {
        super(value, name, literal);
    }
}

