/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.websphere.ant.tasks.Messages;
import com.ibm.ws.ant.utils.OsUtils;
import com.ibm.ws.ant.utils.ProjectUtils;
import com.ibm.ws.ant.utils.StrUtils;
import com.ibm.ws.ant.utils.WasUtils;
import com.ibm.ws.management.AdminServiceImpl;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class WsEjbDeploy
extends Task {
    Path deployClasspath;
    String wasHome;
    boolean codegen = false;
    String dbname;
    String dbschema;
    String dbvendor;
    boolean dynamic = false;
    boolean keepGenerated = false;
    boolean ignoreErrors = false;
    boolean quiet = false;
    boolean noValidate = false;
    boolean noWarnings = false;
    boolean noInform = false;
    String rmicOptions;
    boolean compatible35 = false;
    boolean sqlj = false;
    boolean trace = false;
    boolean log = false;
    File inputJar = null;
    File workingDirectory = null;
    File outputJar = null;
    boolean failonerror = false;
    String instance;
    String jvmMaxMemory = "256M";
    private Commandline systemProperties = new Commandline();
    String jdkComplianceLevel;
    private boolean debug = false;
    protected final WasUtils wasUtils = new WasUtils();
    private static final String EJBCALLER = "EJBCALLER";
    private static final String WEBSPHERE = "WEBSPHERE";

    public Path createClasspath() {
        if (this.deployClasspath == null) {
            this.deployClasspath = new Path(this.getProject());
        }
        return this.deployClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setClasspath(Path path) {
        if (this.deployClasspath == null) {
            this.deployClasspath = path;
        } else {
            this.deployClasspath.append(path);
        }
    }

    public void setCodegen(boolean bl) {
        this.codegen = bl;
    }

    public void setCompatible35(boolean bl) {
        this.compatible35 = bl;
    }

    public void setSqlj(boolean bl) {
        this.sqlj = bl;
    }

    public void setDbname(String string) {
        this.dbname = string;
    }

    public void setDbschema(String string) {
        this.dbschema = string;
    }

    public void setDbvendor(String string) {
        this.dbvendor = string;
    }

    public void setIgnoreErrors(boolean bl) {
        this.ignoreErrors = bl;
    }

    public void setInputJar(File file) {
        this.inputJar = file;
    }

    public void setKeepGenerated(boolean bl) {
        this.keepGenerated = bl;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public void setNoInform(boolean bl) {
        this.noInform = bl;
    }

    public void setNoValidate(boolean bl) {
        this.noValidate = bl;
    }

    public void setNoWarnings(boolean bl) {
        this.noWarnings = bl;
    }

    public void setOutputJar(File file) {
        this.outputJar = file;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void setRmicOptions(String string) {
        this.rmicOptions = string;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setLog(boolean bl) {
        this.log = bl;
    }

    public void setJdkComplianceLevel(String string) {
        this.jdkComplianceLevel = string;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    public void setWasHome(String string) {
        this.wasHome = string;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public void setJvmMaxMemory(String string) {
        this.jvmMaxMemory = string;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void execute() throws BuildException {
        String[] stringArray;
        Object object;
        Object object2;
        Path path;
        Path path2;
        if (this.inputJar == null) {
            throw new BuildException(Messages.getString("Required_Argument_[inputJar]_not_specified._1"));
        }
        if (this.workingDirectory == null) {
            this.workingDirectory = new File(this.getProject().getBaseDir().getAbsolutePath() + File.separator + "_tempDeployDir");
        }
        if (this.outputJar == null) {
            throw new BuildException(Messages.getString("Required_Argument_[outputJar]_not_specified._3"));
        }
        if (!this.inputJar.exists()) {
            throw new BuildException(Messages.getString("Input_Jar_does_not_exist___4") + this.inputJar.getAbsolutePath());
        }
        if (!this.workingDirectory.exists()) {
            this.log(Messages.getString("Working_Directory_does_not_exist._Creating._5"), 2);
            this.workingDirectory.mkdirs();
        } else if (!this.workingDirectory.isDirectory()) {
            throw new BuildException(Messages.getString("Working_Directory_is_not_a_directory___6") + this.workingDirectory.getAbsolutePath());
        }
        Java java = new Java();
        java.setProject(this.getProject());
        java.setTaskName("wsejbdeploy");
        java.setOwningTarget(this.getOwningTarget());
        java.setLocation(this.getLocation());
        if (this.wasHome == null) {
            this.wasHome = WasUtils.getDefaultWasInstallHome((Project)this.getProject());
            if (this.wasHome == null) {
                ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("Unable_to_determine_WAS_Home_directory._Please_use_the_wasHome_task_attribute_or_set_the_was.root_System_property._25"));
                return;
            }
        }
        this.wasHome = StrUtils.cleanPath((String)this.wasHome, (boolean)false);
        Path path3 = java.createClasspath();
        String string = System.getProperty("was.ant.extra.prefix.classpath");
        if (string == null || string.length() <= 0) {
            string = this.wasUtils.getSCLAttr("WAS_ANT_EXTRA_PREFIX_CLASSPATH");
        }
        Path path4 = new Path(this.getProject(), string);
        path3.addExisting(path4);
        if (OsUtils.isZOS()) {
            path2 = new Path(this.getProject(), this.wasHome + "/deploytool/itp/batch.jar");
            path3.addExisting(path2);
            path = new Path(this.getProject(), this.wasHome + "/lib");
            path3.addExisting(path);
        }
        path2 = new Path(this.getProject(), this.wasHome + "/deploytool/itp/batch2.jar");
        path3.addExisting(path2);
        path = new Path(this.getProject(), this.wasHome + "/deploytool/itp/batch2_nl1.jar");
        path3.addExisting(path);
        String string2 = System.getProperty("was.ant.extra.classpath");
        if (string2 == null || string2.length() <= 0) {
            string2 = this.wasUtils.getSCLAttr("WAS_ANT_EXTRA_CLASSPATH");
        }
        Path path5 = new Path(this.getProject(), string2);
        path3.addExisting(path5);
        if (OsUtils.isZOS()) {
            AdminServiceImpl.getPlatformUtils().setenv(EJBCALLER, WEBSPHERE);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.wasHome);
        stringBuffer.append("/deploytool/itp/batchboot.jar");
        stringBuffer.append(File.pathSeparator);
        if (OsUtils.isOS400()) {
            stringBuffer.append(this.wasHome);
            stringBuffer.append("/java/ext/iwsorbutil.jar");
            stringBuffer.append(File.pathSeparator);
        }
        Path path6 = new Path(this.getProject(), stringBuffer.toString());
        Commandline.Argument argument = null;
        java.setClassname("com.ibm.etools.ejbdeploy.EJBDeploy");
        java.setDir(this.workingDirectory);
        java.setFailonerror(this.failonerror);
        java.setFork(true);
        if (!OsUtils.isOS400()) {
            java.setMaxmemory(this.jvmMaxMemory);
        }
        if (this.instance == null) {
            this.instance = WasUtils.getInstanceName();
        }
        this.wasUtils.parseSetupCmdLine(this.wasHome, this.instance, this.getProject(), this.failonerror);
        argument = java.createJvmarg();
        argument.setValue("-Dwebsphere.lib.dir=" + this.wasHome + "/lib");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.wasHome);
        stringBuffer2.append("/plugins");
        stringBuffer2.append(File.pathSeparator);
        stringBuffer2.append(this.wasUtils.getSCLAttr("WAS_EXT_DIRS"));
        String string3 = this.wasUtils.getSCLAttr("ITP_LOC");
        if (string3 == null) {
            string3 = this.wasHome + File.separator + "deploytool" + File.separator + "itp";
        }
        argument = java.createJvmarg();
        argument.setValue("-Ditp.loc=" + string3);
        if (OsUtils.isOS400()) {
            object2 = System.getProperty("java.vm.name");
            object = null;
            if (object2 != null && ((String)object2).equalsIgnoreCase("Classic VM")) {
                object = this.wasUtils.getSCLAttr("WAS_OS400_ENDORSED_DIRS");
                if (object != null) {
                    argument = java.createJvmarg();
                    argument.setValue("-Djava.endorsed.dirs=" + (String)object);
                }
            } else {
                object = this.wasUtils.getSCLAttr("WAS_OS400_ENDORSED_J9_DIRS");
                if (object != null) {
                    argument = java.createJvmarg();
                    argument.setValue("-Djava.endorsed.dirs=" + (String)object);
                }
            }
        }
        argument = java.createJvmarg();
        argument.setValue("-Dwas.install.root=" + this.wasHome);
        argument = java.createJvmarg();
        argument.setValue("-Dws.ext.dirs=" + stringBuffer2.toString());
        argument = java.createJvmarg();
        argument.setValue("-Dorg.osgi.framework.bootdelegation=*");
        if (OsUtils.isZOS()) {
            argument = java.createJvmarg();
            argument.setValue("-Xnoargsconversion");
            argument = java.createJvmarg();
            argument.setValue("-Dfile.encoding=ISO-8859-1");
            argument = java.createJvmarg();
            argument.setValue("-Dws.output.encoding=Cp1047");
        } else {
            argument = java.createJvmarg();
            argument.setValue("-Dws.output.encoding=console");
        }
        argument = java.createJvmarg();
        argument.setValue("-Xbootclasspath/a:" + path6);
        argument = java.createJvmarg();
        argument.setValue("-Dcom.ibm.sse.model.structuredbuilder=\"off\"");
        if (OsUtils.isOS400()) {
            argument = java.createJvmarg();
            argument.setValue("-Dos400.file.create.auth=*RX");
            argument = java.createJvmarg();
            argument.setValue("-Dos400.dir.create.auth=*RX");
        }
        object2 = new Vector();
        ((Vector)object2).addElement(this.inputJar.getAbsolutePath());
        ((Vector)object2).addElement(this.workingDirectory.getAbsolutePath());
        ((Vector)object2).addElement(this.outputJar.getAbsolutePath());
        if (this.deployClasspath != null) {
            ((Vector)object2).addElement("-cp");
            ((Vector)object2).addElement(this.deployClasspath.toString());
        }
        if (this.codegen) {
            ((Vector)object2).addElement("-codegen");
        }
        if (this.dbname != null) {
            ((Vector)object2).addElement("-dbname");
            ((Vector)object2).addElement(this.dbname);
        }
        if (this.dbschema != null) {
            ((Vector)object2).addElement("-dbschema");
            ((Vector)object2).addElement(this.dbschema);
        }
        if (this.dbvendor != null) {
            ((Vector)object2).addElement("-dbvendor");
            ((Vector)object2).addElement(this.dbvendor);
        }
        if (this.jdkComplianceLevel != null) {
            ((Vector)object2).addElement("-complianceLevel");
            ((Vector)object2).addElement(this.jdkComplianceLevel);
        }
        if (this.keepGenerated) {
            ((Vector)object2).addElement("-keep");
        }
        if (this.dynamic) {
            ((Vector)object2).addElement("-dynamic");
        }
        if (this.ignoreErrors) {
            ((Vector)object2).addElement("-ignoreErrors");
        }
        if (this.quiet) {
            ((Vector)object2).addElement("-quiet");
        }
        if (this.noValidate) {
            ((Vector)object2).addElement("-novalidate");
        }
        if (this.noWarnings) {
            ((Vector)object2).addElement("-nowarn");
        }
        if (this.noInform) {
            ((Vector)object2).addElement("-noinform");
        }
        if (this.rmicOptions != null) {
            ((Vector)object2).addElement("-rmic");
            ((Vector)object2).addElement(this.rmicOptions);
        }
        if (this.compatible35) {
            ((Vector)object2).addElement("-35");
        }
        if (this.sqlj) {
            ((Vector)object2).addElement("-sqlj");
        }
        if (this.trace) {
            ((Vector)object2).addElement("-trace");
        }
        if (this.trace) {
            ((Vector)object2).addElement("-log");
        }
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            stringArray = java.createArg();
            stringArray.setValue((String)object.next());
        }
        stringArray = this.systemProperties.getArguments();
        for (int i = 0; i < stringArray.length; ++i) {
            java.createJvmarg().setValue("-D" + stringArray[i]);
        }
        if (this.isDebug()) {
            String[] stringArray2 = java.getCommandLine().getCommandline();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("jvm args > " + stringArray2[i]);
            }
        }
        java.execute();
    }

    public Commandline.Argument createSystemProperty() {
        return this.systemProperties.createArgument();
    }
}

