/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.file;

import com.ibm.io.file.WindowsJNILibrary;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

class WindowsNativeFile {
    private static boolean isImplemented = false;
    private static Integer mutex = new Integer(0);
    private static boolean emitSearch = false;

    WindowsNativeFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean initializeLibrary(File file) {
        Integer n = mutex;
        synchronized (n) {
            block16: {
                if (!isImplemented && file != null) {
                    try {
                        if (!file.exists()) break block16;
                        try {
                            WindowsJNILibrary windowsJNILibrary = new WindowsJNILibrary(file);
                            if (windowsJNILibrary.isCompatible()) {
                                System.load(file.getAbsolutePath());
                                isImplemented = true;
                                if (emitSearch) {
                                    System.out.println("LOGGING: NativeFile load attempt successful.");
                                }
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (emitSearch) {
                                System.out.println("LOGGING: NativeFile load attempt failed due to FileNotFoundException on examining JNI library.  Exception: " + fileNotFoundException.toString());
                            }
                        }
                        catch (IOException iOException) {
                            if (emitSearch) {
                                System.out.println("LOGGING: NativeFile load attempt failed due to IO error on examining JNI library.  Exception: " + iOException.toString());
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            if (emitSearch) {
                                System.out.println("LOGGING: NativeFile load attempt failed due to NullPointerException on examining JNI library.  Exception: " + nullPointerException.toString());
                            }
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (emitSearch) {
                            System.out.println("LOGGING: NativeFile load attempt through initializeLibrary(File) to load file: [" + file.getAbsolutePath() + "] failed.tandard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                        }
                        isImplemented = false;
                    }
                }
            }
        }
        return isImplemented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeLibrary(File file, String string, boolean bl) {
        Integer n = mutex;
        synchronized (n) {
            if (!isImplemented && file != null) {
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile load attempt through initializeLibrary(File,String,boolean) in directory: " + file.getAbsolutePath() + "].");
                }
                if (string == null) {
                    string = System.mapLibraryName("NativeFile");
                    if (emitSearch) {
                        System.out.println("LOGGING: NativeFile mapped library name to: [" + string + "].");
                    }
                    if (!(isImplemented = WindowsNativeFile.loadLibrarySearch(file, string, bl))) {
                        string = System.mapLibraryName("NativeFile64");
                        if (emitSearch) {
                            System.out.println("LOGGING: NativeFile mapped for a possible 64 bit library name to: [" + string + "] if 64 and 32 bit libraries were stored in the same directory and required renames to co-exist.");
                        }
                        isImplemented = WindowsNativeFile.loadLibrarySearch(file, string, bl);
                    }
                } else {
                    isImplemented = WindowsNativeFile.loadLibrarySearch(file, string, bl);
                }
            }
        }
        return isImplemented;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean loadLibrarySearch(File file, String string, boolean bl) {
        boolean bl2 = false;
        if (!file.exists()) return bl2;
        if (!file.isDirectory()) return bl2;
        File file2 = new File(file, string);
        if (file2.exists()) {
            try {
                if (!file2.exists()) return bl2;
                try {
                    WindowsJNILibrary windowsJNILibrary = new WindowsJNILibrary(file2);
                    if (!windowsJNILibrary.isCompatible()) return bl2;
                    System.load(file2.getAbsolutePath());
                    bl2 = true;
                    if (!emitSearch) return bl2;
                    System.out.println("LOGGING: NativeFile load attempt successful.");
                    return bl2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!emitSearch) return bl2;
                    System.out.println("LOGGING: NativeFile load attempt failed due to FileNotFoundException on examining JNI library.  Exception: " + fileNotFoundException.toString());
                    return bl2;
                }
                catch (IOException iOException) {
                    if (!emitSearch) return bl2;
                    System.out.println("LOGGING: NativeFile load attempt failed due to IO error on examining JNI library.  Exception: " + iOException.toString());
                    return bl2;
                }
                catch (NullPointerException nullPointerException) {
                    if (!emitSearch) return bl2;
                    System.out.println("LOGGING: NativeFile load attempt failed due to NullPointerException on examining JNI library.  Exception: " + nullPointerException.toString());
                    return bl2;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.out.println("LOGGING: NativeFile load attempt through initializeLibrary(File,String,boolean) to load file: [" + file2.getAbsolutePath() + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                if (emitSearch) {
                    System.out.println("LOGGING: NativeFile load attempt through initializeLibrary(File,String,boolean) to load file: [" + file2.getAbsolutePath() + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                }
                if (!bl) return false;
                File[] fileArray = file.listFiles();
                if (fileArray == null) return bl2;
                if (fileArray.length <= 0) return bl2;
                int n = 0;
                while (n < fileArray.length) {
                    File file3 = fileArray[n];
                    if (file3.isDirectory()) {
                        bl2 = WindowsNativeFile.initializeLibrary(file3, string, bl);
                    }
                    if (bl2) return bl2;
                    ++n;
                }
                return bl2;
            }
        } else {
            if (!bl) return bl2;
            File[] fileArray = file.listFiles();
            if (fileArray == null) return bl2;
            if (fileArray.length <= 0) return bl2;
            int n = 0;
            while (n < fileArray.length) {
                File file4 = fileArray[n];
                if (file4.isDirectory()) {
                    bl2 = WindowsNativeFile.initializeLibrary(file4, string, bl);
                }
                if (bl2) return bl2;
                ++n;
            }
            return bl2;
        }
    }

    protected static native void setPermissions(String var0, int var1);

    protected static native String[] getMountedFileSystems();

    protected static native long getFileSystemSize(String var0);

    protected static native long getFreeSpace(String var0);

    protected static boolean isImplemented() {
        return isImplemented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Integer n = mutex;
        synchronized (n) {
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("com.ibm.io.file.nativefile.emitlibrarysearch");
            if (string2 != null && "true".equalsIgnoreCase(string2)) {
                emitSearch = true;
            }
            if (string.toLowerCase(Locale.ENGLISH).startsWith("window")) {
                block61: {
                    Object object;
                    File file;
                    String string3;
                    String string4;
                    String string5;
                    block59: {
                        string5 = System.mapLibraryName("NativeFile");
                        string4 = System.mapLibraryName("NativeFile64");
                        string3 = System.getProperty("com.ibm.io.file.nativefile.libdir");
                        String string6 = System.getProperty("com.ibm.io.file.nativefile.library");
                        if (string6 != null) {
                            try {
                                file = new File(string6);
                                if (file.exists()) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt using full library name: [" + file.getAbsolutePath() + "]");
                                    }
                                    try {
                                        object = new WindowsJNILibrary(file);
                                        if (!((WindowsJNILibrary)object).isCompatible()) break block59;
                                        System.load(file.getAbsolutePath());
                                        isImplemented = true;
                                        if (emitSearch) {
                                            System.out.println("LOGGING: NativeFile load attempt successful.");
                                        }
                                        break block59;
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        if (emitSearch) {
                                            System.out.println("LOGGING: NativeFile load attempt failed due to FileNotFoundException on examining JNI library.  Exception: " + fileNotFoundException.toString());
                                        }
                                        break block59;
                                    }
                                    catch (IOException iOException) {
                                        if (emitSearch) {
                                            System.out.println("LOGGING: NativeFile load attempt failed due to IO error on examining JNI library.  Exception: " + iOException.toString());
                                        }
                                        break block59;
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        if (emitSearch) {
                                            System.out.println("LOGGING: NativeFile load attempt failed due to NullPointerException on examining JNI library.  Exception: " + nullPointerException.toString());
                                        }
                                        break block59;
                                    }
                                }
                                isImplemented = false;
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                if (emitSearch) {
                                    System.out.println("LOGGING: NativeFile load attempt using full library name failed.  Exception reported was: " + unsatisfiedLinkError.toString());
                                }
                                isImplemented = false;
                            }
                        }
                    }
                    if (!isImplemented && string3 != null) {
                        WindowsJNILibrary windowsJNILibrary;
                        block60: {
                            try {
                                file = new File(string3);
                                if (!file.exists()) break block60;
                                if (emitSearch) {
                                    System.out.println("LOGGING: NativeFile load attempt using search directory: [" + file.getAbsolutePath() + "] and library name: [" + string5 + "]");
                                }
                                if (!((File)(object = new File(file.getAbsolutePath() + File.separator + string5))).exists()) break block60;
                                try {
                                    windowsJNILibrary = new WindowsJNILibrary((File)object);
                                    if (windowsJNILibrary.isCompatible()) {
                                        System.load(((File)object).getAbsolutePath());
                                        isImplemented = true;
                                        if (emitSearch) {
                                            System.out.println("LOGGING: NativeFile load attempt successful.");
                                        }
                                    }
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt failed due to FileNotFoundException on examining JNI library.  Exception: " + fileNotFoundException.toString());
                                    }
                                }
                                catch (IOException iOException) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt failed due to IO error on examining JNI library.  Exception: " + iOException.toString());
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt failed due to NullPointerException on examining JNI library.  Exception: " + nullPointerException.toString());
                                    }
                                }
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                if (emitSearch) {
                                    System.out.println("LOGGING: NativeFile load attempt using search directory failed.  Exception was: " + unsatisfiedLinkError.toString());
                                }
                                isImplemented = false;
                            }
                        }
                        if (!isImplemented) {
                            try {
                                file = new File(string3);
                                if (!file.exists()) break block61;
                                if (emitSearch) {
                                    System.out.println("LOGGING: NativeFile load attempt using search directory: [" + file.getAbsolutePath() + "] and library name: [" + string5 + "]");
                                }
                                if (!((File)(object = new File(file.getAbsolutePath() + File.separator + string4))).exists()) break block61;
                                try {
                                    windowsJNILibrary = new WindowsJNILibrary((File)object);
                                    if (windowsJNILibrary.isCompatible()) {
                                        System.load(((File)object).getAbsolutePath());
                                        isImplemented = true;
                                        if (emitSearch) {
                                            System.out.println("LOGGING: NativeFile load attempt successful.");
                                        }
                                    }
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt failed due to FileNotFoundException on examining JNI library.  Exception: " + fileNotFoundException.toString());
                                    }
                                }
                                catch (IOException iOException) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt failed due to IO error on examining JNI library.  Exception: " + iOException.toString());
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    if (emitSearch) {
                                        System.out.println("LOGGING: NativeFile load attempt failed due to NullPointerException on examining JNI library.  Exception: " + nullPointerException.toString());
                                    }
                                }
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                if (emitSearch) {
                                    System.out.println("LOGGING: NativeFile load attempt using search directory failed.  Exception was: " + unsatisfiedLinkError.toString());
                                }
                                isImplemented = false;
                            }
                        }
                    }
                }
                if (!isImplemented) {
                    try {
                        if (emitSearch) {
                            System.out.println("LOGGING: NativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "]");
                        }
                        System.loadLibrary("NativeFile");
                        isImplemented = true;
                        if (emitSearch) {
                            System.out.println("LOGGING: NativeFile load attempt successful.");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (emitSearch) {
                            System.out.println("LOGGING: NativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                        }
                        isImplemented = false;
                    }
                    if (!isImplemented) {
                        try {
                            if (emitSearch) {
                                System.out.println("LOGGING: NativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "]");
                            }
                            System.loadLibrary("NativeFile64");
                            isImplemented = true;
                            if (emitSearch) {
                                System.out.println("LOGGING: NativeFile load attempt successful.");
                            }
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (emitSearch) {
                                System.out.println("LOGGING: NativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                            }
                            isImplemented = false;
                        }
                    }
                }
            }
        }
    }
}

