/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util.bidi;

import com.ibm.etools.marshall.util.bidi.BidiFlagSet;
import com.ibm.etools.marshall.util.bidi.BidiOrder;
import com.ibm.etools.marshall.util.bidi.BidiShape;
import com.ibm.etools.marshall.util.bidi.BidiTransform;

public class BidiText {
    private static final String copyright = "(c) Copyright IBM Corporation 2002,2005.";
    public BidiFlagSet flags;
    public char[] data;
    public int offset;
    public int count;

    public BidiText() {
        this.flags = new BidiFlagSet();
    }

    public BidiText(BidiFlagSet bidiFlagSet) {
        this.flags = bidiFlagSet;
    }

    public BidiText(BidiFlagSet bidiFlagSet, char[] cArray) {
        this(bidiFlagSet, cArray, 0, cArray.length, cArray.length);
    }

    public BidiText(BidiFlagSet bidiFlagSet, char[] cArray, int n, int n2, int n3) {
        this.flags = new BidiFlagSet(bidiFlagSet);
        this.data = new char[n3];
        System.arraycopy(cArray, n, this.data, 0, n2);
        this.count = n2;
    }

    public BidiText(BidiFlagSet bidiFlagSet, String string) {
        this.flags = new BidiFlagSet(bidiFlagSet);
        this.count = string.length();
        this.data = new char[this.count];
        string.getChars(0, this.count, this.data, 0);
    }

    public boolean equals(BidiText bidiText) {
        if (bidiText == null) {
            return false;
        }
        if (this.count != bidiText.count) {
            return false;
        }
        if (this.flags.value != bidiText.flags.value) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.data[this.offset + i] == bidiText.data[bidiText.offset + i]) continue;
            return false;
        }
        return true;
    }

    public void setCharsRef(char[] cArray, int n, int n2) {
        this.data = cArray;
        this.offset = n;
        this.count = n2;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.data, this.offset, cArray, 0, this.count);
        return cArray;
    }

    public String toString() {
        return new String(this.data, this.offset, this.count);
    }

    public BidiText transform(BidiFlagSet bidiFlagSet) {
        BidiTransform bidiTransform = new BidiTransform();
        bidiTransform.flags.setAllFlags(bidiFlagSet);
        return this.transform(bidiTransform);
    }

    public BidiText transform(BidiTransform bidiTransform) {
        BidiText bidiText = new BidiText();
        bidiText.flags.setAllFlags(bidiTransform.flags);
        bidiText.data = new char[this.count];
        if (bidiTransform.myOrder == null) {
            bidiTransform.myOrder = new BidiOrder();
        }
        bidiTransform.myOrder.order(this, bidiText, bidiTransform);
        if (this.flags.getText() != bidiText.flags.getText()) {
            if (bidiTransform.myShape == null) {
                bidiTransform.myShape = new BidiShape();
                bidiTransform.flags1 = new BidiFlagSet();
                bidiTransform.flags2 = new BidiFlagSet();
            }
            bidiTransform.flags1.setAllFlags(this.flags);
            bidiTransform.flags2.setAllFlags(bidiText.flags);
            bidiText.data = bidiTransform.myShape.shape(bidiTransform.flags1, bidiTransform.flags2, bidiText.data, bidiTransform.options);
            bidiText.count = bidiText.data.length;
        }
        return bidiText;
    }
}

