/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.wsdl.extensions.physicalrep.properties;

import com.ibm.etools.ctc.physicalrep.PhysicalrepPlugin;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.ExternalDecimalTD;
import com.ibm.etools.typedescriptor.FloatTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.IntegerTD;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;
import java.math.BigDecimal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class RecognitionCellEditor
extends TextCellEditor
implements ICellEditorValidator {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private XSDComponent xsd = null;
    private SimpleInstanceTD simpleTD = null;
    private static final int _MIN = 1;
    private static final int _MAX = 2;

    public RecognitionCellEditor(Composite composite, XSDComponent xSDComponent, InstanceTDBase instanceTDBase) {
        super(composite);
        this.xsd = xSDComponent;
        int n = -1;
        if (instanceTDBase instanceof SimpleInstanceTD) {
            this.simpleTD = (SimpleInstanceTD)instanceTDBase;
            BaseTDType baseTDType = this.simpleTD.getSharedType();
            if (baseTDType instanceof StringTD) {
                if (!instanceTDBase.isSetAttributeInBit()) {
                    n = Integer.valueOf(instanceTDBase.getContentSize());
                }
            } else if (baseTDType instanceof IntegerTD) {
                n = this.getIntegerTextLimit();
            } else if (baseTDType instanceof FloatTD) {
                n = this.getFloatTextLimit();
            } else if (baseTDType instanceof ExternalDecimalTD) {
                n = this.getDecimalTextLimit();
            }
        }
        if (n > 0) {
            this.text.setTextLimit(n);
        }
        this.setValidator(this);
    }

    public String isValid(Object object) {
        if (object == null) {
            return null;
        }
        String string = (String)object;
        if (string.length() > 0 && this.simpleTD != null) {
            BaseTDType baseTDType = this.simpleTD.getSharedType();
            if (baseTDType instanceof IntegerTD) {
                return this.isValidInteger(string);
            }
            if (baseTDType instanceof FloatTD) {
                return this.isValidFloat(string);
            }
            if (baseTDType instanceof ExternalDecimalTD) {
                return this.isValidDecimal(string);
            }
        }
        return null;
    }

    private String isValidInteger(String string) {
        String string2 = null;
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            String string3 = this.getIntMinValue();
            String string4 = this.getIntMaxValue();
            if (string3 != null && string4 != null) {
                BigDecimal bigDecimal2 = new BigDecimal(string3);
                BigDecimal bigDecimal3 = new BigDecimal(string4);
                if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
                    string2 = PhysicalrepPlugin.getResources().getMessage("%_ERROR_OUT_OF_RANGE");
                } else {
                    int n = string4.indexOf(".");
                    int n2 = string.indexOf(".");
                    if (n != -1 && n2 != -1 && string.substring(n2).length() > string4.substring(n).length()) {
                        string2 = PhysicalrepPlugin.getResources().getMessage("%_ERROR_OUT_OF_RANGE");
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = numberFormatException.getMessage();
        }
        return string2;
    }

    private String isValidFloat(String string) {
        String string2 = null;
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            String string3 = this.getFloatMinValue(true);
            String string4 = this.getFloatMaxValue(true);
            if (string3 != null && string4 != null) {
                BigDecimal bigDecimal2 = new BigDecimal(string3);
                BigDecimal bigDecimal3 = new BigDecimal(string4);
                if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
                    string2 = PhysicalrepPlugin.getResources().getMessage("%_ERROR_OUT_OF_RANGE");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = numberFormatException.getMessage();
        }
        return string2;
    }

    private String isValidDecimal(String string) {
        String string2 = null;
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            String string3 = this.getDecimalMinValue();
            String string4 = this.getDecimalMaxValue();
            if (string3 != null && string4 != null) {
                BigDecimal bigDecimal2 = new BigDecimal(string3);
                BigDecimal bigDecimal3 = new BigDecimal(string4);
                if (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0) {
                    string2 = PhysicalrepPlugin.getResources().getMessage("%_ERROR_OUT_OF_RANGE");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = numberFormatException.getMessage();
        }
        return string2;
    }

    private int getIntegerTextLimit() {
        int n = -1;
        String string = this.getIntMinValue();
        String string2 = this.getIntMaxValue();
        if (string != null && string2 != null) {
            n = Math.max(string.length(), string2.length());
        }
        return n;
    }

    private String getIntMinValue() {
        return this.getMinMaxInclusiveFacet(1);
    }

    private String getIntMaxValue() {
        return this.getMinMaxInclusiveFacet(2);
    }

    private int getFloatTextLimit() {
        int n = -1;
        String string = this.getFloatMinValue(false);
        String string2 = this.getFloatMaxValue(false);
        if (string != null && string2 != null) {
            n = Math.max(string.length(), string2.length());
        }
        return n;
    }

    private String getFloatMinValue(boolean bl) {
        String string;
        String string2 = null;
        if (bl) {
            string2 = this.getMinValueForFloatType();
        }
        if ((string = this.getMinMaxInclusiveFacet(1)) != null) {
            string2 = string;
        }
        return string2;
    }

    private String getFloatMaxValue(boolean bl) {
        String string;
        String string2 = null;
        if (bl) {
            string2 = this.getMaxValueForFloatType();
        }
        if ((string = this.getMinMaxInclusiveFacet(2)) != null) {
            string2 = string;
        }
        return string2;
    }

    private String getMinValueForFloatType() {
        int n = Integer.valueOf(this.simpleTD.getSize());
        String string = null;
        switch (n) {
            case 4: {
                string = Float.toString(Float.MIN_VALUE);
                break;
            }
            case 8: {
                string = Double.toString(Double.MIN_VALUE);
                break;
            }
        }
        return string;
    }

    private String getMaxValueForFloatType() {
        int n = Integer.valueOf(this.simpleTD.getSize());
        String string = null;
        switch (n) {
            case 4: {
                string = Float.toString(Float.MAX_VALUE);
                break;
            }
            case 8: {
                string = Double.toString(Double.MAX_VALUE);
                break;
            }
        }
        return string;
    }

    private int getDecimalTextLimit() {
        int n = -1;
        String string = this.getDecimalMinValue();
        String string2 = this.getDecimalMaxValue();
        if (string != null && string2 != null) {
            n = Math.max(string.length(), string2.length());
        }
        return n;
    }

    private String getDecimalMinValue() {
        return this.getMinMaxInclusiveFacet(1);
    }

    private String getDecimalMaxValue() {
        return this.getMinMaxInclusiveFacet(2);
    }

    private String getMinMaxInclusiveFacet(int n) {
        String string = null;
        EList eList = this.getFacets();
        if (eList != null) {
            int n2 = 0;
            while (n2 < eList.size()) {
                Object e = eList.get(n2);
                if (e instanceof XSDMinInclusiveFacet && n == 1) {
                    string = ((XSDMinInclusiveFacet)e).getLexicalValue();
                    break;
                }
                if (e instanceof XSDMaxInclusiveFacet && n == 2) {
                    string = ((XSDMaxInclusiveFacet)e).getLexicalValue();
                    break;
                }
                ++n2;
            }
        }
        return string;
    }

    private EList getFacets() {
        EList eList = null;
        XSDElementDeclaration xSDElementDeclaration = (XSDElementDeclaration)((XSDParticle)this.xsd).getContent();
        XSDTypeDefinition xSDTypeDefinition = xSDElementDeclaration.getTypeDefinition();
        if (xSDTypeDefinition != null && xSDTypeDefinition instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition xSDSimpleTypeDefinition = (XSDSimpleTypeDefinition)xSDTypeDefinition;
            eList = xSDSimpleTypeDefinition.getFacets();
        }
        return eList;
    }
}

