/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.IllegalOperationException;
import java.util.ArrayList;

final class BucketImpl
extends ArrayList
implements Bucket {
    private long hitCount = 0L;
    private static final long serialVersionUID = -8739929064206657681L;

    BucketImpl() {
    }

    public Element findByKey(Object key) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Element element = (Element)this.get(i);
            if (!element.key.equals(key)) continue;
            ++this.hitCount;
            return element;
        }
        return null;
    }

    public Element insertByKey(Object key, Object object) {
        Element element = new Element(key, object);
        this.add(element);
        ++this.hitCount;
        return element;
    }

    public Element discardByKey(Object key) {
        int i = this.findIndexByKey(key);
        Element element = null;
        if (i != -1) {
            element = (Element)this.get(i);
            if (element.pinned > 0) {
                return null;
            }
            this.remove(i);
            ++this.hitCount;
        }
        return element;
    }

    public Element removeByKey(Object key) {
        return this.removeByKey(key, false);
    }

    public Element removeByKey(Object key, boolean dropRef) {
        int i = this.findIndexByKey(key);
        Element element = null;
        if (i != -1) {
            element = (Element)this.get(i);
            if (!dropRef && element.pinned > 0 || dropRef && element.pinned > 1) {
                throw new IllegalOperationException(key, element.pinned);
            }
            this.remove(i);
            ++this.hitCount;
        }
        return element;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    private int findIndexByKey(Object key) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Element element = (Element)this.get(i);
            if (!element.key.equals(key)) continue;
            return i;
        }
        return -1;
    }
}

