/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent6;
import com.ibm.ejs.ras.TraceComponent;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

public class StreamEvent6
extends RasEvent6 {
    private static final int svBasicFormatMaxNameLength = 13;
    private static String svAdvancedPadding = "          ";
    public String ivStringData = null;
    public byte[] ivByteArray = null;
    public char[] ivCharArray = null;
    public Vector ivDataCache = null;

    StreamEvent6(int type, TraceComponent tc, String data) {
        super(type, tc, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivStringData = data;
    }

    StreamEvent6(int type, TraceComponent tc, byte[] data) {
        super(type, tc, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivByteArray = data;
    }

    StreamEvent6(int type, TraceComponent tc, char[] data) {
        super(type, tc, null, null, "", "IBM", "WebSphere", "Application Server", null, false);
        this.ivCharArray = data;
    }

    synchronized void addDataCache(Vector vec) {
        this.ivDataCache = vec;
    }

    synchronized void writeSelfToStream(PrintStream stream, String format, boolean terminate, StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintStream bufStream = new PrintStream(data);
        if ("basic".equals(format)) {
            this.formatHeaderBasic(buffer, formatter, date, fPos);
            bufStream.print(new String(buffer));
        } else {
            this.formatHeaderAdvanced(buffer, formatter, date, fPos);
            bufStream.println(new String(buffer));
            bufStream.print(svAdvancedPadding);
        }
        this.writeDataToStream(bufStream, terminate);
        try {
            bufStream.flush();
            data.writeTo(stream);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    synchronized void writeDataToStream(PrintStream stream, boolean terminate) {
        try {
            if (this.ivStringData != null) {
                stream.print(this.ivStringData);
            }
            if (this.ivCharArray != null) {
                stream.print(this.ivCharArray);
            }
            if (this.ivByteArray != null) {
                stream.write(this.ivByteArray);
            }
            if (this.ivDataCache != null) {
                int size = this.ivDataCache.size();
                for (int i = 0; i < size; ++i) {
                    Object x = this.ivDataCache.elementAt(i);
                    if (x instanceof String) {
                        stream.print((String)x);
                    }
                    if (x instanceof char[]) {
                        stream.print((char[])x);
                    }
                    if (!(x instanceof byte[])) continue;
                    stream.write((byte[])x);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (terminate) {
            stream.println();
        }
    }

    synchronized void writeSelfToStream(PrintWriter writer, String format, boolean terminate, StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        CharArrayWriter data = new CharArrayWriter();
        PrintWriter bufWriter = new PrintWriter(data);
        if ("basic".equals(format)) {
            this.formatHeaderBasic(buffer, formatter, date, fPos);
            bufWriter.print(new String(buffer));
        } else {
            this.formatHeaderAdvanced(buffer, formatter, date, fPos);
            bufWriter.print(new String(buffer));
            bufWriter.print(svAdvancedPadding);
        }
        this.writeDataToStream(bufWriter, terminate);
        try {
            bufWriter.flush();
            data.writeTo(writer);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    synchronized void writeDataToStream(PrintWriter writer, boolean terminate) {
        if (this.ivStringData != null) {
            writer.print(this.ivStringData);
        }
        if (this.ivCharArray != null) {
            writer.print(this.ivCharArray);
        }
        if (this.ivByteArray != null) {
            String x = new String(this.ivByteArray);
            writer.write(x);
        }
        if (this.ivDataCache != null) {
            int size = this.ivDataCache.size();
            for (int i = 0; i < size; ++i) {
                Object x = this.ivDataCache.elementAt(i);
                if (x instanceof String) {
                    writer.print((String)x);
                }
                if (x instanceof char[]) {
                    writer.print((char[])x);
                }
                if (!(x instanceof byte[])) continue;
                String y = new String((byte[])x);
                writer.write(y);
            }
        }
        if (terminate) {
            writer.println();
        }
    }

    public String convertToString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.writeDataToStream(pw, false);
        return sw.toString();
    }

    private void formatHeaderBasic(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        int tmpLen;
        this.formatTimeAndThread(buffer, formatter, date, fPos);
        String name = null;
        int index = this.ivEventSource.lastIndexOf(46) + 1;
        name = index + 13 >= this.ivEventSource.length() ? this.ivEventSource.substring(index) : this.ivEventSource.substring(index, index + 13);
        buffer.append(name);
        for (int i = tmpLen = 13 - name.length(); i > 0; --i) {
            buffer.append(' ');
        }
        try {
            buffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            buffer.append(" Z ");
        }
    }

    private void formatHeaderAdvanced(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatTimeAndThread(buffer, formatter, date, fPos);
        try {
            buffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            buffer.append(" Z ");
        }
        if (this.ivUnitOfWork == null) {
            buffer.append("UOW= ");
        } else {
            buffer.append("UOW=");
            buffer.append(this.ivUnitOfWork);
        }
        buffer.append(" source=");
        buffer.append(this.ivEventSource);
        if (this.ivClassName != null) {
            buffer.append(" class=");
            buffer.append(this.ivClassName);
        }
        if (this.ivMethodName != null) {
            buffer.append(" method=");
            buffer.append(this.ivMethodName);
        }
        buffer.append(" org=");
        buffer.append(this.ivOrganization);
        buffer.append(" prod=");
        buffer.append(this.ivProduct);
        buffer.append(" component=");
        buffer.append(this.ivComponent);
        if (this.ivThreadName != null) {
            buffer.append(" thread=[");
            buffer.append(this.ivThreadName);
            buffer.append("]");
        }
    }

    private void formatTimeAndThread(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        buffer.setLength(0);
        buffer.append('[');
        date.setTime(this.ivTimeStamp);
        formatter.format(date, buffer, fPos);
        buffer.append("] ");
        buffer.append(this.ivThreadId);
        buffer.append(' ');
    }
}

