/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.SharedLogBase;
import com.ibm.ejs.ras.SharedLogHeader;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordHelper;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedAction;
import java.util.Vector;
import java.util.logging.LogRecord;

class SharedLogWriter
extends SharedLogBase
implements WsHandler {
    private static final TraceComponent tc = Tr.register(SharedLogWriter.class, null, "com.ibm.ejs.resources.RasMessages");
    private static final int QUEUE_CHECK_INTERVAL_TIME = 5000;
    private static final int MAX_QUEUE_DEPTH = 200;
    private static String svFqFileName = null;
    private static File svFile = null;
    private static String svFqLockFileName = null;
    private static File svLockFile = null;
    static int svFileLength;
    static int svMaxMessageSize;
    private static SharedLogWriter svSharedLogWriter;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private boolean ivUsable;
    private boolean ivVerifyCompleted;
    private boolean ivRecovered;
    private Vector ivUnwrittenEvents;
    private long ivFirstErrorTime;
    private boolean ibQueuedEventThreadRunning;

    static synchronized SharedLogWriter getInstance() {
        if (svSharedLogWriter == null) {
            try {
                svSharedLogWriter = new SharedLogWriter();
            }
            catch (Throwable t) {
                svSharedLogWriter = null;
            }
        }
        return svSharedLogWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SharedLogWriter() throws RasException {
        block14: {
            this.ivUsable = false;
            this.ivVerifyCompleted = false;
            this.ivRecovered = false;
            this.ivUnwrittenEvents = null;
            this.ivFirstErrorTime = 0L;
            this.ibQueuedEventThreadRunning = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SharedLogWriter - ctor");
            }
            svFqFileName = RasProperties.getActivityLogName();
            svFileLength = RasProperties.getActivityLogSize();
            svFqLockFileName = svFqFileName + ".lck";
            svLockFile = new File(svFqLockFileName);
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
            svMaxMessageSize = svFileLength - 4100;
            if (svMaxMessageSize > 100000) {
                svMaxMessageSize = 100000;
            }
            boolean lockAcquired = false;
            try {
                try {
                    SharedLogWriter.acquireHostLock(svLockFile, false);
                    lockAcquired = true;
                    this.ivUsable = true;
                    this.verifyLogFile(false);
                    this.ivVerifyCompleted = true;
                }
                catch (SharedLogLockException slle) {
                    Object var5_3 = null;
                    if (lockAcquired) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                        Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                        Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                        Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                    }
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "SharedLogWriter - ctor");
                    return;
                }
                catch (RasException re) {
                    this.ivUsable = false;
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, re});
                    throw re;
                }
                catch (IOException ioe) {
                    this.ivUsable = false;
                    RasException e = new RasException(ioe);
                    Tr.error(tc, "MSG_SHARED_LOG_CTOR_FAILED", new Object[]{svFqFileName, e});
                    throw e;
                }
                Object var5_2 = null;
                if (!lockAcquired) break block14;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (lockAcquired) {
                    SharedLogWriter.releaseHostLock(svLockFile);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
                    Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
                    Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
                    Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
                }
                if (!tc.isEntryEnabled()) throw throwable;
                Tr.exit(tc, "SharedLogWriter - ctor");
                throw throwable;
            }
            SharedLogWriter.releaseHostLock(svLockFile);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SharedLogWriter - SharedLog name = " + svFqFileName);
            Tr.debug(tc, "SharedLogWriter - SharedLog Lock name = " + svFqLockFileName);
            Tr.debug(tc, "SharedLogWriter - max message size = " + svMaxMessageSize);
            Tr.debug(tc, "SharedLogWriter - file size = " + svFileLength);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "SharedLogWriter - ctor");
    }

    public void processEvent(LogRecord event2) {
        if (event2.getLevel().intValue() < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        this.logMessage(event2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void logMessage(LogRecord event2) {
        block40: {
            boolean lockAcquired;
            byte[] data;
            RandomAccessFile file;
            block38: {
                SharedLogHeader header;
                if (event2 == null) {
                    return;
                }
                if (!this.ivUsable && this.ivVerifyCompleted) {
                    return;
                }
                file = null;
                data = this.prepareEntry(event2);
                if (data == null || data.length > svMaxMessageSize) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - message size is invalid", data);
                    }
                    return;
                }
                lockAcquired = false;
                SharedLogWriter.acquireHostLock(svLockFile, false);
                lockAcquired = true;
                if (!this.ivVerifyCompleted) {
                    this.ivUsable = true;
                    this.verifyLogFile(true);
                    this.ivVerifyCompleted = true;
                }
                file = this.createRandomAccessFile(svFqFileName, "rw");
                try {
                    header = new SharedLogHeader(file);
                }
                catch (IOException ioe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - failed reading header for file, attempting recovery", ioe);
                    }
                    this.recoverFile(file);
                    this.ivRecovered = true;
                    header = new SharedLogHeader(file);
                }
                this.writeEvent(file, header, data);
                Object var11_9 = null;
                if (file == null) break block38;
                try {
                    file.close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (lockAcquired) {
                SharedLogWriter.releaseHostLock(svLockFile);
            }
            break block40;
            {
                catch (SharedLogLockException slle) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - caught SharedLogLockException", slle);
                    }
                    try {
                        if (this.ivUnwrittenEvents == null) {
                            this.ivUnwrittenEvents = new Vector(10);
                            this.ivUnwrittenEvents.addElement(data);
                            this.ivFirstErrorTime = System.currentTimeMillis();
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Added message to queue.  Current queue size is " + this.ivUnwrittenEvents.size());
                            }
                        } else {
                            long currentTime = System.currentTimeMillis();
                            if (currentTime - this.ivFirstErrorTime < 600000L) {
                                int queueSize = this.ivUnwrittenEvents.size();
                                while (queueSize + 1 > 200) {
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "SharedLogWriter queue contains " + queueSize + " entries.  Deleting oldest one to make room for newer entry.");
                                    }
                                    this.ivUnwrittenEvents.remove(0);
                                    queueSize = this.ivUnwrittenEvents.size();
                                }
                                this.ivUnwrittenEvents.addElement(data);
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Added message to queue.  Current queue size is " + this.ivUnwrittenEvents.size());
                                }
                            } else {
                                this.ivUsable = false;
                                Tr.removeWsHandler(this);
                                Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", slle);
                            }
                        }
                        if (!this.ibQueuedEventThreadRunning) {
                            this.startSharedLogWriterHelper();
                        }
                    }
                    catch (RasException re) {
                        this.ivUsable = false;
                        Tr.removeWsHandler(this);
                        Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", slle);
                    }
                    Object var11_10 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    if (lockAcquired) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                    break block40;
                }
                catch (Throwable t) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - caught exception", t);
                    }
                    this.ivUsable = false;
                    Tr.removeWsHandler(this);
                    Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", t);
                    Object var11_11 = null;
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    if (lockAcquired) {
                        SharedLogWriter.releaseHostLock(svLockFile);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
                if (lockAcquired) {
                    SharedLogWriter.releaseHostLock(svLockFile);
                }
                throw throwable;
            }
        }
    }

    private void writeEvent(RandomAccessFile file, SharedLogHeader header, byte[] data) throws IOException {
        this.writeQueuedEvents(file, header);
        this.writeDataAndHeader(file, header, data);
    }

    private void writeQueuedEvents(RandomAccessFile file, SharedLogHeader header) throws IOException {
        if (this.ivUnwrittenEvents != null) {
            int size = this.ivUnwrittenEvents.size();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Attempting to write " + size + " messages from queue.");
            }
            for (int i = 0; i < size; ++i) {
                byte[] entry = (byte[])this.ivUnwrittenEvents.elementAt(i);
                this.writeDataAndHeader(file, header, entry);
            }
            this.ivUnwrittenEvents = null;
        }
    }

    private byte[] prepareEntry(LogRecord event2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare entry");
        }
        try {
            this.baos.reset();
            this.dos.write(svEntryHeader, 0, svEntryHeader.length);
            this.dos.writeInt(0);
            WsLogRecordHelper.writeEventToStream(event2, this.dos);
            this.dos.write(svEntryTrailer, 0, svEntryTrailer.length);
            byte[] byteData = this.baos.toByteArray();
            int firstIndex = svEntryHeader.length;
            int utfLength = byteData.length - 12;
            int i = 0;
            int shift = 24;
            while (i < 4) {
                byteData[firstIndex + i] = (byte)(0xFF & utfLength >> shift);
                ++i;
                shift -= 8;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry");
            }
            return byteData;
        }
        catch (IOException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare entry", e);
            }
            return null;
        }
    }

    private void writeDataAndHeader(RandomAccessFile file, SharedLogHeader header, byte[] data) throws IOException {
        int nextByte;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeDataAndHeader");
        }
        int curFreeSpace = header.ivFreeSpace;
        int dataLength = data.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - writing " + dataLength + " bytes to  location " + curFreeSpace);
        }
        if (curFreeSpace + dataLength <= header.ivMaxSize) {
            file.seek(curFreeSpace);
            file.write(data);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - data wraps");
            }
            int firstHalfSize = header.ivMaxSize - curFreeSpace;
            int secondHalfSize = dataLength - firstHalfSize;
            byte[] firstData = new byte[firstHalfSize];
            System.arraycopy(data, 0, firstData, 0, firstHalfSize);
            byte[] secondData = new byte[secondHalfSize];
            System.arraycopy(data, firstHalfSize, secondData, 0, secondHalfSize);
            file.seek(curFreeSpace);
            file.write(firstData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - firstHalf writing " + firstHalfSize + " bytes to  location " + curFreeSpace);
            }
            header.ivFileWrapped = true;
            file.seek(SharedLogHeader.DATA_AREA_OFFSET);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeDataAndHeader - 2ndHalf writing " + secondHalfSize + " bytes to  location " + SharedLogHeader.DATA_AREA_OFFSET);
            }
            file.write(secondData);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - write complete, filePointer = " + file.getFilePointer());
        }
        if ((nextByte = (int)file.getFilePointer()) == header.ivMaxSize) {
            header.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
            header.ivFileWrapped = true;
        } else {
            header.ivFreeSpace = nextByte;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeDataAndHeader - freeSpace ptr = " + header.ivFreeSpace);
        }
        header.writeHeader(file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeDataAndHeader");
        }
    }

    private void verifyLogFile(boolean added) throws IOException, RasException {
        RandomAccessFile raFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyLogFile");
        }
        try {
            raFile = this.createRandomAccessFile(svFqFileName, "rw");
        }
        catch (FileNotFoundException fnf) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verifyLogFile caught FileNotFound Exception", fnf);
            }
            throw new RasException("unable to access file " + svFqFileName, fnf);
        }
        if (raFile.length() == 0L) {
            SharedLogHeader sharedLogHeader = new SharedLogHeader(raFile, svFileLength);
        } else {
            this.processExistingFile(raFile, added);
        }
        raFile.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyLogFile");
        }
    }

    private void processExistingFile(RandomAccessFile file, boolean added) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExistingFile");
        }
        SharedLogHeader header = null;
        try {
            header = new SharedLogHeader(file);
        }
        catch (IOException ioe) {
            this.recoverFile(file);
            this.ivRecovered = true;
            header = new SharedLogHeader(file);
        }
        if (header.ivMaxSize != svFileLength) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processExistingFile - changing size of log file");
            }
            try {
                SharedLogReader reader = new SharedLogReader(svFqFileName, true);
                file.setLength(svFileLength);
                header.ivMaxSize = svFileLength;
                header.ivFreeSpace = SharedLogHeader.DATA_AREA_OFFSET;
                header.ivFileWrapped = false;
                header.writeHeader(file);
                boolean done = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processExistingFile - rewriting existing messages");
                }
                do {
                    WsLogRecord event2;
                    if ((event2 = reader.getNextMessage()) == null) {
                        done = true;
                        continue;
                    }
                    this.logMessage(event2.getImpl());
                } while (!done);
            }
            catch (RasException re) {
                if (!added) {
                    Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", re);
                }
                Tr.removeWsHandler(this);
                Tr.warning(tc, "MSG_SHARED_LOG_CHANGE_SIZE_FAILED", re);
                Tr.addWsHandler(this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExistingFile");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recoverFile(RandomAccessFile file) throws IOException {
        block7: {
            block6: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "recoverFile");
                }
                try {
                    try {
                        if (file.length() == 0L) {
                            SharedLogHeader header = new SharedLogHeader(file, svFileLength);
                            Object var4_5 = null;
                            break block6;
                        }
                        file.setLength(0L);
                        SharedLogHeader header = new SharedLogHeader(file, svFileLength);
                        break block7;
                    }
                    catch (IOException e) {
                        if (!tc.isDebugEnabled()) throw e;
                        Tr.debug(tc, "recoverFile - Exception occurred", e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    if (!tc.isEntryEnabled()) throw throwable;
                    Tr.exit(tc, "recoverFile");
                    throw throwable;
                }
            }
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "recoverFile");
            return;
        }
        Object var4_6 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "recoverFile");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void startSharedLogWriterHelper() throws RasException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startSharedLogWriterHelper");
        }
        try {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread sharedLogWriterHelperThread = new Thread((Runnable)new SharedLogWriterHelper(), "SharedLogWriterHelper");
                        sharedLogWriterHelperThread.start();
                        SharedLogWriter.this.ibQueuedEventThreadRunning = true;
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                throw new RasException("Unable to start SharedLogWriterHelper", t);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "startSharedLogWriterHelper");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "startSharedLogWriterHelper");
    }

    static {
        svMaxMessageSize = 100000;
        svSharedLogWriter = null;
    }

    class SharedLogWriterHelper
    implements Runnable {
        SharedLogWriterHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int inactivityCounter = 0;
            int maxInactivityCounter = 180;
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SharedLogWriter sharedLogWriter = SharedLogWriter.this;
                synchronized (sharedLogWriter) {
                    try {
                        if (SharedLogWriter.this.ivUnwrittenEvents == null || SharedLogWriter.this.ivUnwrittenEvents.size() == 0) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "No work for SharedLogWriterHelper for past " + inactivityCounter * 5000 / 1000 + " seconds.");
                            }
                            ++inactivityCounter;
                        } else {
                            inactivityCounter = 0;
                        }
                        if (inactivityCounter >= maxInactivityCounter) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "No work for SharedLogWriterHelper -- terminating thread.");
                            }
                            SharedLogWriter.this.ibQueuedEventThreadRunning = false;
                            return;
                        }
                        boolean success = this.processQueuedEvents();
                        if (!success) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "SharedLogWriterHelper thread terminating");
                            }
                            SharedLogWriter.this.ibQueuedEventThreadRunning = false;
                            return;
                        }
                    }
                    catch (Throwable t) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "SharedLogWriterHelper thread terminating due to caught Throwable.", t);
                        }
                        SharedLogWriter.this.ibQueuedEventThreadRunning = false;
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processQueuedEvents() {
            if (!SharedLogWriter.this.ivUsable && SharedLogWriter.this.ivVerifyCompleted) {
                return false;
            }
            if (SharedLogWriter.this.ivUnwrittenEvents == null || SharedLogWriter.this.ivUnwrittenEvents.size() == 0) {
                return true;
            }
            RandomAccessFile file = null;
            boolean lockAcquired = false;
            try {
                SharedLogHeader header;
                SharedLogBase.acquireHostLock(svLockFile, false);
                lockAcquired = true;
                if (!SharedLogWriter.this.ivVerifyCompleted) {
                    SharedLogWriter.this.ivUsable = true;
                    SharedLogWriter.this.verifyLogFile(true);
                    SharedLogWriter.this.ivVerifyCompleted = true;
                }
                file = SharedLogWriter.this.createRandomAccessFile(svFqFileName, "rw");
                try {
                    header = new SharedLogHeader(file);
                }
                catch (IOException ioe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "log - failed reading header for file, attempting recovery", ioe);
                    }
                    SharedLogWriter.this.recoverFile(file);
                    SharedLogWriter.this.ivRecovered = true;
                    header = new SharedLogHeader(file);
                }
                SharedLogWriter.this.writeQueuedEvents(file, header);
                boolean ioe = true;
                return ioe;
            }
            catch (SharedLogLockException slle) {
                long currentTime;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "log - caught SharedLogLockException", slle);
                }
                if ((currentTime = System.currentTimeMillis()) - SharedLogWriter.this.ivFirstErrorTime >= 600000L) {
                    SharedLogWriter.this.ivUsable = false;
                    Tr.removeWsHandler(svSharedLogWriter);
                    Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", slle);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable t) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "log - caught exception", t);
                }
                SharedLogWriter.this.ivUsable = false;
                Tr.removeWsHandler(svSharedLogWriter);
                Tr.error(tc, "MSG_SHARED_LOG_WRITE_FAILED", t);
                boolean bl = false;
                return bl;
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exc) {}
                }
                if (lockAcquired) {
                    SharedLogBase.releaseHostLock(svLockFile);
                }
            }
        }
    }
}

