/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogConstants;
import com.ibm.ejs.ras.SharedLogLockException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

abstract class SharedLogBase
implements SharedLogConstants {
    private static TraceComponent tc = Tr.register(SharedLogBase.class);

    SharedLogBase() throws RasException {
    }

    static synchronized void acquireHostLock(File aLockFile, boolean allowRetries) throws SharedLogLockException {
        int numberOfRetries = 0;
        boolean success = false;
        boolean firstRecovery = true;
        File lockFile = aLockFile;
        try {
            while (!success) {
                success = RasHelper.createNewFile(lockFile);
                if (success) {
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Contention detected attempting to get SharedLog lock");
                }
                if (!allowRetries || numberOfRetries == 600) {
                    long lockTime;
                    long curTime = System.currentTimeMillis();
                    if (curTime - (lockTime = RasHelper.fileLastModified(lockFile)) > 300000L && firstRecovery) {
                        firstRecovery = false;
                        SharedLogBase.releaseHostLock(aLockFile);
                        numberOfRetries = 0;
                    } else {
                        SharedLogLockException e = new SharedLogLockException("Unable to obtain Shared Log Lock file " + lockFile.getPath());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception detected attempting to get Host Lock", e);
                        }
                        throw e;
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ++numberOfRetries;
            }
        }
        catch (Throwable t) {
            SharedLogLockException e = new SharedLogLockException("Unable to obtain Shared Log Lock file " + lockFile.getPath(), t);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception detected attempting to get Host Lock", e);
            }
            throw e;
        }
    }

    static synchronized void acquireHostLock(File aLockFile) throws SharedLogLockException {
        SharedLogBase.acquireHostLock(aLockFile, true);
    }

    static void releaseHostLock(File lockFile) {
        try {
            RasHelper.deleteFile(lockFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    File copyLogFile(String fileName) throws IOException {
        File fileToReturn = null;
        RandomAccessFile targetFile = null;
        RandomAccessFile sourceFile = null;
        try {
            fileToReturn = this.createTemporaryFile();
            targetFile = this.createRandomAccessFile(fileToReturn.getPath(), "rw");
            sourceFile = this.createRandomAccessFile(fileName, "r");
            this.copyFile(sourceFile, targetFile);
            sourceFile.close();
            targetFile.close();
        }
        catch (IOException ioe) {
            try {
                if (targetFile != null) {
                    targetFile.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
            }
            catch (IOException ioe3) {
                // empty catch block
            }
            throw ioe;
        }
        return fileToReturn;
    }

    private File createTemporaryFile() throws IOException {
        String fileNamePrefix = "wsal";
        String fileNameSuffix = ".log";
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return File.createTempFile("wsal", ".log");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    RandomAccessFile createRandomAccessFile(String fileName, String mode) throws IOException {
        final String tempFileName = fileName;
        final String tempMode = mode;
        try {
            return (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new RandomAccessFile(tempFileName, tempMode);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private void copyFile(RandomAccessFile source, RandomAccessFile target) throws IOException {
        int chunkSize = 4096;
        byte[] buffer = new byte[chunkSize];
        long leftToCopy = source.length();
        boolean done = false;
        source.seek(0L);
        target.seek(0L);
        do {
            if (leftToCopy > (long)chunkSize) {
                source.readFully(buffer);
                target.write(buffer);
                leftToCopy -= (long)chunkSize;
                continue;
            }
            byte[] lastChunk = new byte[(int)leftToCopy];
            source.readFully(lastChunk);
            target.write(lastChunk);
            done = true;
        } while (!done);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTemporaryFile(RandomAccessFile raf, File file) {
        try {
            raf.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            RasHelper.deleteFile(file);
        }
    }
}

