/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;

public abstract class RasEvent
implements Serializable {
    private static final long serialVersionUID = -7870724202058405481L;
    public static final int AUDIT = 1;
    public static final int DEBUG = 2;
    public static final int DUMP = 3;
    public static final int ERROR = 4;
    public static final int EVENT = 5;
    public static final int ENTRY = 6;
    public static final int EXIT = 7;
    public static final int FATAL = 8;
    public static final int SERVICE = 9;
    public static final int WARNING = 10;
    public static final int INFO = 11;
    public static final int UNCOND = 12;
    public static final int SYSOUT = 13;
    public static final int SYSERR = 14;
    public static final int UNKNOWN = 15;
    public static final int FIRST_EVENT = 1;
    public static final int LAST_EVENT = 15;
    static final String[] svTypePrefixes = new String[]{" A ", " d ", " m ", " E ", " e ", " > ", " < ", " F ", " S ", " W ", " I ", " u ", " O ", " R ", " Z "};
    static final String[] typeNames = new String[]{"AUDIT", "DEBUG", "DUMP", "ERROR", "EVENT", "ENTRY", "EXIT", "FATAL", "SERVICE", "WARNING", "INFO", "UNCOND", "SYSTEMOUT", "SYSTEMERR", "UNKNOWN"};
    static final String ibm = "IBM";
    static final String webSphere = "WebSphere";
    static final String appServer = "Application Server";
    static final String emptyString = "";
    static final String nullParamString = "<null>";
    static final String badParamString = "<malformed parameter>";
    private static final int svBasicFormatMaxNameLength = 13;
    static String svBasicPadding = "                                 ";
    static String svAdvancedPadding = "          ";
    static String lineSeparator = RasHelper.getSystemProperty("line.separator");
    String ivOrganization;
    String ivProduct;
    String ivComponent;
    String ivVersion;
    String ivEventSource;
    String ivClassName;
    String ivMethodName;
    String ivThreadId;
    String ivProcessId;
    String ivServerName;
    long ivTimeStamp;
    int ivType;
    String ivMsgKey;
    byte[] ivRawData = null;
    String ivExtendedMessage;
    String ivUnitOfWork;
    transient boolean tivIsJras = false;

    static String getTypeString(int type) {
        if (type < 1 || type > 15) {
            return new String("unknown Type");
        }
        return typeNames[type - 1];
    }

    RasEvent() {
    }

    RasEvent(int type, TraceComponent tc, String className, String methodName, String msgKey, String organization, String product2, String component2, String extendedMessage, boolean fromJras) {
        this.ivType = type < 1 || type > 15 ? 15 : type;
        this.ivEventSource = tc.getName();
        this.tivIsJras = fromJras;
        this.ivOrganization = organization;
        this.ivProduct = product2;
        this.ivComponent = component2;
        this.ivExtendedMessage = extendedMessage;
        this.ivClassName = className;
        this.ivMethodName = methodName;
        this.ivMsgKey = msgKey == null ? "NULL_MESSAGE_KEY_PASSED" : msgKey;
        this.ivVersion = RasHelper.getVersionId();
        this.ivProcessId = RasHelper.getProcessId();
        this.ivServerName = RasHelper.getServerName();
        this.ivTimeStamp = System.currentTimeMillis();
        Thread myThread = Thread.currentThread();
        this.ivThreadId = Integer.toHexString(myThread.hashCode());
        this.ivUnitOfWork = RasContextManager.getUnitOfWork();
    }

    public final long getTimeStamp() {
        return this.ivTimeStamp;
    }

    public String getThreadId() {
        return this.ivThreadId;
    }

    private void formatTimeAndThread(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        int length;
        buffer.setLength(0);
        buffer.append('[');
        date.setTime(this.ivTimeStamp);
        formatter.format(date, buffer, fPos);
        buffer.append("] ");
        for (int i = length = this.ivThreadId.length(); i < 8; ++i) {
            buffer.append(' ');
        }
        buffer.append(this.ivThreadId);
        buffer.append(' ');
    }

    void formatHeaderBasic(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        int tmpLen;
        this.formatTimeAndThread(buffer, formatter, date, fPos);
        String name = null;
        int index = this.ivEventSource.lastIndexOf(46) + 1;
        name = index + 13 >= this.ivEventSource.length() ? this.ivEventSource.substring(index) : this.ivEventSource.substring(index, index + 13);
        buffer.append(name);
        for (int i = tmpLen = 13 - name.length(); i > 0; --i) {
            buffer.append(' ');
        }
        try {
            buffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            buffer.append(" Z ");
        }
        if (this.tivIsJras) {
            buffer.append(this.ivClassName);
            buffer.append(' ');
            buffer.append(this.ivMethodName);
            buffer.append(' ');
        }
    }

    void formatHeaderAdvanced(StringBuffer buffer, DateFormat formatter, Date date, FieldPosition fPos) {
        this.formatTimeAndThread(buffer, formatter, date, fPos);
        try {
            buffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            buffer.append(" Z ");
        }
        if (this.ivUnitOfWork == null) {
            buffer.append("UOW= ");
        } else {
            buffer.append("UOW=");
            buffer.append(this.ivUnitOfWork);
        }
        buffer.append(" source=");
        buffer.append(this.ivEventSource);
        if (this.ivClassName != null) {
            buffer.append(" class=");
            buffer.append(this.ivClassName);
        }
        if (this.ivMethodName != null) {
            buffer.append(" method=");
            buffer.append(this.ivMethodName);
        }
        buffer.append(" org=");
        buffer.append(this.ivOrganization);
        buffer.append(" prod=");
        buffer.append(this.ivProduct);
        buffer.append(" component=");
        buffer.append(this.ivComponent);
    }
}

