/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.RemoteEnumerator;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.GetContextClassLoaderPrivileged;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.csi.TransactionalObject;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.ws.util.dopriv.GetThreadContextAccessorPrivileged;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import javax.transaction.Synchronization;

class RemoteEnumeratorImpl
extends PortableRemoteObject
implements RemoteEnumerator,
Synchronization,
TransactionalObject {
    private static final ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged((PrivilegedAction)new GetThreadContextAccessorPrivileged());
    private FinderHelper helper;
    private ClassLoader contextClassLoader;
    private final SetContextClassLoaderPrivileged contextClassLoaderChanger = new SetContextClassLoaderPrivileged(threadContextAccessor);
    private boolean pushContextChangedTheContextClassLoader;
    private ComponentMetaData componentMetaData;
    private static final TraceComponent tc = Tr.register(RemoteEnumeratorImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.RemoteEnumeratorImpl";

    RemoteEnumeratorImpl(FinderHelper finderhelper) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", finderhelper);
        }
        this.helper = finderhelper;
        this.saveContexts();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public EJBObject[] nextNElements(int n) throws EnumeratorException {
        block5: {
            EJBObject[] eJBObjectArray;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "nextNElements", new Integer(n));
            }
            ClassLoader oldLoader = null;
            try {
                oldLoader = this.pushContext();
                if (this.helper == null) break block5;
                eJBObjectArray = this.helper.enumerateIntoArray(n, true);
                Object var5_4 = null;
                this.popContext(oldLoader);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    this.popContext(oldLoader);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block6;
                    Tr.exit(tc, "nextNElements");
                }
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "nextNElements");
            }
            return eJBObjectArray;
        }
        throw new CollectionCannotBeFurtherAccessedException();
    }

    public EJBObject[] allRemainingElements() throws EnumeratorException {
        block5: {
            EJBObject[] eJBObjectArray;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "allRemainingElements");
            }
            ClassLoader oldLoader = null;
            try {
                oldLoader = this.pushContext();
                if (this.helper == null) break block5;
                eJBObjectArray = this.helper.enumerateIntoArray(true);
                Object var4_3 = null;
                this.popContext(oldLoader);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    this.popContext(oldLoader);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block6;
                    Tr.exit(tc, "allRemainingElements");
                }
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "allRemainingElements");
            }
            return eJBObjectArray;
        }
        throw new CollectionCannotBeFurtherAccessedException();
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "afterCompletion" + status);
            }
            try {
                this.helper.destroy();
                this.helper = null;
                this.destroyContexts();
                PortableRemoteObject.unexportObject((Remote)this);
            }
            catch (RemoteException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.RemoteEnumeratorImpl.afterCompletion", (String)"123", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "Exception discarding RemoteEnumeratorImpl", new Object[]{this, ex});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    protected void saveContexts() {
        GetContextClassLoaderPrivileged classLoaderGetter = new GetContextClassLoaderPrivileged();
        AccessController.doPrivileged((PrivilegedAction)classLoaderGetter);
        this.contextClassLoader = classLoaderGetter.currentClassLoader;
        this.componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
    }

    protected void destroyContexts() {
        this.contextClassLoader = null;
        this.componentMetaData = null;
    }

    protected ClassLoader pushContext() {
        this.contextClassLoaderChanger.newClassLoader = this.contextClassLoader;
        AccessController.doPrivileged((PrivilegedAction)this.contextClassLoaderChanger);
        this.pushContextChangedTheContextClassLoader = this.contextClassLoaderChanger.wasChanged;
        ClassLoader oldClassLoader = this.contextClassLoaderChanger.oldClassLoader;
        this.contextClassLoaderChanger.newClassLoader = null;
        this.contextClassLoaderChanger.oldClassLoader = null;
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(this.componentMetaData);
        return oldClassLoader;
    }

    protected void popContext(ClassLoader oldLoader) {
        ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        if (this.pushContextChangedTheContextClassLoader) {
            this.contextClassLoaderChanger.newClassLoader = oldLoader;
            AccessController.doPrivileged((PrivilegedAction)this.contextClassLoaderChanger);
            this.contextClassLoaderChanger.newClassLoader = null;
            this.contextClassLoaderChanger.oldClassLoader = null;
        }
    }
}

