/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.Remote;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;

class BMFinderHelper
implements FinderHelper {
    private final PersisterHome home;
    private Enumeration enumerationSource = null;
    private Collection collectionSource = null;
    private Iterator collectionIterator = null;
    private boolean isCollection = false;
    private static final TraceComponent tc = Tr.register(BMFinderHelper.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.BMFinderHelper";

    BMFinderHelper(PersisterHome home, Enumeration source) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", home);
        }
        this.home = home;
        this.enumerationSource = source;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    BMFinderHelper(PersisterHome home, Collection source) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", home);
        }
        this.home = home;
        this.collectionSource = source;
        this.collectionIterator = this.collectionSource.iterator();
        this.isCollection = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public EJBObject[] enumerateIntoArray(int count, boolean hydrate) throws EnumeratorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "enumerateIntoArray", new Integer(count));
        }
        Vector<EJBObject> elements = new Vector<EJBObject>();
        try {
            int i;
            if (this.isCollection) {
                for (i = 0; i < count && this.collectionIterator.hasNext(); ++i) {
                    elements.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.home.getBeanWrapper(this.collectionIterator.next())));
                }
            } else {
                for (i = 0; i < count && this.enumerationSource.hasMoreElements(); ++i) {
                    elements.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.home.getBeanWrapper(this.enumerationSource.nextElement())));
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.BMFinderHelper.enumerateIntoArray", (String)"81", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray:", e);
            }
            throw new EnumeratorException("", e);
        }
        if (elements.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray: no more elements");
            }
            throw new NoMoreElementsException();
        }
        Object[] result = new EJBObject[elements.size()];
        elements.copyInto(result);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "enumerateIntoArray: found", new Integer(result.length));
        }
        return result;
    }

    public EJBObject[] enumerateIntoArray(boolean hydrate) throws EnumeratorException {
        return this.enumerateIntoArray(Integer.MAX_VALUE, hydrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        block6: {
            boolean bl;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "isEnumerationExhausted");
            }
            try {
                if (!this.isCollection) break block6;
                bl = this.collectionIterator.hasNext();
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var3_5 = null;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block7;
                    Tr.exit(tc, "isEnumerationExhausted");
                }
                throw throwable;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isEnumerationExhausted");
            }
            return bl;
        }
        boolean bl = this.enumerationSource.hasMoreElements();
        Object var3_4 = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnumerationExhausted");
        }
        return bl;
    }

    public void destroy() {
    }

    public void cacheCustomFinderAccessIntentState() {
    }
}

