/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.csi.J2EENameImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;

public class EJBOAKeyImpl {
    public static final byte HOME_BEAN = 0;
    public static final byte STATELESS_BEAN = 1;
    public static final byte STATEFUL_BEAN = 2;
    public static final byte ENTITY_BEAN = 3;
    public static final byte MESSAGEDRIVEN_BEAN = 4;
    public static final byte USES_BEAN_MANAGED_TX = 16;
    private static final byte[] BEAN_ID_HEADER = new byte[]{-84, -84, 0, 2, 0, 1};
    private static final byte[] WRAPPER_ID_HEADER = new byte[]{-83, -84, 0, 2, 0, 1};
    private static final int BEAN_TYPE_LEN = 1;
    private static final int J2EE_NAME_LEN = 4;
    private static final int PKEY_TYPE_LEN = 1;
    private static final int BEAN_ID_HEADER_LEN = BEAN_ID_HEADER.length;
    private static final int WRAPPER_ID_HEADER_LEN = WRAPPER_ID_HEADER.length;
    private byte[] ivServantKey;
    private boolean ivIsHome = false;
    private byte[] ivJ2eeNameBytes;
    private boolean ivIsJ2eeNameSet = false;
    private boolean ivIsBeanManaged = false;
    private byte ivBeanType;
    private boolean ivIsBeanTypeSet = false;
    private byte[] ivPrimaryKeyBytes;
    private boolean ivIsPrimaryKeySet = false;
    private int ivBeanIdIndex = 0;
    private static final TraceComponent tc = Tr.register(EJBOAKeyImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");

    public EJBOAKeyImpl(byte[] servantkey) {
        this.ivServantKey = servantkey;
        if (this.ivServantKey[0] == WRAPPER_ID_HEADER[0]) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting start of BeanId in serialized WrapperId bytes.");
            }
            this.ivBeanIdIndex = this.getBeanIdIndexFromWrapperId(servantkey);
        }
        int next = this.ivBeanIdIndex;
        for (int i = 0; i < BEAN_ID_HEADER_LEN; ++i) {
            if (this.ivServantKey[next++] == BEAN_ID_HEADER[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, servant key is not a BeanId.");
            }
            throw new IllegalArgumentException("Invalid Servant Key, not a BeanId object");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "EJB type in BeanId: " + this.ivServantKey[next]);
        }
        switch (this.ivServantKey[next]) {
            case 0: {
                this.ivIsHome = true;
                this.ivIsPrimaryKeySet = true;
                break;
            }
            case 17: 
            case 20: {
                this.ivIsPrimaryKeySet = true;
            }
            case 18: {
                this.ivIsBeanManaged = true;
                break;
            }
            case 1: 
            case 4: {
                this.ivIsPrimaryKeySet = true;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to parse bean id: unsupported EJB type: " + this.ivServantKey[next]);
                }
                throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[next]);
            }
        }
    }

    private int getBeanIdIndexFromWrapperId(byte[] servantkey) {
        for (int i = 0; i < WRAPPER_ID_HEADER_LEN; ++i) {
            if (servantkey[i] == WRAPPER_ID_HEADER[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Header mismatch, invalid WrapperId.");
            }
            throw new IllegalArgumentException("Invalid Servant Key, not a WrapperId object");
        }
        int next = WRAPPER_ID_HEADER_LEN + 4;
        int interfaceNameLength = 0;
        interfaceNameLength = EJSPlatformHelper.isZOS() ? (servantkey[next++] & 0xFF) << 24 | (servantkey[next++] & 0xFF) << 16 | (servantkey[next++] & 0xFF) << 8 | servantkey[next++] & 0xFF : servantkey[next++] & 0xFF | (servantkey[next++] & 0xFF) << 8 | (servantkey[next++] & 0xFF) << 16 | (servantkey[next++] & 0xFF) << 24;
        return next + interfaceNameLength;
    }

    public byte[] getJ2EENameBytes() {
        if (!this.ivIsJ2eeNameSet) {
            this.ivJ2eeNameBytes = this.readJ2EENameBytes();
            if (this.ivIsHome) {
                this.ivJ2eeNameBytes = this.readPrimaryKeyBytes();
            }
            this.ivIsJ2eeNameSet = true;
        }
        return this.ivJ2eeNameBytes;
    }

    public boolean isBeanManagedTransaction() {
        if (this.ivIsHome) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Indication of transaction demarcation is not available for home beans. ");
            }
            throw new IllegalStateException("Indication of transaction demarcation is not available for home beans.");
        }
        return this.ivIsBeanManaged;
    }

    public byte getBeanType() {
        if (!this.ivIsBeanTypeSet) {
            if (this.ivIsHome) {
                this.ivBeanType = 0;
            } else {
                switch (this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]) {
                    case 1: 
                    case 17: {
                        this.ivBeanType = 1;
                        break;
                    }
                    case 2: 
                    case 18: {
                        this.ivBeanType = (byte)2;
                        break;
                    }
                    case 4: 
                    case 20: {
                        this.ivBeanType = (byte)4;
                        break;
                    }
                    case 3: {
                        this.ivBeanType = (byte)3;
                        break;
                    }
                    default: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Unsupported EJB type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
                        }
                        throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
                    }
                }
            }
            this.ivIsBeanTypeSet = true;
        }
        return this.ivBeanType;
    }

    public boolean isHome() {
        return this.ivIsHome;
    }

    public byte[] getPrimaryKeyBytes() {
        if (!this.ivIsPrimaryKeySet) {
            if (!this.ivIsJ2eeNameSet) {
                this.getJ2EENameBytes();
            }
            this.ivPrimaryKeyBytes = this.readPrimaryKeyBytes();
            this.ivIsPrimaryKeySet = true;
        }
        return this.ivPrimaryKeyBytes;
    }

    private byte[] readJ2EENameBytes() {
        int j2eeNameLength = 0;
        int j2eeNameIndex = BEAN_ID_HEADER_LEN + 1 + this.ivBeanIdIndex;
        if (EJSPlatformHelper.isZOS()) {
            int ix = j2eeNameIndex;
            j2eeNameLength = (this.ivServantKey[ix] & 0xFF) << 24 | (this.ivServantKey[ix + 1] & 0xFF) << 16 | (this.ivServantKey[ix + 2] & 0xFF) << 8 | this.ivServantKey[ix + 3] & 0xFF;
        } else {
            for (int i = 3; i >= 0; --i) {
                j2eeNameLength ^= this.ivServantKey[j2eeNameIndex + i] & 0xFF;
                if (i <= 0) continue;
                j2eeNameLength <<= 8;
            }
        }
        byte[] temp = new byte[j2eeNameLength];
        System.arraycopy(this.ivServantKey, j2eeNameIndex += 4, temp, 0, j2eeNameLength);
        return temp;
    }

    private byte[] readPrimaryKeyBytes() {
        byte[] pkeyBytes = null;
        try {
            int pkeyIndex = this.ivBeanIdIndex + BEAN_ID_HEADER_LEN + 1 + 4 + this.ivJ2eeNameBytes.length + 1;
            int pkeyLen = this.ivServantKey.length - pkeyIndex;
            pkeyBytes = new byte[pkeyLen];
            System.arraycopy(this.ivServantKey, pkeyIndex, pkeyBytes, 0, pkeyLen);
        }
        catch (Throwable th) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Unable to parse bean id: primary key: " + th);
            }
            throw new IllegalArgumentException("Unable to read primary key bytes.", th);
        }
        return pkeyBytes;
    }

    public String toString() {
        String separator = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("line.separator", "\n"));
        StringBuffer sb = new StringBuffer();
        String sep = "                                 ";
        String sep2 = "                                     ";
        sb.append(separator + sep + "**************    EJBOAKeyImpl Dump    **************");
        sb.append(separator + sep2 + "J2EEName = ");
        J2EENameImpl j2 = new J2EENameImpl(this.getJ2EENameBytes());
        sb.append(j2);
        sb.append(separator + sep2 + "Bean Type = ");
        sb.append(this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
        sb.append(":  ");
        sb.append(this.getBeanTypeString());
        return sb.toString();
    }

    private String getBeanTypeString() {
        String returnString = null;
        switch (this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]) {
            case 0: {
                returnString = "Home Bean";
                break;
            }
            case 17: {
                returnString = "Bean Managed Transaction: Stateless Session Bean";
                break;
            }
            case 1: {
                returnString = "Container Managed Transaction: Stateless Session Bean";
                break;
            }
            case 18: {
                returnString = "Bean Managed Transaction: Stateful Session Bean";
                break;
            }
            case 2: {
                returnString = "Container Managed Transaction: Stateful Session Bean";
                break;
            }
            case 20: {
                returnString = "Bean Managed Transaction: Message Driven Bean";
                break;
            }
            case 4: {
                returnString = "Container Managed Transaction: Message Driven Bean";
                break;
            }
            case 3: {
                returnString = "Entity Bean";
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unsupported EJB type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
                }
                throw new IllegalArgumentException("Unsupported EJB Type: " + this.ivServantKey[this.ivBeanIdIndex + BEAN_ID_HEADER_LEN]);
            }
        }
        return returnString;
    }
}

