/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.webappext.serialization;

import com.ibm.ejs.models.base.extensions.commonext.ResourceRefExtension;
import com.ibm.ejs.models.base.extensions.commonext.serialization.CommonextSAXXMLHandler;
import com.ibm.ejs.models.base.extensions.webappext.MarkupLanguage;
import com.ibm.ejs.models.base.extensions.webappext.Page;
import com.ibm.ejs.models.base.extensions.webappext.ServletCachingConfiguration;
import com.ibm.ejs.models.base.extensions.webappext.ServletExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebappextPackage;
import com.ibm.ejs.models.base.serialization.BaseXMLResourceImpl;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class WebappextSAXXMLHandler
extends CommonextSAXXMLHandler {
    private static final Logger logger = Logger.getLogger("com.ibm.ejs.models.base.extensions.webappext.serialization", "com.ibm.ejs.models.base.extensions.webappext.serialization.messages");
    protected String currentMarkupLanguageDefaultPage;
    protected String currentMarkupLanguageErrorPage;

    public WebappextSAXXMLHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    public void endElement(String uri, String localName, String name) {
        if ("markup-language".equals(localName)) {
            MarkupLanguage markupLanguage = (MarkupLanguage)this.objects.peek();
            Page errorPage = this.getMarkupLanguagePageByName(markupLanguage, this.currentMarkupLanguageErrorPage);
            this.currentMarkupLanguageErrorPage = null;
            if (errorPage != null) {
                markupLanguage.setErrorPage(errorPage);
            }
            Page defaultPage = this.getMarkupLanguagePageByName(markupLanguage, this.currentMarkupLanguageDefaultPage);
            this.currentMarkupLanguageDefaultPage = null;
            if (defaultPage != null) {
                markupLanguage.setDefaultPage(defaultPage);
            }
        }
        super.endElement(uri, localName, name);
    }

    protected URI getDDUriSuffix() {
        return J2EEConstants.WEBAPP_DD_URI_OBJ;
    }

    protected Page getMarkupLanguagePageByName(MarkupLanguage markupLanguage, String name) {
        EList pages = markupLanguage.getPages();
        if (!pages.isEmpty()) {
            for (Page page : pages) {
                if (!page.getName().equals(name)) continue;
                return page;
            }
        }
        return null;
    }

    protected String getRootElementName() {
        return "web-ext";
    }

    protected boolean isRootObject(EObject object) {
        return object instanceof WebAppExtension;
    }

    protected void processElement(String name, String prefix, String localName) {
        String newName = name;
        if ("servlet".equals(localName)) {
            Object currentObject = this.objects.peek();
            newName = currentObject instanceof ServletCachingConfiguration ? WebappextPackage.eINSTANCE.getServletCachingConfiguration_CachedServlets().getName() : WebappextPackage.eINSTANCE.getWebAppExtension_ExtendedServlets().getName();
        }
        super.processElement(newName, prefix, newName);
    }

    protected void setAttribValue(EObject object, String name, String value) {
        if (object instanceof ServletExtension) {
            if ("name".equals(name)) {
                WebAppExtension webAppExtension = this.getWebAppExtension();
                WebApp webApp = webAppExtension.getWebApp();
                if (webApp != null) {
                    Servlet servlet = webApp.getServletNamed(value);
                    if (servlet == null) {
                        logger.logp(Level.WARNING, this.getClass().getName(), "setAttribValue", "Webappext.0", new Object[]{value, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                        servlet = this.createServletWithName(value);
                    }
                    ServletExtension servletExtension = (ServletExtension)object;
                    servletExtension.setExtendedServlet(servlet);
                }
                return;
            }
        } else if (object instanceof ResourceRefExtension) {
            if ("name".equals(name)) {
                WebAppExtension webAppExtension = this.getWebAppExtension();
                WebApp webApp = webAppExtension.getWebApp();
                if (webApp != null) {
                    EList resourceRefs = webApp.getResourceRefs();
                    if (resourceRefs != null && !resourceRefs.isEmpty()) {
                        boolean foundRef = false;
                        for (ResourceRef resourceRef : resourceRefs) {
                            if (!resourceRef.getName().equals(value)) continue;
                            ResourceRefExtension resourceRefExtension = (ResourceRefExtension)object;
                            resourceRefExtension.setResourceRef(resourceRef);
                            foundRef = true;
                        }
                        if (!foundRef) {
                            logger.logp(Level.WARNING, this.getClass().getName(), "setAttribValue", "Webappext.1", new Object[]{value, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                            ResourceRefExtension resourceRefExtension = (ResourceRefExtension)object;
                            resourceRefExtension.setResourceRef(this.createResourceRefWithName(value));
                        }
                    } else {
                        logger.logp(Level.WARNING, this.getClass().getName(), "setAttribValue", "Webappext.2", new Object[]{value, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                        ResourceRefExtension resourceRefExtension = (ResourceRefExtension)object;
                        resourceRefExtension.setResourceRef(this.createResourceRefWithName(value));
                    }
                }
                return;
            }
        } else if (object instanceof MarkupLanguage) {
            if ("error-page".equals(name)) {
                this.currentMarkupLanguageErrorPage = value;
                return;
            }
            if ("default-page".equals(name)) {
                this.currentMarkupLanguageDefaultPage = value;
                return;
            }
        }
        super.setAttribValue(object, name, value);
    }

    protected void setDeploymentDescriptor(EObject deploymentDescriptor) {
        WebAppExtension webAppExtension = this.getWebAppExtension();
        webAppExtension.setWebApp((WebApp)deploymentDescriptor);
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
        Object newValue = value;
        WebappextPackage pkg = WebappextPackage.eINSTANCE;
        if (object instanceof WebAppExtension) {
            if (pkg.getWebAppExtension_ReloadInterval() == feature || pkg.getWebAppExtension_AutoLoadFilters() == feature || pkg.getWebAppExtension_AutoRequestEncoding() == feature || pkg.getWebAppExtension_AutoResponseEncoding() == feature || pkg.getWebAppExtension_DirectoryBrowsingEnabled() == feature || pkg.getWebAppExtension_FileServingEnabled() == feature || pkg.getWebAppExtension_ReloadingEnabled() == feature || pkg.getWebAppExtension_PreCompileJSPs() == feature || pkg.getWebAppExtension_ServeServletsByClassnameEnabled() == feature) {
                newValue = this.attribs.getValue("", "value");
            } else if (pkg.getWebAppExtension_AdditionalClassPath() == feature) {
                newValue = this.attribs.getValue("", "path");
            } else if (pkg.getWebAppExtension_DefaultErrorPage() == feature) {
                newValue = this.attribs.getValue("", "uri");
            } else if (pkg.getWebAppExtension_ContextRoot() == feature) {
                newValue = this.attribs.getValue("", "uri");
            }
        } else if (object instanceof ServletCachingConfiguration) {
            WebAppExtension webAppExtension;
            WebApp webApp;
            if (pkg.getServletCachingConfiguration_Timeout() == feature || pkg.getServletCachingConfiguration_Priority() == feature || pkg.getServletCachingConfiguration_InvalidateOnly() == feature) {
                newValue = this.attribs.getValue("", "value");
            } else if (pkg.getServletCachingConfiguration_ExternalCacheGroups() == feature) {
                newValue = this.attribs.getValue("", "name");
            } else if (pkg.getServletCachingConfiguration_IdGenerator() == feature || pkg.getServletCachingConfiguration_MetadataGenerator() == feature) {
                newValue = this.attribs.getValue("", "class");
            } else if (pkg.getServletCachingConfiguration_CachedServlets() == feature && (webApp = (webAppExtension = this.getWebAppExtension()).getWebApp()) != null) {
                String servletName = ((Servlet)value).getServletName();
                Servlet servlet = webApp.getServletNamed(servletName);
                if (servlet != null) {
                    newValue = servlet;
                } else {
                    logger.logp(Level.WARNING, this.getClass().getName(), "setAttribValue", "Webappext.0", new Object[]{servletName, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                    newValue = this.createServletWithName(servletName);
                }
            }
        }
        super.setFeatureValue(object, feature, newValue, position);
    }

    protected WebAppExtension getWebAppExtension() {
        BaseXMLResourceImpl resource = (BaseXMLResourceImpl)this.xmlResource;
        WebAppExtension webAppExtension = (WebAppExtension)resource.getRootObject();
        return webAppExtension;
    }

    protected Servlet createServletWithName(String name) {
        Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
        servlet.setServletName(name);
        return servlet;
    }
}

