/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.ejbext.serialization;

import com.ibm.ejs.models.base.extensions.ejbext.LifetimeInCacheUsageKind;
import com.ibm.ejs.models.base.extensions.ejbext.serialization.DaysOfTheWeek;
import com.ibm.ejs.models.base.extensions.ejbext.serialization.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CacheLifetimeConverter {
    protected static final long HOURS_IN_DAY = 24L;
    protected static final long MAX_DAYS = 15000L;
    protected static final long MINUTES_IN_HOUR = 60L;
    protected static final long SECONDS_IN_MINUTE = 60L;
    protected static final long SECONDS_IN_HOUR = 3600L;
    protected static final long SECONDS_IN_DAY = 86400L;
    protected long cacheTime;
    protected int days;
    protected long hours;
    protected LifetimeInCacheUsageKind kind;
    protected List messages = new ArrayList();
    protected long minutes;
    protected long seconds;

    public CacheLifetimeConverter(DaysOfTheWeek dayOfTheWeek, String hours, String minutes, String seconds) {
        if (dayOfTheWeek != null) {
            this.days = dayOfTheWeek.getValue();
            this.kind = LifetimeInCacheUsageKind.WEEK_TIME_LITERAL;
            this.convertFromStrings(null, hours, minutes, seconds);
            this.calculateCacheTime();
        } else {
            this.messages.add(Messages.getString("CacheLifetimeConverter.6"));
        }
    }

    public CacheLifetimeConverter(long cacheTime, LifetimeInCacheUsageKind kind) {
        this.cacheTime = cacheTime;
        this.kind = kind;
        this.expandFromSeconds();
    }

    public CacheLifetimeConverter(String hours, String minutes, String seconds) {
        this.kind = LifetimeInCacheUsageKind.CLOCK_TIME_LITERAL;
        this.convertFromStrings(null, hours, minutes, seconds);
        this.calculateCacheTime();
    }

    public CacheLifetimeConverter(String days, String hours, String minutes, String seconds) {
        this.kind = LifetimeInCacheUsageKind.ELAPSED_TIME_LITERAL;
        this.convertFromStrings(days, hours, minutes, seconds);
        this.calculateCacheTime();
    }

    public DaysOfTheWeek getDayOfWeek() {
        if (this.kind != LifetimeInCacheUsageKind.WEEK_TIME_LITERAL) {
            throw new IllegalStateException();
        }
        return DaysOfTheWeek.get(this.days);
    }

    public String getDays() {
        return String.valueOf(this.days);
    }

    public String getHours() {
        return String.valueOf(this.hours);
    }

    public long getLifetimeInCache() {
        return this.cacheTime;
    }

    public List getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public String getMinutes() {
        return String.valueOf(this.minutes);
    }

    public String getSeconds() {
        return String.valueOf(this.seconds);
    }

    public boolean isValid() {
        return this.messages.isEmpty();
    }

    protected final void calculateCacheTime() {
        this.validate();
        if (!this.isValid()) {
            return;
        }
        switch (this.kind.getValue()) {
            case 1: 
            case 3: {
                this.cacheTime = (long)this.days * 86400L + this.hours * 3600L + this.minutes * 60L + this.seconds;
                break;
            }
            case 2: {
                this.cacheTime = this.hours * 3600L + this.minutes * 60L + this.seconds;
                break;
            }
            default: {
                this.messages.add(Messages.getString("CacheLifetimeConverter.0"));
            }
        }
    }

    protected final void convertFromStrings(String days, String hours, String minutes, String seconds) throws NumberFormatException {
        try {
            if (this.kind == LifetimeInCacheUsageKind.ELAPSED_TIME_LITERAL) {
                this.days = Integer.valueOf(days);
            }
            this.hours = Integer.valueOf(hours).intValue();
            this.minutes = Integer.valueOf(minutes).intValue();
            this.seconds = Integer.valueOf(seconds).intValue();
        }
        catch (NumberFormatException e) {
            this.messages.add(e.getMessage());
        }
    }

    protected final void expandFromSeconds() {
        int kindValue = this.kind.getValue();
        switch (kindValue) {
            case 1: 
            case 3: {
                long secondsLeft = this.cacheTime;
                this.days = (int)(secondsLeft / 86400L);
                if (this.days > 0) {
                    secondsLeft -= (long)this.days * 86400L;
                }
                this.hours = secondsLeft / 3600L;
                if (this.hours > 0L) {
                    secondsLeft -= this.hours * 3600L;
                }
                this.minutes = secondsLeft / 60L;
                if (this.minutes <= 0L) break;
                this.seconds = secondsLeft - this.minutes * 60L;
                break;
            }
            case 2: {
                long secondsLeft = this.cacheTime;
                this.hours = secondsLeft / 3600L;
                if (this.hours > 0L) {
                    secondsLeft -= this.hours * 3600L;
                }
                this.minutes = secondsLeft / 60L;
                if (this.minutes <= 0L) break;
                this.seconds = secondsLeft - this.minutes * 60L;
                break;
            }
            default: {
                this.messages.add(Messages.getString("CacheLifetimeConverter.0"));
            }
        }
    }

    protected void validate() {
        int kindValue = this.kind.getValue();
        switch (kindValue) {
            case 1: {
                if (this.days < 0 || (long)this.days > 15000L) {
                    this.messages.add(Messages.getString("CacheLifetimeConverter.1") + 15000L);
                    break;
                }
                this.validateDayTime();
                break;
            }
            case 3: {
                if (this.days > 7) {
                    this.messages.add(Messages.getString("CacheLifetimeConverter.2") + this.days);
                }
                this.validateDayTime();
                break;
            }
            case 2: {
                this.validateDayTime();
                break;
            }
            default: {
                this.messages.add(Messages.getString("CacheLifetimeConverter.0"));
            }
        }
    }

    protected void validateDayTime() {
        if (this.hours < 0L || this.hours > 23L) {
            this.messages.add(Messages.getString("CacheLifetimeConverter.3") + 24L);
            return;
        }
        if (this.minutes < 0L || this.minutes > 59L) {
            this.messages.add(Messages.getString("CacheLifetimeConverter.4") + 60L);
            return;
        }
        if (this.seconds < 0L || this.seconds > 59L) {
            this.messages.add(Messages.getString("CacheLifetimeConverter.5") + 60L);
            return;
        }
    }
}

