/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq.pcf;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class QueueDefinerException
extends Exception {
    private static final long serialVersionUID = -6355882311048045348L;
    protected List errors = new LinkedList();
    private int currentError = 0;
    protected List reasons = new LinkedList();
    private transient ResourceBundle msgBundle;
    private static final String MQ_PCF_TRACE_MESSAGES = "com.ibm.ejs.jms.messaging";
    private Locale locale = Locale.getDefault();

    public QueueDefinerException() {
    }

    public QueueDefinerException(String msg) {
        this.addError(msg, 0);
    }

    public QueueDefinerException(String msg, int reasonCode) {
        this.addError(msg, reasonCode);
    }

    public QueueDefinerException(Locale locale) {
        this.locale = locale;
    }

    public QueueDefinerException(String msg, Locale locale) {
        this.locale = locale;
        this.addError(msg, 0);
    }

    public QueueDefinerException(String msg, int reasonCode, Locale locale) {
        this.locale = locale;
        this.addError(msg, reasonCode);
    }

    public boolean isReason(int reasonCode) {
        return this.reasons.contains(new Integer(reasonCode));
    }

    public String toString() {
        return "com.ibm.ejs.jms.mq.pcf.QueueDefinerException: " + this.errors;
    }

    private String getMessage(String key, Object[] vars) {
        if (this.msgBundle == null) {
            this.msgBundle = ResourceBundle.getBundle(MQ_PCF_TRACE_MESSAGES, this.locale);
        }
        String message = this.msgBundle.getString(key);
        if (vars != null) {
            message = MessageFormat.format(message, vars);
        }
        return message;
    }

    private String getMessage(String key, Object[] vars, Locale locale) {
        if (this.msgBundle == null) {
            this.msgBundle = ResourceBundle.getBundle(MQ_PCF_TRACE_MESSAGES, locale);
        }
        String message = this.msgBundle.getString(key);
        if (vars != null) {
            message = MessageFormat.format(message, vars);
        }
        return message;
    }

    public void addError(String msg, int reasonCode) {
        if (reasonCode == 0) {
            this.errors.add(this.getMessage(msg, null));
        } else {
            this.errors.add(this.getMessage(msg, new Object[]{new Integer(reasonCode)}));
        }
        this.reasons.add(new Integer(reasonCode));
    }

    public void addError(String msg, int reasonCode, Object[] args) {
        this.errors.add(this.getMessage(msg, args));
        this.reasons.add(new Integer(reasonCode));
    }

    public boolean hasMoreErrors() {
        return this.errors.size() > this.currentError;
    }

    public String nextError() {
        return (String)this.errors.get(this.currentError++);
    }
}

