/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.ResRefImpl;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.commonext.ResourceRefExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.ResRef;
import com.ibm.websphere.csi.ResRefList;
import com.ibm.ws.ejb.jar.bnd.AuthenticationAliasType;
import com.ibm.ws.ejb.jar.bnd.CustomLoginConfigurationType;
import com.ibm.ws.ejb.jar.bnd.PropertyType;
import com.ibm.ws.ejb.jar.bnd.ResourceRefType;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.injectionengine.ResolvedResourceRefList;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.annotation.Resource;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResRefListImpl
implements ResRefList,
ResolvedResourceRefList {
    private static final String AUTHENICATION_ALIAS_LOGIN_NAME = "DefaultPrincipalMapping";
    private static final String AUTHENICATION_ALIAS_PROPERTY = "com.ibm.mapping.authDataAlias";
    private String displayName = null;
    private final Vector<ResRef> _resRefVector;
    private String lookupString = null;
    private final String WebSphereCMPConnectionFactory = "comp/PM/WebSphereCMPConnectionFactory";
    private boolean initialized = true;
    private static final TraceComponent tc = Tr.register(ResRefListImpl.class, "EJBContainer", "com.ibm.ejs.container.container");

    public ResRefListImpl(List list) {
        this._resRefVector = new Vector();
        this.initializeResRef(list);
    }

    public ResRefListImpl(String beanName, EnterpriseBean eb, EnterpriseBeanBinding ebb, EnterpriseBeanExtension ebx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> for EJB");
        }
        this._resRefVector = new Vector();
        this.displayName = beanName;
        if (eb != null) {
            this.displayName = eb.getDisplayName();
            if (this.displayName == null) {
                this.displayName = eb.getName();
            }
            EList resourceRefs = eb.getResourceRefs();
            this.initializeResRef((List)resourceRefs, ebb);
            if (null != ebb && eb.isContainerManagedEntity()) {
                CMPConnectionFactoryBinding cmpConnFacBnd = ebb.getCmpConnectionFactory();
                String loginConfigurationName = null;
                EList properties = null;
                if (cmpConnFacBnd != null) {
                    loginConfigurationName = cmpConnFacBnd.getLoginConfigurationName();
                    properties = cmpConnFacBnd.getProperties();
                } else {
                    EJBJarBinding ejbJarBinding = ebb.getModuleBinding();
                    cmpConnFacBnd = ejbJarBinding.getDefaultCMPConnectionFactory();
                    if (cmpConnFacBnd != null) {
                        loginConfigurationName = cmpConnFacBnd.getLoginConfigurationName();
                        properties = cmpConnFacBnd.getProperties();
                    }
                }
                this.initializeFactoryBindings(cmpConnFacBnd, 0, loginConfigurationName, properties);
            }
            if (null != ebx) {
                this.setResRefExtensionData(ebx.getResourceRefExtensions());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> for EJB");
        }
    }

    public ResRefListImpl(WebApp webApp, WebAppExtension webAppExt) {
        this(webApp, webAppExt, null);
    }

    public ResRefListImpl(WebApp webApp, WebAppExtension webAppExt, WebAppBinding web_bindings) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> for WEB");
        }
        this.displayName = webApp.getDisplayName();
        this._resRefVector = new Vector();
        EList resourceRefs = webApp.getResourceRefs();
        this.initializeResRef((List)resourceRefs, web_bindings);
        if (null != webAppExt) {
            this.setResRefExtensionData(webAppExt.getResourceRefExtensions());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "The following list of resource ref's created:");
            Tr.debug(tc, this.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> for WEB");
        }
    }

    private void initializeFactoryBindings(CMPConnectionFactoryBinding cmpConnFacBnd, int sharingScope, String loginConfigurationName, EList properties) {
        String jndiName_CF = null;
        if (null != cmpConnFacBnd) {
            jndiName_CF = cmpConnFacBnd.getJndiName();
            if (jndiName_CF == null) {
                jndiName_CF = "comp/PM/WebSphereCMPConnectionFactory";
            }
            this._resRefVector.add(new ResRefImpl("WebSphere CMP Resource Ref Connection Factory", "comp/PM/WebSphereCMPConnectionFactory", jndiName_CF, "javax.resource.cci.ConnectionFactory", cmpConnFacBnd.getResAuth().getValue() == 1 ? 0 : 1, sharingScope, 0, loginConfigurationName, properties));
        }
    }

    private void setResRefExtensionData(List rrextension) {
        if (rrextension == null) {
            return;
        }
        int size = rrextension.size();
        ResourceRefExtension[] resourceReferenceExtensions = rrextension.toArray(new ResourceRefExtension[size]);
        for (int i = 0; i < size; ++i) {
            ResourceRefExtension resourceReferenceExtension = resourceReferenceExtensions[i];
            String name = resourceReferenceExtension.getResourceRef().getName();
            ResRefImpl resRef = (ResRefImpl)this.findByName(name);
            if (resRef == null) continue;
            int isolationLevel = resourceReferenceExtension.getIsolationLevel().getValue();
            resRef.setIsolationLevel(isolationLevel);
            if (!resourceReferenceExtension.isSetCommitPriority()) continue;
            int commitPriority = resourceReferenceExtension.getCommitPriority();
            resRef.setCommitPriority(commitPriority);
        }
    }

    private void initializeResRef(List list) {
        if (list == null) {
            return;
        }
        int size = list.size();
        ResourceRef[] resourceRef = list.toArray(new ResourceRef[size]);
        for (int i = 0; i < size; ++i) {
            this._resRefVector.add(new ResRefImpl(resourceRef[i].getDescription(), resourceRef[i].getName(), "Jndi Name unknown", resourceRef[i].getType(), resourceRef[i].getAuth().getValue(), resourceRef[i].getResSharingScope().getValue(), 0, null, null));
        }
    }

    private void initializeResRef(List list, EnterpriseBeanBinding ebb) {
        if (null == list) {
            return;
        }
        int size = list.size();
        String resRefBindingName = null;
        if (size > 0) {
            ResourceRef[] resourceRef = list.toArray(new ResourceRef[size]);
            VariableMap variableMap = VariableMapFactory.getVariableMap();
            for (int i = 0; i < size; ++i) {
                ResourceRefBinding rrbinding;
                EList loginProperties = null;
                String loginConfigurationName = null;
                if (null != ebb && null != (rrbinding = ebb.getResRefBinding(resourceRef[i]))) {
                    resRefBindingName = variableMap.expand(rrbinding.getJndiName());
                    loginConfigurationName = rrbinding.getLoginConfigurationName();
                    loginProperties = rrbinding.getProperties();
                }
                if (resRefBindingName == null) {
                    resRefBindingName = "Resource Ref JNDI bindings not set.";
                }
                this._resRefVector.add(new ResRefImpl(resourceRef[i].getDescription(), resourceRef[i].getName(), resRefBindingName, resourceRef[i].getType(), resourceRef[i].getAuth().getValue(), resourceRef[i].getResSharingScope().getValue(), 0, loginConfigurationName, loginProperties));
            }
        }
    }

    private void initializeResRef(List list, WebAppBinding webapp_bindings) {
        if (list == null) {
            return;
        }
        int size = list.size();
        String resRefBindingName = null;
        if (size > 0) {
            ResourceRef[] resourceRef = list.toArray(new ResourceRef[size]);
            for (int i = 0; i < size; ++i) {
                String loginConfigurationName = null;
                EList loginProperties = null;
                if (webapp_bindings != null) {
                    ResourceRefBinding rrbinding = webapp_bindings.getResRefBinding(resourceRef[i]);
                    VariableMap variableMap = VariableMapFactory.getVariableMap();
                    if (rrbinding != null) {
                        resRefBindingName = variableMap.expand(rrbinding.getJndiName());
                        loginConfigurationName = rrbinding.getLoginConfigurationName();
                        loginProperties = rrbinding.getProperties();
                    }
                } else {
                    resRefBindingName = resourceRef[i].getName();
                }
                if (resRefBindingName == null) {
                    resRefBindingName = "Resource Ref JNDI bindings not set.";
                }
                this._resRefVector.add(new ResRefImpl(resourceRef[i].getDescription(), resourceRef[i].getName(), resRefBindingName, resourceRef[i].getType(), resourceRef[i].getAuth().getValue(), resourceRef[i].getResSharingScope().getValue(), 0, loginConfigurationName, loginProperties));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized ResRef findByJNDIName(String s) {
        ResRef resRef;
        block13: {
            block12: {
                resRef = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    if (this.lookupString != null) {
                        Tr.entry(tc, "findByJNDIName " + this.lookupString + "->" + s);
                    } else {
                        Tr.entry(tc, "findByJNDIName direct->" + s);
                    }
                }
                if (!this.initialized) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing exception as the initialization is still not complete " + this.initialized);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "findByJNDIName");
                    }
                    throw new WsRuntimeException("ResRefList is un-initialized");
                }
                if (this.lookupString == null) break block12;
                resRef = this.findByName(this.lookupString);
                if (resRef != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
                    }
                    break block13;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resource Reference name '" + this.lookupString + "' with JNDI Name of '" + s + "' not found. Returning null.");
                        Tr.debug(tc, "*** KNOWN RES-REF LIST BEGIN ***");
                        Tr.debug(tc, this.toString());
                        Tr.debug(tc, "*** KNOWN RES-REF LIST END ***");
                    }
                    throw new WsRuntimeException("Resource Reference not found.");
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "(Info)Direct lookup call. Returning null ResRef.(Not an error condition)");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findByJNDIName");
        }
        return resRef;
    }

    @Override
    public ResRef findByName(String s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findByName " + s);
        }
        Iterator<ResRef> resRefIterator = this._resRefVector.iterator();
        ResRef resRef = null;
        if (s == null) {
            Tr.warning(tc, "MISSING_RESREF_BINDING_CNTR0076W", this.displayName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Incorrect resource reference for " + this.displayName);
            }
            return null;
        }
        while (resRefIterator.hasNext() && !s.equals((resRef = resRefIterator.next()).getName())) {
            resRef = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (resRef == null) {
                Tr.debug(tc, "Resource with name '" + s + "' not found. Returning null.");
            } else {
                Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findByName " + s);
        }
        return resRef;
    }

    @Override
    public int size() {
        return this._resRefVector.size();
    }

    @Override
    public ResRef get(int i) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "get");
        }
        ResRef resRef = null;
        if (i > -1 && i < this._resRefVector.size()) {
            resRef = this._resRefVector.get(i);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (resRef == null) {
                Tr.debug(tc, "Resource with get( " + i + ") not found. Returning null. max i= " + this._resRefVector.size());
            } else {
                Tr.debug(tc, "Returning " + ((ResRefImpl)resRef).toString());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "get");
        }
        return resRef;
    }

    @Override
    public void setLookupString(String lookUp) {
        this.lookupString = lookUp;
    }

    public String toString() {
        String separator = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("line.separator", "\n"));
        String sep = "                                 ";
        StringBuffer sb = new StringBuffer();
        int size = this._resRefVector.size();
        sb.append(separator + sep + "    ******* ResRefList ******* ");
        sb.append(separator + sep + "ResRefList size=" + size);
        for (int i = 0; i < size; ++i) {
            sb.append(((ResRefImpl)this._resRefVector.get(i)).toString());
        }
        return sb.toString();
    }

    public void completeInitialization() {
        this.initialized = true;
    }

    public void setToUnintialized() {
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void add(String name, String jndiName, String classType, Resource.AuthenticationType resAuthType, boolean sharable, String description) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "add");
        }
        int resSharable = sharable ? 0 : 1;
        int authtype = resAuthType == Resource.AuthenticationType.CONTAINER ? 0 : 1;
        ResRefImpl resRef = (ResRefImpl)this.findByName(name);
        if (resRef == null) {
            resRef = new ResRefImpl(description, name, jndiName, classType, authtype, resSharable, 0);
            this._resRefVector.add(resRef);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "new ResRefImpl created for resource ref name = " + name + ", jndiName = " + jndiName);
            }
        } else {
            resRef.setSharingScope(resSharable);
            resRef.setResAuthType(authtype);
            resRef.setDescription(description);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "updated existin ResRefImpl created for resource ref name = " + name + ", jndiName = " + jndiName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    public void addEjbResourceRefType(List<ResourceRefType> rrtList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addEjbModuleResourceRefType");
        }
        if (rrtList != null) {
            for (ResourceRefType rrt : rrtList) {
                ResRefImpl resRef;
                CommonbndFactory commonBndFactory;
                String resRefName = rrt.getName();
                String jndiName = rrt.getBindingName();
                String loginConfigurationName = null;
                BasicEList loginProperties = null;
                CustomLoginConfigurationType clc = rrt.getCustomLoginConfiguration();
                if (clc != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "addEjbModuleResourceRefType creating ResRefImpl for res ref name = " + resRefName + ", using data from JAXB CustomLoginConfiguration");
                    }
                    loginConfigurationName = clc.getName();
                    List<PropertyType> propTypeList = clc.getProperty();
                    if (propTypeList != null) {
                        loginProperties = new BasicEList();
                        commonBndFactory = CommonbndFactory.eINSTANCE;
                        for (PropertyType pt : propTypeList) {
                            Property p = commonBndFactory.createProperty();
                            String propName = pt.getName();
                            String propValue = pt.getValue();
                            p.setName(propName);
                            p.setValue(propValue);
                            loginProperties.add(p);
                        }
                    }
                } else {
                    AuthenticationAliasType alias = rrt.getAuthenticationAlias();
                    if (alias != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "addEjbModuleResourceRefType creating ResRefImpl for res ref name = " + resRefName + ", using data from JAXB AuthenicationAlias");
                        }
                        loginConfigurationName = AUTHENICATION_ALIAS_LOGIN_NAME;
                        commonBndFactory = CommonbndFactory.eINSTANCE;
                        Property p = commonBndFactory.createProperty();
                        p.setName(AUTHENICATION_ALIAS_PROPERTY);
                        p.setValue(alias.getName());
                        loginProperties = new BasicEList();
                        loginProperties.add(p);
                    }
                }
                if ((resRef = (ResRefImpl)this.findByName(resRefName)) == null) {
                    resRef = new ResRefImpl(resRefName, jndiName, loginConfigurationName, loginProperties);
                    this._resRefVector.add(resRef);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "addEjbModuleResourceRefType added ResRefImpl for res ref name = " + resRefName);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addEjbModuleResourceRefType updated ResRefImpl with res ref name = " + resRefName);
                }
                if (loginConfigurationName != null) {
                    resRef.setLoginConfigurationName(loginConfigurationName);
                }
                if (loginProperties == null) continue;
                resRef.setLoginProperties(loginProperties);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addEjbModuleResourceRefType");
        }
    }

    public void addWebModuleResRef(ResourceRefBinding binding) {
        ResourceRef resourceRef = binding.getBindingResourceRef();
        String name = resourceRef.getName();
        ResRefImpl resRef = (ResRefImpl)this.findByName(name);
        if (name == null) {
            resRef = new ResRefImpl(resourceRef.getDescription(), name, "Jndi Name unknown", resourceRef.getType(), resourceRef.getAuth().getValue(), resourceRef.getResSharingScope().getValue(), 0, null, null);
            this._resRefVector.add(resRef);
        }
    }
}

